/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.  */


#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <iodef.h>
#include <descrip.h>
#include <starlet.h>
#include <string.h>
#include <errno.h>

#include <stdlib.h>

char *
getpass (char *prompt)
{
    int status;
    unsigned short chan;
    static $DESCRIPTOR (sys_command, "SYS$COMMAND:");
    unsigned short iosb[4];
    /* Arbitrary limit.  It doesn't seem worth going through multiple
       SYS$QIOW calls and who knows what to get rid of it, I don't
       think.  */
#define BS 256
    static char *buf = NULL;

    if ( buf == NULL ) { buf = malloc( BS );
             if ((buf == NULL) || (buf == (char *)-1)) {perror("getpass malloc error");
                buf=0; return 0;}}
    /* Try to ensure that we avoid stepping on whatever output has
       been sent to stdout.  */
    fflush (stdout);

    status = sys$assign (&sys_command, &chan, 0, 0);
    if (!(status & 1))
	{perror ( "sys$assign failed in getpass");return 0;}
    status = sys$qiow (0, chan, IO$_READPROMPT | IO$M_NOECHO, &iosb, 0, 0,
		       buf, BS - 1, 0, 0, prompt, strlen (prompt));
    if (!(status & 1))
	{perror ("sys$qiow failed in getpass");return 0;}
    if (!(iosb[0] & 1))
	{perror ("sys$qiow (iosb) failed in getpass");return 0;}
    buf[iosb[1]] = '\0';
    status = sys$dassgn (chan);
    if (!(status & 1))
	{perror ( "sys$dassgn failed in getpass");return 0;}
    /* Since there is no echo, we better go to the next line ourselves.  */
    printf ("\n");
    return buf;
}
