 /*F **  Copyright  1992, 2004 by Hunter Goatley.  This code may be freelyE **  distributed for non-commercial purposes as long as this copyright B **  notice is retained.  Modified copies may not be redistributed. */ #define module_name FLIST  #define module_vers "V2.6" /* **  Program:	FLIST ** **  Author:	Hunter Goatley ** **  Date:	November 18, 1992  **C **  Abstract:	Main routine for FLIST, which calls TPU.  This module   **		handles the FLIST callbacks. ** **  Modified by: ** **	V2.6		JP			14-JUN-2004 10:36 7 **		Bump version number to reflect change in FLIST.TPU, = **              plus, remove unused code to get screen width.  **, **	V2.5-3		Hunter Goatley		23-FEB-2004 20:327 **		Bump version number to reflect change in FLIST.TPU.  **! **	V2.5-1		JP			12-FEB-2004 14:00 7 **		Bump version number to reflect change in FLIST.TPU.  ** **	V2.5		JP			 7-JAN-2004 11:20 : **		Send full filename to TPU to allow long names to work. **, **	V2.4-2		Hunter Goatley		25-APR-2001 10:441 **		Add CBT (Contiguous best try) to copy_file().  **, **	V2.4-1		Hunter Goatley		 8-JAN-1999 08:207 **		Bump version number to reflect change in FLIST.TPU.  *** **	V2.4		Hunter Goatley		25-FEB-1998 15:07< **		Add support for 132-column screens.  Also, fix bug where> **		blocks used was sometimes incorrectly shown as "0".  Also,9 **		DEC C-ized the code (no longer needs /STANDARD=VAXC).  *** **	V2.3		Hunter Goatley		30-MAY-1996 18:035 **		Fix calculation of blocks used.  Before, the word = **		FFBYTE was incorrectly retrieved, resulting in occasional @ **		false block counts.  Fixed by add FATDEF struct to FATDEF.H. **+ **	2.2-1		Hunter Goatley		24-MAR-1994 10:14 8 **		It took this long for someone to find the first bug.* **		Fix translate_logical_name accvio bug. **) **	2.2		Hunter Goatley		18-NOV-1992 22:06 + **		C rewrite of original MACRO-32 program.  ** */  
 #ifdef __DECC & #pragma module module_name module_vers #else  #module module_name module_vers  #endif   /* **  The headers....  */ #include <atrdef.h>  #include <descrip.h> #include <fibdef.h>  #include <iodef.h> #include <lnmdef.h>  #include <rms.h> #include <sbkdef.h>  #include <ssdef.h> #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <starlet.h> #include <lib$routines.h>  #include <str$routines.h>   ' #if defined(__alpha) || defined(__ia64) 7 #include "fchdef_alpha.h"	/* Not provided with DEC C */  #else 3 #include <fchdef.h>		/* Provided with VAX C v3.2 */  #endif /* if __alpha */   . #include "fatdef.h"		/* Not provided at all */  % #define DDESC	struct dsc$descriptor_d % #define SDESC	struct dsc$descriptor_s + #define errret(s)	if (!(s & 1)) return (s);     H #define BIG_COPY_BUFFER_SIZE 127*512	/* Number of bytes to READ/WRITE */   /*?  *  Under Alpha, the FIB unions are declared as variant_unions. ?  *  FIBDEF.H includes the definition of __union, which we check 9  *  below to make sure we access the structure correctly.   */ 2 #if defined(__union) && (__union == variant_union) #define FIB$W_FID	fib$w_fid  #else - #define FIB$W_FID	fib$r_fid_overlay.fib$w_fid * #endif  /* #if __union == variant_union */   /* **  EXTERNAL ROUTINE */ int	TPU$CLEANUP(); int	TPU$CONTROL(); int	TPU$EXECUTE_INIFILE(); int	TPU$FILEIO();  int	TPU$HANDLER(); int	TPU$INITIALIZE();   
 #ifdef __DECC  #pragma nostandard #endif globalvalue 
 	TPU$_FILEIO,  	TPU$_CALLUSER,  	TPU$_OPTIONS, 	TPU$_SECTIONFILE, 	TPU$_FILENAME;    globalvalue  	TPU$M_DELETE_CONTEXT, 	TPU$M_DISPLAY,  	TPU$M_SECTION; 
 #ifdef __DECC  #pragma standard #endif  ( /*  A couple of structure definitions */+ struct bpv {				/* Bound procedure value */     int *routine_addr;     long int env; };  - struct itmlst_entry			/* An itemlist entry */  { short buflen;    short itmcod;    char *bufadr;    int *retlen; };    * /* Global variables to make life easier */  , DDESC for_buff;					/* Command line buffer*/< static char retmsg_buff[256];			/* Buffer for return msgs */9 static SDESC retmsg =				/* Descriptor for return msgs */ % 	{sizeof(retmsg_buff), DSC$K_DTYPE_T,  	 DSC$K_CLASS_S, retmsg_buff};   /*( **  Variables used by search_for_files() */ static struct FAB search_fab;  static struct NAM search_nam; - static char search_file_spec[NAM$C_MAXRSS];		 1 static char search_file_expanded[NAM$C_MAXRSS];		 2 static char search_file_resultant[NAM$C_MAXRSS];		   /*" **  Variables used by parse_file() */ static struct FAB parse_fab; static struct NAM parse_nam;   /*! **  Variables used by copy_file()  */ static struct FAB copy_infab;  static struct FAB copy_outfab; static struct RAB copy_inrab;  static struct RAB copy_outrab; static struct NAM copy_nam; + static char copy_resultant[NAM$C_MAXRSS];		   - static $DESCRIPTOR (job_lnmtable, "LNM$JOB");   J /* Variable 'widescreen' removed from here - no longer needed	JP Jun-04 */    N /* This one is used by search_for_files() and check_for_dir(), so it's here */C static char atr_uchar[ATR$S_UCHAR];	/* File characteristics mask */    /* ** FORWARD ROUTINE */ void	initialize_globals	(void); / struct itmlst_entry *initialize_callback(void); @ int	flist_calluser		(int *itmcod, DDESC *inpstr, DDESC *retstr);" int	delete_file	(DDESC *filespec);" int	rename_file	(DDESC *filespec); int	copy_file		(DDESC *instr); int	parse_file		(DDESC *instr); $ int	search_for_files	(DDESC *instr);& int	define_job_logical	(DDESC *instr);- int	delete_job_logical	(DDESC *logical_name); 1 int	translate_logical_name	(DDESC *logical_name);  int	check_for_dir		(void);1 int	format_return_msg	(int istat, DDESC *retstr);      /*
 **  main() ** */ int main(void) { F     struct bpv callback_bpv;		/* Bound procedure value for callback */@     int control_options = 1;		/* Prevent "journaling" message */,     int cleanup_flag = TPU$M_DELETE_CONTEXT;     unsigned long int status;        /*5     **  Initialize all the global FABs and RABs, etc.      */     initialize_globals();        /*N     **  Get the foreign command (a file spec may be given on the command line.     */7     status = lib$get_foreign (&for_buff, 0, &for_buff);        /*8     **  Set up TPU's error handler as our error handler.     */      lib$establish (TPU$HANDLER);       /*F     **  Initialize the bound procedure value for the callback routine.     */<     callback_bpv.routine_addr = (int *) initialize_callback;     callback_bpv.env  = 0;       /*,     **  Call the TPU initialization routine.     */,     status = TPU$INITIALIZE (&callback_bpv);     errret(status);        /*/     **  Let TPU execute the initialization file      */#     status = TPU$EXECUTE_INIFILE();      errret(status);        /*H     **  Turn control over to TPU (and don't print "journaling" message).     */,     status = TPU$CONTROL (&control_options);     errret(status);        /*:     **  We're back....  Tell TPU to clean up after itself.     */     TPU$CLEANUP(&cleanup_flag);   7     return (status);		/* Need to clear INHIB_MSG bit */  }        void initialize_globals(void)  /*  **  Function:	initialize_globals ** **  Functional description:  **> **	This function initializes all of the global structures (the= **	FABs, RABs, and NAM blocks used by more than one routine).  ** **  Formal parameters: ** **	None. ** **  Implicit inputs: **I **	search_fab, search_nam, parse_fab, parse_nam, copy_infab, copy_outfab, . **	copy_inrab, copy_outrab, copy_nam, for_buff ** **  Returns: ** **	Nothing.  ** */ {   @ /* The 3 variables 'tt_d', 'chan', and 'status' which stood hereE    have now been removed, as they are no longer needed 		JP Jun-04 */   &     /* Initialize global structures */>     search_fab = cc$rms_fab;			/* Initialize the search FAB */%     search_fab.fab$l_fop = FAB$M_NAM; ,     search_fab.fab$l_fna = search_file_spec;'     search_fab.fab$l_nam = &search_nam;        search_nam = cc$rms_nam;0     search_nam.nam$l_esa = search_file_expanded;(     search_nam.nam$b_ess = NAM$C_MAXRSS;1     search_nam.nam$l_rsa = search_file_resultant; (     search_nam.nam$b_rss = NAM$C_MAXRSS;  <     parse_fab = cc$rms_fab;			/* Initialize the parse FAB */$     parse_fab.fab$l_fop = FAB$M_NAM;%     parse_fab.fab$l_nam = &parse_nam;   <     parse_nam = cc$rms_nam;			/* Initialize the parse NAM *//     parse_nam.nam$l_esa = retmsg.dsc$a_pointer; '     parse_nam.nam$b_ess = NAM$C_MAXRSS; '     parse_nam.nam$b_nop = NAM$M_SYNCHK;   >     copy_infab = cc$rms_fab;			/* Initialize copy input FAB */1     copy_infab.fab$b_fac = FAB$M_BIO | FAB$M_GET; (     copy_infab.fab$b_shr = FAB$M_SHRGET;       copy_inrab = cc$rms_rab;'     copy_inrab.rab$l_fab = &copy_infab; %     copy_inrab.rab$b_rac = RAB$C_SEQ; 0     copy_inrab.rab$w_usz = BIG_COPY_BUFFER_SIZE;B     copy_inrab.rab$l_ubf = (char *) malloc (BIG_COPY_BUFFER_SIZE);'     if (copy_inrab.rab$l_ubf == NULL) {  	printf("Memory exhausted\n"); 	sys$exit(SS$_ABORT);      }        /*2     **  copy_outfab is initialized by copy_file().     */     copy_outrab = cc$rms_rab; )     copy_outrab.rab$l_fab = &copy_outfab; &     copy_outrab.rab$b_rac = RAB$C_SEQ;1     copy_outrab.rab$w_usz = BIG_COPY_BUFFER_SIZE; 1     copy_outrab.rab$l_rbf = copy_inrab.rab$l_ubf;        copy_nam = cc$rms_nam;(     copy_nam.nam$l_rsa = copy_resultant;&     copy_nam.nam$b_rss = NAM$C_MAXRSS;       for_buff.dsc$w_length = 0;)     for_buff.dsc$b_dtype = DSC$K_DTYPE_T; )     for_buff.dsc$b_class = DSC$K_CLASS_D; "     for_buff.dsc$a_pointer = NULL;  @ /* Code to assign, sensemode and deassign TT: (to get the screenD    width) removed from here as it is no longer used - JP Jun 2004 */   }   / struct itmlst_entry *initialize_callback (void)  /*! **  Function:	initialize_callback  ** **  Functional description:  **B **	This routine is the TPU initialization callback routine.  It is; **	called by TPU$INITIALIZE to establish TPU defaults, etc.  ** **  Formal parameters: ** **	None. ** **  Implicit inputs: ** **	for_buff  ** **  Returns: **: **	Pointer to an item list containing the TPU information. ** */ { ,    char *section_name = "FLIST_TPU_SECTION";    int options; .    static struct bpv fileio_bpv, calluser_bpv;-    static struct itmlst_entry init_itmlst[] =  	{ {4, 0, 0, 0}, 	  {4, 0, 0, 0}, 	  {4, 0, 0, 0}, 	  {0, 0, 0, 0}, 	  {0, 0, 0, 0}, 	  {0, 0, 0, 0}};   '    init_itmlst[0].itmcod = TPU$_FILEIO; )    init_itmlst[1].itmcod = TPU$_CALLUSER; (    init_itmlst[2].itmcod = TPU$_OPTIONS;,    init_itmlst[3].itmcod = TPU$_SECTIONFILE;)    init_itmlst[4].itmcod = TPU$_FILENAME;   0    fileio_bpv.routine_addr = (int *) TPU$FILEIO;    fileio_bpv.env	   = 0;   6    calluser_bpv.routine_addr = (int *) flist_calluser;    calluser_bpv.env	   = 0;   0    init_itmlst[0].bufadr = (char *) &fileio_bpv;2    init_itmlst[1].bufadr = (char *) &calluser_bpv;+    options = TPU$M_SECTION | TPU$M_DISPLAY; 0    init_itmlst[2].bufadr = (char *) &options;     0    init_itmlst[3].buflen = strlen(section_name);(    init_itmlst[3].bufadr = section_name;1    init_itmlst[4].buflen = for_buff.dsc$w_length; 2    init_itmlst[4].bufadr = for_buff.dsc$a_pointer;      return(init_itmlst);    }     = int flist_calluser(int *itmcod, DDESC *inpstr, DDESC *retstr)  /* **  Function:	flist_calluser ** **  Functional description:  **G **	This routine is called by the TPU built-in CALL_USER.  It dispatches / **	FLIST requests to the appropriate functions.  ** **  Formal parameters: **) **	int *itmcod	- pointer to the item code A **	DDESC *inpstr	- pointer to dynamic descriptor for input string B **	DDESC *retstr	- pointer to dynamic descriptor for return string ** **  Implicit inputs: **	 **	retmsg  ** **  Returns: ** **	Status in R0. **	String in retstr. ** */ {     int status;	    int x;   ?    retmsg.dsc$w_length = 256;		/* Always reset retmsg length */   @    switch(abs(*itmcod)) {		/* Use absolute value of item code */
       case 1:  	status = delete_file (inpstr);  	break;   
       case 2:  	status = rename_file(inpstr); 	break;   
       case 3:  	status = copy_file(inpstr); 	break;   
       case 4:  /*	printf("EDT file"); */  	break;   
       case 5:  	status = parse_file(inpstr);  	break;   
       case 6: # 	status = search_for_files(inpstr);  	break;   
       case 7: % 	status = define_job_logical(inpstr);  	break;   
       case 8: % 	status = delete_job_logical(inpstr);  	break;   
       case 9: ) 	status = translate_logical_name(inpstr);  	break;          case 10: 	status = check_for_dir(); 	break;          default: 	status = SS$_ABORT;    }      /* C    **  Now call format_return_msg() to format the string that is to F    **  be returned to TPU.  If status indicates an error occurred, the-    **  error message text is returned to TPU.     */ &    format_return_msg (status, retstr);      return SS$_NORMAL;  }     ! int delete_file (DDESC *filespec)  /* **  Function:	delete_file  ** **  Functional description:  **  **	This function deletes a file. ** **  Formal parameters: **B **	DDESC *filespec		- pointer to descriptor for filename to delete ** **  Implicit inputs: **	 **	retmsg  ** **  Returns: **; **	Status in R0.  On success, message is written to retmsg.  ** */ { 2     static $DESCRIPTOR(delete_fao, "!AS deleted");     int status; (     status = lib$delete_file (filespec);     if (status & 1) < 	status = sys$fao (&delete_fao, &retmsg, &retmsg, filespec);     return (status); }      int rename_file (DDESC *instr) /* **  Function:	rename_file  ** **  Functional description:  **; **	This function renames a file by calling LIB$RENAME_FILE.  ** **  Formal parameters: **@ **	DDESC *instr	- pointer to dynamic descriptor for input string **G **	Because TPU only provides one input string to the call_user routine, E **	the two filenames (old and new) are stored as ASCIC strings within  **	the instr variable. ** **  Implicit inputs: **	 **	retmsg  ** **  Returns: **= **	Status in R0.  On success, a message is written to retmsg.  ** */ { 9     static $DESCRIPTOR(rename_fao, "!AS renamed to !AS");      char *cptr;      int status, x;     static SDESC oldfile_d =' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}, 3 		newfile_d = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};      static SDESC resfile_d =' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_D, 0};        /*C     **  Set up oldfile_d descriptor to point to first ASCIC string.      */B     cptr = (char *) instr->dsc$a_pointer;	/* Start at beginning */8     x = (int) *cptr++;				/* Get length of 1st string */=     oldfile_d.dsc$w_length = x;			/* Set up the descriptor */ #     oldfile_d.dsc$a_pointer = cptr;   2     cptr += x;					/* Bump pointer past 1st str */8     x = (int) *cptr++;				/* Get length of 2nd string */=     newfile_d.dsc$w_length = x;			/* Set up the descriptor */ #     newfile_d.dsc$a_pointer = cptr;        /*9     **  Rename the file, putting the result in resfile_d.      */A     status = lib$rename_file (&oldfile_d, &newfile_d, &oldfile_d, ' 			0, 0, 0, 0, 0, 0, 0, &resfile_d, 0);        /*H     **  If the rename was successful, return a message saying so to TPU.     */     if (status & 1) 1 	status = sys$fao (&rename_fao, &retmsg, &retmsg,  		&oldfile_d, &resfile_d);       return (status);   }      int copy_file (DDESC *instr) /* **  Function:	copy_file  ** **  Functional description:  **3 **	This function copies a file using RMS block I/O.  ** **  Formal parameters: **@ **	DDESC *instr	- pointer to dynamic descriptor for input string **G **	Because TPU only provides one input string to the call_user routine, E **	the two filenames (old and new) are stored as ASCIC strings within  **	the instr variable. ** **  Implicit inputs: **	 **	retmsg  ** **  Returns: **= **	Status in R0.  On success, a message is written to retmsg.  ** */ { 0     $DESCRIPTOR (copy_fao, "!AD copied to !AD");     char *cptr;      int status, x;     static SDESC oldfile_d =' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0}, 3 		newfile_d = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};        /*D     **  The file names come in from FLIST (TPU) as two ASCIC stringsG     **  concatenated together to form the string described by the input F     **  descriptor.  The FABs are set to point to the actual filenames     **  in the input string.     */F     cptr = (char *) instr->dsc$a_pointer;	/* Point to string buffer */6     x = (int) *cptr++;				/* x = length of old file */5     copy_infab.fab$b_fns = x;			/* Set the fab fns */f7     copy_infab.fab$l_fna = cptr;		/* Set the fab fna */n  E     status = sys$open (&copy_infab, 0, 0);	/* Try to open the file */u1     errret(status);				/* Return any error     */9  I     status = sys$connect (&copy_inrab, 0, 0);	/* Connect the RAB to it */      errret(status);        /*G     **  Now that the input fab has been set, just copy it to the outputrD     **  fab and clear the appropriate fields.  This ensures that allE     **  FAB fields that should be copied are copied---otherwise, each2F     **  field would have to be copied individually, which is much more.     **  error-prone (typos, new fields, etc.).     */?     copy_outfab = copy_infab;			/* Initialize the output FAB */7       /*E     **  Zero and initialize the appropriate fields in the output fab.      */     copy_outfab.fab$b_shr = 0;     copy_outfab.fab$w_ifi = 0;3     copy_outfab.fab$l_xab = copy_outfab.fab$l_fna =e 		copy_outfab.fab$l_dna = NULL;r2     copy_outfab.fab$b_fac = FAB$M_BIO | FAB$M_PUT;&     copy_outfab.fab$l_nam = &copy_nam;A     copy_outfab.fab$l_fop = FAB$M_CBT;		/* Contiguous best try */	 	c     /*J     **  Now set the filename and default file name using the input string.     */B     copy_outfab.fab$b_dns = x;		/* Old name is the default name */:     copy_outfab.fab$l_dna = cptr;	/* ... for the copy.		*/4     cptr += x;				/* Bump pointer to 2nd string   */;     x = (int) *cptr++;			/* Get the new filename length  */ ;     copy_outfab.fab$b_fns = x;		/* Save them in the FAB.	*/ !     copy_outfab.fab$l_fna = cptr;        /*#     **  Now create the output file.a     */-     status = sys$create (&copy_outfab, 0, 0);1     if (status & 1)r1        status = sys$connect (&copy_outrab, 0, 0);f       if (status & 1) {m 	/*_A 	**  Loop, reading lots of blocks from the input file and writing  	**  them to the output file.  	*/u' 	status = sys$read (&copy_inrab, 0, 0);c 	while (status & 1) {u2 	    copy_outrab.rab$w_rsz = copy_inrab.rab$w_rsz;- 	    status = sys$write (&copy_outrab, 0, 0);c 	    if (status & 1)( 		status = sys$read (&copy_inrab, 0, 0); 	}< 	if (status == RMS$_EOF)		/* If end-of-file was reached,  */7 	   status = SS$_NORMAL;		/* ... change error to OK.	*/u     }d     sys$close (&copy_infab);     sys$close (&copy_outfab);<       /*H     **  If the copy was successful, write a message saying so to retmsg.     */     if (status & 1) { 6 	int x = copy_infab.fab$b_fns, y = copy_nam.nam$b_rsl;/ 	status = sys$fao (&copy_fao, &retmsg, &retmsg,f3 			x, copy_infab.fab$l_fna, y, copy_nam.nam$l_rsa);_     }7       return (status);   }A   T int parse_file (DDESC *instr)e /* **  Function:	parse_file ** **  Functional description:u **E **	This function parses a file spec, returning the file's name, type,cB **	and version number.  Written to avoid multiple calls to the TPU **	built-in file_parse().n ** **  Formal parameters: **E **	DDESC *instr	- pointer to dynamic descriptor for filename to parse= ** **  Implicit inputs: ** **	parse_fab, parse_nam	 ** **  Returns: **< **	Status in R0.  The parsed file name is written to retmsg. ** */ {D    /* I    **  Set up the parse_fab with the address and length of the file name.l    */ .    parse_fab.fab$l_fna = instr->dsc$a_pointer;-    parse_fab.fab$b_fns = instr->dsc$w_length;l      /*TB    **  Parse the file spec.  parse_fab points to the retmsg buffer    */p     sys$parse (&parse_fab, 0, 0);  F    retmsg.dsc$w_length = parse_nam.nam$b_name +		/* Set the proper  */3 			 parse_nam.nam$b_type +		/* length for retmsg */  			 parse_nam.nam$b_ver;      return(SS$_NORMAL);   }u    # int search_for_files (DDESC *instr)  /* **  Function:	search_for_files ** **  Functional description:  **> **	This function is called repeatedly by the FLIST TPU code to8 **	find all files matching the given file specification. ** **  Formal parameters: **B **	DDESC *instr	- pointer to descriptor for the file specification ** **  Implicit inputs: **% **	search_fab, search_nam, atr_uchar,t ** **  Returns: **G **	Status in R0.  On success or "No more files", a filespec is returnedM
 **	in retmsg.t ** */ {rQ    static $DESCRIPTOR (search_fao, "!AD!_!7UL/!7<!UL!> !%D");	/* ! JP Jan 2004 */;=    static long fao_prmlst[5];			/* SYS$FAOL parameter list */   C    static char file_disk[NAM$C_MAXRSS];		/* Name of current disk */b0    static SDESC file_disk_d = {0, DSC$K_DTYPE_T, 		DSC$K_CLASS_S, file_disk};5    static short qio_iosb[4];			/* I/O status block */o    /*aJ    **  Define the File Information Block to be used in the ACP $QIO calls.    */t9    static struct fibdef search_fib;		/* The FIB itself */ ;    static struct fib_descriptor {		/* The FIB descriptor *// 	long size;  	struct fibdef *addr;o7    } search_fib_d = { sizeof(search_fib), &search_fib};a      /*a#    **  Define the Attribute blocks.c    */*E    static struct sbkdef atr_statblk;		/* ACP QIO statistics block  */uH    static char	atr_credate[ATR$S_CREDATE];	/* File creation date	     */E    static struct FATDEF atr_recattr;		/* ACP QIO record attributes */;H    static struct atrdef atr_itmlst[] = {	/* ATR Item List for $QIO    *// 		{ATR$S_STATBLK, ATR$C_STATBLK, &atr_statblk},s. 		{ATR$S_CREDATE, ATR$C_CREDATE, atr_credate},/ 		{ATR$S_RECATTR, ATR$C_RECATTR, &atr_recattr},n, 		{ATR$S_UCHAR,   ATR$C_UCHAR,   atr_uchar},
 		{0, 0, 0}};n  :    static int device_chan = 0;			/* I/O channel to disk */    int status;    int length;  9    length = instr->dsc$w_length;		/* Get string length */;    /*uF    **  If the specified file is different from the last one used, then    **  call $PARSE again./    */n*    if ((length != search_fab.fab$b_fns) ||K       (strncmp(instr->dsc$a_pointer, search_fab.fab$l_fna, length) != 0)) {a 	/*BA 	 *  A new search file specification has been given on this call. < 	 *  Copy the file spec to our local storage (the search_fab& 	 *  already points to this data area. 	 */ 	search_fab.fab$b_fns = length;*= 	strncpy(search_fab.fab$l_fna, instr->dsc$a_pointer, length); ( 	status = sys$parse (&search_fab, 0, 0); 	errret(status);    }      /*dG    **  Call $SEARCH, using the passed in (or saved) file specification.i    */ J    status = sys$search (&search_fab, 0, 0);	/* Call the $SEARCH service */  =    if (status == RMS$_NMF) {			/* No more files?  If so,   */I9 	retmsg.dsc$w_length = 0;		/* ... set the return msg   */ 6 	return (SS$_NORMAL);			/* ... length to 0 return   */    }  2    errret(status);				/* Return any other error */      /**I    **  Copy the file id returned in the NAM block to the File Information     **  Block for the ACP $QIOs.(    */l5    search_fib.FIB$W_FID[0] = search_nam.nam$w_fid[0];r5    search_fib.FIB$W_FID[1] = search_nam.nam$w_fid[1]; 5    search_fib.FIB$W_FID[2] = search_nam.nam$w_fid[2];;      /* I    **  See if it's the same device.  If not, save the new device name and '    **  assign a channel to that device.     */n!    length = search_nam.nam$b_dev;i.    if ((length != file_disk_d.dsc$w_length) ||N       (strncmp(search_nam.nam$l_dev, file_disk_d.dsc$a_pointer, length) != 0)) 	{# 	file_disk_d.dsc$w_length = length;cB 	strncpy(file_disk_d.dsc$a_pointer, search_nam.nam$l_dev, length);  4 	if (device_chan != 0)			/* If there's a chennel, */7 	    sys$dassgn (device_chan);		/* ... get rid of it *//   	/* . 	**  Assign an I/O channel to the disk device. 	*/ ; 	status = sys$assign (&file_disk_d, &device_chan, 0, 0, 0);e 	errret(status);    } /* if ((length.... */      /*uH    **  Call $QIO to ask the ACP to return information for the file whose%    **  file ID was stored in the FIB.     */h<    status = sys$qiow (0, device_chan, IO$_ACCESS, &qio_iosb,1 			0, 0, &search_fib_d, 0, 0, 0, &atr_itmlst, 0); ,    errret(status);				/* Return any error */E    if (!(qio_iosb[0]&1)) return (qio_iosb[0]);	/* Check IOSB too   */a      /*rC    **  Now copy the information to the $FAOL parameter list for the     **  call to $FAOL.i    */hD    fao_prmlst[0] = search_nam.nam$b_name +	/* Length of file name */ 		   search_nam.nam$b_type + 		   search_nam.nam$b_ver;K    fao_prmlst[1] = (long) search_nam.nam$l_name;	/* Address of file name */       /*s>    **  For PDP-11 compatibility, the End-of-file block and theA    **  filesize are stored with the high- and low-words swapped. uC    **  Before they can be put in the $FAO arglst, we have to rotatey,    **  them so they're in the correct order.    **c;    **  When the end-of-file position corresponds to a blockyC    **  boundary, by convention FAT$L_EFBLK contains the end-of-fileU/    **  VBN plus 1, and FAT$W_FFBYTE contains 0.a    */IO    fao_prmlst[2] = (atr_recattr.fat$w_efblkh << 16) | atr_recattr.fat$w_efblkl;xE    if (fao_prmlst[2] == 0)	/* If EFBLK is 0, use the HIBLK instead */tR       fao_prmlst[2] = (atr_recattr.fat$w_hiblkh << 16) | atr_recattr.fat$w_hiblkl;    elsea= 	if ((fao_prmlst[2] != 0) && (atr_recattr.fat$w_ffbyte == 0)); 	   fao_prmlst[2]--;  7    fao_prmlst[3] = (atr_statblk.sbk$w_filesizh << 16) | ! 		    atr_statblk.sbk$w_filesizl;n  G    fao_prmlst[4] = (long) &atr_credate;		/* The file's creation date */m      /*NB    **  Call $FAOL to format the string to be returned to FLIST for"    **  display in the file buffer.    */cA    status = sys$faol (&search_fao, &retmsg, &retmsg, fao_prmlst);d      return (status);a }d   g% int define_job_logical (DDESC *instr)o /*  **  Function:	define_job_logical ** **  Functional description:t **E **	This function defines a logical in the LNM$JOB logical name table.l ** **  Formal parameters: **@ **	DDESC *instr	- pointer to dynamic descriptor for input string **G **	Because TPU only provides one input string to the call_user routine, E **	the logical and its equivalence string are stored as ASCIC strings  **	within the instr variable.  ** **  Implicit inputs: **	 **	retmsg  ** **  Returns: **= **	Status in R0.  On success, a message is written to retmsg.t ** */ {     char *logical, *equiv;_    int x, status;       static SDESC logical_d =n' 		{0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0},01 		equiv_d = {0, DSC$K_DTYPE_T, DSC$K_CLASS_S, 0};,      /*,@    **  Set uo the descriptors to point to the two ASCIC strings.    */_D    logical = (char *) instr->dsc$a_pointer;	/* Start at beginning */5    x = (int) *logical++;			/* Length of 1st string */ <    logical_d.dsc$w_length = x;			/* Set up the descriptor */%    logical_d.dsc$a_pointer = logical;i  4    logical += x;				/* Bump pointer to 2nd string */5    x = (int) *logical++;			/* Length of 2nd string */ :    equiv_d.dsc$w_length = x;			/* Set up the descriptor */#    equiv_d.dsc$a_pointer = logical;;      /*oB    **  Define the logical in supervisor mode in the LNM$JOB table.    */oB    status = lib$set_logical (&logical_d, &equiv_d, &job_lnmtable);  3    if (status & 1)				/* If successful, return a */.>       retmsg.dsc$w_length = 0;			/* ... null string to TPU  */      return(status);   }r   (, int delete_job_logical (DDESC *logical_name) /*  **  Function:	delete_job_logical ** **  Functional description:a **) **	This routines deassigns a job logical.* ** **  Formal parameters: **C **	DDESC *logical_name	- pointer to descriptor for name to deassigno ** **  Implicit inputs: ** **	None. ** **  Returns: ** **	Status in R0. ** */ {d    int status;  =    status = lib$delete_logical (logical_name, &job_lnmtable);*      /*p0    **  If successful, return null string to TPU.    */m    if (status & 1)       retmsg.dsc$w_length = 0;      return(status);   }n   r0 int translate_logical_name (DDESC *logical_name) /*$ **  Function:	translate_logical_name ** **  Functional description:c *** **	This routine translates a logical name. ** **  Formal parameters: **= **	DDESC *logical_name	- pointer to descriptor for logical to  **				  translater ** **  Implicit inputs: ** **	None. ** **  Returns: **C **	Status in R0.  If successful, equivalence is returned in retmsg.  ** */ { -    $DESCRIPTOR(lnm$table, "LNM$DCL_LOGICAL"); &    struct {				/* $TRNLNM item list */ 	short length; 	short itmcod; 	char *bufadr; 	unsigned long int retlen;    } trnlnm_itmlst[] = {6 		{LNM$C_NAMLENGTH, LNM$_STRING, 0, 0}, {0, 0, 0, 0}};      /*aD    **  Set up item list so equivalence string is returned in retmsg.    */:4    trnlnm_itmlst[0].bufadr = (retmsg.dsc$a_pointer);F    trnlnm_itmlst[0].retlen = (unsigned long int) &retmsg.dsc$w_length;  G    return (sys$trnlnm (0, &lnm$table, logical_name, 0, trnlnm_itmlst));u   }i e int check_for_dir (void) /* **  Function:	check_for_dirr ** **  Functional description:e **> **	This function checks to see if the last file $SEARCHed is a **	real directory file.p ** **  Formal parameters: ** **	None. ** **  Implicit inputs: ** **	atr_uchar, retmsg ** **  Returns: **@ **	Status in R0 (SS$_NORMAL).  retmsg contains either "Y" or "N"G **	to be returned to TPU indicating whether or not file is a directory.  ** */ {:C   *(retmsg.dsc$a_pointer) = ( (*((unsigned long int *) atr_uchar) &*$ 				  FCH$M_DIRECTORY) ? 'Y' : 'N');   retmsg.dsc$w_length = 1;     return(SS$_NORMAL);=   }d   _0 int format_return_msg (int istat, DDESC *retstr) /* **  Function:	format_return_msgg ** **  Functional description:; **> **	This function formats the string to be returned to TPU.  If? **	istat indicates an error occurred, the error message text isnA **	copied to TPU's return string.  Otherwise, the current content:, **	of retmsg is copied to the return string. ** **  Formal parameters: ** **	int istat	- status valuee> **	DDESC *retstr	- pointer to descriptor for the return string ** **  Implicit inputs: **	 **	retmsgw ** **  Returns: **8 **	Status in R0.  The final message is copied to retstr. ** */ {     int status;      if (!(istat & 1)) {6 	retmsg.dsc$w_length = 256;		/* Reset length to 256 */5 	status = sys$getmsg(istat, &retmsg, &retmsg, 15, 0);r    }  *    status = str$copy_dx (retstr, &retmsg);      return(status);   }K                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      