/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.TimerTask;

import phex.utils.Logger;

public class TransferRateService
{
    private HashSet providerSet;

    public TransferRateService()
    {
        providerSet = new HashSet();
        
        Environment.getInstance().scheduleTimerTask( 
            new SetTimestampTimer(), SetTimestampTimer.TIMER_PERIOD,
            SetTimestampTimer.TIMER_PERIOD );
    }

    public synchronized void registerTransferDataProvider( TransferDataProvider provider )
    {
        providerSet.add( provider );
    }

    public synchronized void unregisterTransferDataProvider( TransferDataProvider provider )
    {
        providerSet.remove( provider );
    }
    
    /**
     * Sets the transfer rate timestamp.
     */
    private class SetTimestampTimer extends TimerTask
    {
        public static final long TIMER_PERIOD = 10000;

        /**
         * @see java.util.TimerTask#run()
         */
        public void run()
        {
            try
            {
                long currentTime = System.currentTimeMillis();
                Iterator iterator = providerSet.iterator();
                while ( iterator.hasNext() )
                {
                    TransferDataProvider provider =
                        ( TransferDataProvider ) iterator.next();
                    provider.setTransferRateTimestamp( currentTime );
                }
            }
            catch ( Throwable th )
            {
                Logger.logError( th );
            }
        }
    }
}