/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: Connection.java,v 1.3 2004/08/21 00:55:50 gregork Exp $
 */
package phex.connection;

import java.io.IOException;
import java.net.Socket;

import phex.common.bandwidth.BandwidthController;
import phex.utils.BandwidthInputStream;
import phex.utils.BandwidthOutputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;

/**
 * 
 */
public class Connection
{
    private Socket socket;
    
    private BandwidthController bandwidthController;
    
    private BandwidthInputStream bandwidthInputStream;
    private BandwidthOutputStream bandwidthOutputStream;
    
    private GnutellaInputStream inputStream;
    private GnutellaOutputStream outputStream;
    
    
    /**
     * Creates a new Connection object for the given socket.
     * 
     * The standard BandwidthController used is the NetworkBandwidthController.
     * @param socket
     */
    public Connection( Socket socket, BandwidthController bandwidthController )
    {
        this.socket = socket;
        this.bandwidthController = bandwidthController;
    }
    
    public void setBandwidthController( BandwidthController bandwidthController )
    {
        this.bandwidthController = bandwidthController;
        if ( bandwidthInputStream != null )
        {
            bandwidthInputStream.setBandwidthController( bandwidthController );
        }
        if ( bandwidthOutputStream != null )
        {
            bandwidthOutputStream.setBandwidthController( bandwidthController );
        }
    }
    
    public Socket getSocket()
    {
        return socket;
    }
    
    public GnutellaInputStream getInputStream()
        throws IOException
    {
        if ( inputStream == null )
        {
            if ( socket == null )
            {
                throw new ConnectionClosedException( "Connection already closed" );
            }
            bandwidthInputStream = new BandwidthInputStream(socket
                .getInputStream(), bandwidthController);
            inputStream = new GnutellaInputStream( bandwidthInputStream );
        }
        return inputStream;
    }

    public GnutellaOutputStream getOutputStream()
        throws IOException
    {
        if ( outputStream == null )
        {
            if ( socket == null )
            {
                throw new ConnectionClosedException( "Connection already closed" );
            }
            bandwidthOutputStream = new BandwidthOutputStream(socket
                .getOutputStream(), bandwidthController);
            outputStream = new GnutellaOutputStream( bandwidthOutputStream );
        }
        return outputStream;
    }
    
    public void disconnect()
    {
        IOUtil.closeQuietly( inputStream );
        inputStream = null;
        IOUtil.closeQuietly( outputStream );
        outputStream = null;
        IOUtil.closeQuietly( socket );
        socket = null;
    }
}
