/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.connection;

import java.io.IOException;

import phex.host.*;
import phex.utils.Logger;


public class OutgoingConnectionDispatcher implements Runnable
{
    public HostAddress hostAddress;

    public OutgoingConnectionDispatcher( )
    {
    }
    
    public void setHostAddressToConnect( HostAddress hostAddress )
    {
        this.hostAddress = hostAddress;
    }

    public void run()
    {
        if ( hostAddress == null )
        {// fetch new host
            connectToNextCaughtHost();
        }
        else
        {
            connectToHostAddress();
        }
    }
    
    private void connectToHostAddress()
    {
        NetworkHostsContainer networkContainer =
            HostManager.getInstance().getNetworkHostsContainer();
        Host host = new Host( hostAddress );
        host.setType( Host.TYPE_OUTGOING );
        networkContainer.addNetworkHost( host );

        try
        {
            ConnectionEngine engine = new ConnectionEngine( host );
            engine.initializeOutgoingConnection();
            engine.processIncomingData();
        }
//        catch ( SocketException exp )
//        {
//            outgoingHost.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
//            HostManager.getInstance().disconnectHost( outgoingHost );
//            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
//        }
//        catch ( ConnectionClosedException exp )
//        {
//            outgoingHost.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
//            HostManager.getInstance().disconnectHost( outgoingHost );
//            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
//        }
//        catch ( ProtocolNotSupportedException exp )
//        {
//            outgoingHost.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
//            HostManager.getInstance().disconnectHost( outgoingHost );
//            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
//        }
        catch ( IOException exp )
        {
            host.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
            HostManager.getInstance().disconnectHost( host );
            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
        }
        catch (Exception e)
        {
            host.setStatus(Host.STATUS_HOST_ERROR, e.getMessage());
            HostManager.getInstance().disconnectHost( host );
            Logger.logWarning( e );
        }
    }
    
    private void connectToNextCaughtHost( )
    {
        NetworkHostsContainer networkContainer =
            HostManager.getInstance().getNetworkHostsContainer();
        CaughtHostsContainer caughtHostContainer =
            HostManager.getInstance().getCaughtHostsContainer();
        HostAddress caughtHost;
        do
        {
            caughtHost = caughtHostContainer.getNextCaughtHost();
            if ( caughtHost == null )
            {
                // nothing is available... just return..
                return;
            }
        }
        while ( networkContainer.isConnectedToHost( caughtHost ) );
        
        Host host = new Host( caughtHost );
        host.setType( Host.TYPE_OUTGOING );
        networkContainer.addNetworkHost( host );

        try
        {
            ConnectionEngine engine = new ConnectionEngine( host );
            engine.initializeOutgoingConnection();
            engine.processIncomingData();
            caughtHostContainer.reportConnectionStatus( caughtHost, true );
        }
        catch ( ConnectionRejectedException exp )
        {
            caughtHostContainer.reportConnectionStatus( caughtHost, true );
            host.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
            HostManager.getInstance().disconnectHost( host );
            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
        }
        catch ( IOException exp )
        {
            caughtHostContainer.reportConnectionStatus( caughtHost, false );
            host.setStatus( Host.STATUS_HOST_ERROR, exp.getMessage() );
            HostManager.getInstance().disconnectHost( host );
            Logger.logMessage( Logger.FINEST, Logger.NETWORK, exp.toString() );
        }
        catch (Exception e)
        {
            caughtHostContainer.reportConnectionStatus( caughtHost, false );
            host.setStatus(Host.STATUS_HOST_ERROR, e.getMessage());
            HostManager.getInstance().disconnectHost( host );
            Logger.logWarning( e );
        }
    }
}