/*
 *  PHEX - The pure-java Gnutella-servant.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.download;

import java.util.Set;

import phex.common.URN;
import phex.host.HostAddress;
import phex.http.HTTPRangeSet;
import phex.msg.GUID;

public interface IDownloadCandidate //extends TransferDataProvider
{
    /**
     * Returns the remote file index.
     */
    public long getFileIndex();

    /**
     * Returns the remote file name.
     */
    public String getFileName();

    /**
     * Returns the resource URN of the file at the download candidate.
     */
    public URN getResourceURN();

    /**
     * Returns the host address of the download candidate.
     */
    public HostAddress getHostAddress();

    /**
     * Sets the state if chat connections are supported or not.
     * @param state true if chat connections are supported, false otherwise.
     */
    public void setChatSupported( boolean state );

    /**
     * Sets the GUID of the candidate. Required for Push transfers.
     */
    public GUID getGUID();

    /**
     * Sets the vendor of the candidates servent.
     */
    public void setVendor( String aVendor );
    
    /**
     * Gets the vendor of the candidates servent.
     */
    public String getVendor( );

    /**
     * Sets the available range set.
     * @param availableRangeSet the available range set.
     */
    public void setAvailableRangeSet( HTTPRangeSet availableRangeSet );

    /**
     * Returns the available range set or null if not set.
     * @return the available range set or null if not set.
     */
    public HTTPRangeSet getAvailableRangeSet( );
    
    /**
     * Returns the map of alt locs already send to this connection. 
     * @return the map of alt locs already send to this connection.
     */
    public Set getSendAltLocsSet();
}