/*
 *  PHEX - The pure-java Gnutella-servant.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.download;

import java.io.File;
import phex.common.*;
import phex.query.*;

public interface IDownloadFile extends TransferDataProvider
{
    /**
     * TODO change return value... use exception to tell the problem
     */
    public boolean addDownloadCandidate( RemoteFile remoteFile );
    public boolean addDownloadCandidate( AlternateLocation altLoc );

    /**
     * Returns the container of all known good alternate download locations or null
     * if the download has no valid file urn.
     * @return the container of all known good alternate download locations or null
     * if the download has no valid file urn.
     */
    public AlternateLocationContainer getGoodAltLocContainer();
    
    /**
     * Returns the container of all known bad alternate download locations or null
     * if the download has no valid file urn.
     * @return the container of all known bad alternate download locations or null
     * if the download has no valid file urn.
     */
    public AlternateLocationContainer getBadAltLocContainer();

    /**
     * The research settings.
     */
    public ResearchSetting getResearchSetting();

    public boolean isDownloadInProgress();
    public boolean isDownloadCompleted();
    public boolean isDownloadStopped();

    public int getCandidatesCount();

    public URN getFileURN();

    /**
     * Returns the file name of the destination file.
     */
    public String getDestinationFileName( );

    /**
     * Sets the new destination filename of a file. You can specify if you like
     * to rename the old file or not. The method can throw a FileHandlingException
     * if you like to have it renamed. Otherwise it can be ignored.
     */
    public void setDestinationFile( File aFile, boolean rename )
        throws FileHandlingException;
}