/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: IDownloadSegment.java,v 1.6 2004/09/15 04:44:41 nxf Exp $
 */
package phex.download;

import phex.common.*;

public interface IDownloadSegment extends TransferDataProvider
{
    /**
     * Returns the start position of the transfer.
     */
    public long getTransferStartPosition();

    /**
     * Sets the size of the data that has been transferred.
     */
    public void setTransferredDataSize( long size );

    /**
     * Indicate that the download is just starting.
     */
    public void downloadStartNotify();

    /**
     * Indicate that the download is not longer running.
     */
    public void downloadStopNotify();
    
    /**
     * Returns the start position of the segment.
     */
    public long getStartOffset();
    
    /**
     * Returns the stop position of the segment.
     */
    public long getEndOffset();

    /**
     * Returns whether the download is taking too long. ie: it's too slow
     */
    public boolean transferTooSlow();

    /**
     * Returns whether the segment is busy. ie: if a worker is allocated to it
     */
    public boolean isBusy();

}
