/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.download;

import java.io.*;
import java.net.*;


import phex.common.*;
import phex.msg.*;

public class PushRequestSleeper
{
    private GUID clientGUID;
    private long fileIndex;

    /**
     * The connection of the remote servent after he conntacts us using the
     * PUSH request.
     */
    private Socket givenSocket;

    public PushRequestSleeper( GUID aClientGUID, long aFileIndex )
    {
        clientGUID = aClientGUID;
        fileIndex = aFileIndex;
    }

    public GUID getGUID()
    {
        return clientGUID;
    }

    /**
     * Returns the file index of the push request.
     */
    public long getFileIndex()
    {
        return fileIndex;
    }

    /**
     * we dont care about index or file name.. importent is that we have a
     * open connection and we try to request what we want through it...
     * @param aGivenSocket
     * @param givenGUID
     * @return
     */
    public synchronized boolean acceptGIVConnection( Socket aGivenSocket, GUID givenGUID )
    {
        if ( !clientGUID.equals( givenGUID ) )
        {
            return false;
        }

        // we have a give from the requested host with the correct id and file
        // name
        givenSocket = aGivenSocket;
        // wake up the sleeper
        notify();
        return true;
    }

    /**
     * Request the candidate socket via a push request. This call blocks until
     * the request times out or the requested host answers.
     * Null is returned if the connection cant be made.
     */
    public synchronized Socket requestSocketViaPush()
    {
        try
        {
            // submit the request
            MsgManager.getInstance().sendPushRequest( this );
        }
        catch ( IOException exp )
        {
            // no push route...
            PushHandler.unregisterPushRequestSleeper( this );
            return null;
        }
        try
        {
            // wait until the host connects to use or the timeout is reached
            wait( ServiceManager.sCfg.mPushTransferTimeout );
        }
        // TODO throwing the interrupted exception instead of catching it
        // could be used for user triggered interruption like STOP button.
        catch ( InterruptedException exp )
        {// dont care...
        }
        // no socket given during sleeping time.
        if ( givenSocket == null )
        {
            PushHandler.unregisterPushRequestSleeper( this );
            return null;
        }
        PushHandler.unregisterPushRequestSleeper( this );
        return givenSocket;
    }
}