/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: ActionViewAbout.java,v 1.1 2004/02/02 19:50:40 gregork Exp $
 */
package phex.gui.actions;


import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import phex.Res;
import phex.common.Environment;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;


/**
*	The ActionViewAbout class performs the operation of displaying the About
*	dialog box describing this program.
*/
public class ActionViewAbout extends FWAction
{
    public ActionViewAbout( )
    {
        super( Localizer.getString( "AboutPhex" ),
            GUIRegistry.getInstance().getIconFactory().getIcon( "About16" ),
            Localizer.getString( "TTTAboutPhex" ),
            new Integer( Localizer.getChar( "AboutPhexMnemonic" ) ),
            null );
    }

    public void actionPerformed(ActionEvent event)
    {
        Object[] objArr =
            {
                Environment.getPhexVendor(),
                Res.getStr("Program.EMail"),
                Res.getStr("Program.Url")
            };
        JOptionPane.showMessageDialog(
            GUIRegistry.getInstance().getMainFrame(),
            Localizer.getFormatedString( "AboutText", objArr ),
            Localizer.getString( "About" ),
            JOptionPane.INFORMATION_MESSAGE);
    }

    public void refreshActionState()
    {
    }
}