/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: MacOsxHandler.java,v 1.1 2004/08/30 16:58:22 gregork Exp $
 */
package phex.gui.common;

import phex.gui.actions.ExitPhexAction;

import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJQuitHandler;

/**
 * Registers the Quit handler of Mac OS X menu to close Phex correct.
 */
public class MacOsxHandler implements MRJQuitHandler
{
    public MacOsxHandler()
    {
        MRJApplicationUtils.registerQuitHandler( this );
    }
    
    public void handleQuit()
    {
        ExitPhexAction.performCloseGUIAction();
    }
}
