/*
 * Created on 13.06.2004
 *
 */
package phex.gui.common.table;

import java.util.Comparator;

/**
 * 
 * @author gkoukkoullis
 */
public abstract class FWSortableTableModel extends FWTableModel
{
    /**
     * Creates a new FWSortableTableModel.
     */
    public FWSortableTableModel( String[] theTableColumns, Class[] theTableClasses )
    {
        super( theTableColumns, theTableClasses );
    }
    
    /**
     * Returns the most comparator that is used for sorting of the cell values
     * in the column. This is used by the FWSortedTableModel to perform the
     * sorting. If not overwritten the method returns null causing the
     * FWSortedTableModel to use a NaturalComparator. It expects all Objects that
     * are returned from getComparableValueAt() to implement the Comparable interface.
     *
     */
    public Comparator getColumnComparator( int column )
    {
        return null;
    }
    
    /**
     * Returns an attribute value that is used for comparing on sorting
     * for the cell at row and column. If not overwritten the call is forwarded
     * to getValueAt().
     * The returned Object is compared via the Comparator returned from
     * getColumnComparator(). If no comparator is specified the returned Object
     * must implement the Comparable interface.
     */
    public Object getComparableValueAt( int row, int column )
    {
        return getValueAt( row, column );
    }
}
