/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: HostAddressComparator.java,v 1.1 2004/04/13 14:33:44 gregork Exp $
 */
package phex.gui.comparator;

import java.net.UnknownHostException;
import java.util.Comparator;

import phex.host.HostAddress;

/**
 * 
 */
public class HostAddressComparator implements Comparator
{
    public int compare(Object o1, Object o2)
    {
        HostAddress ha1 = (HostAddress)o1;
        HostAddress ha2 = (HostAddress)o2;
        
        try
        {
            long ip1l = ha1.getLongHostIP();
            long ip2l = ha2.getLongHostIP();
    
            if ( ip1l < ip2l
               || ( ip1l == ip2l && ha1.getPort() < ha2.getPort() ) )
            {
                return -1;
            }
            else
            {
                return 1;
            }
        }
        catch ( UnknownHostException exp )
        {
            return 1;
        }
    }

}
