/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: NewDownloadDialog.java,v 1.1 2004/08/04 10:09:05 gregork Exp $
 */
package phex.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

import phex.gui.common.DialogBanner;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;

/**
 *
 */
public class NewDownloadDialog extends JDialog
{

    private JTextField urlTF;

    /**
     * @throws java.awt.HeadlessException
     */
    public NewDownloadDialog() throws HeadlessException
    {
        super( GUIRegistry.getInstance().getMainFrame(),
            Localizer.getString( "NewDownload_DialogTitle" ), false );
        prepareComponent();
    }

    /**
     * 
     */
    private void prepareComponent()
    {
        addWindowListener(new WindowAdapter()
            {
                public void windowClosing( WindowEvent evt )
                {
                    closeDialog( );
                }
            }
        );
        CellConstraints cc = new CellConstraints();
        Container contentPane = getContentPane();
        contentPane.setLayout( new BorderLayout() );
        JPanel contentPanel = new JPanel();
        //JPanel contentPanel = new FormDebugPanel();
        contentPane.add( contentPanel, BorderLayout.CENTER );
        
        FormLayout layout = new FormLayout(
            "4dlu, d, 2dlu, d, fill:d:grow, 4dlu", // columns
            "p, 10dlu, p, 10dlu, p, 6dlu, p, 6dlu, p, 3dlu, p 6dlu" ); //row
        PanelBuilder builder = new PanelBuilder( contentPanel, layout );
        
        DialogBanner banner = new DialogBanner();
        builder.add( banner, cc.xywh( 1, 1, 6, 1 ));
        
        JLabel label = new JLabel( Localizer.getString("NewDownload_UrlToDownload") );
        builder.add( label, cc.xy( 2, 3 ));
        
        urlTF = new JTextField( 40 );
        builder.add( urlTF, cc.xywh( 4, 3, 2, 1 ));
        
        builder.addSeparator( Localizer.getString("NewDownload_Examples"), 
            cc.xywh( 2, 5, 4, 1 ) );
        
        JPanel examplesPanel = new JPanel();
        builder.add( examplesPanel, cc.xywh( 2, 7, 4, 1 ) );
        FormLayout examplesLayout = new FormLayout(
            "2dlu, d", // columns
            "p, 3dlu, p" ); //row
        PanelBuilder examplesBuilder = new PanelBuilder( examplesPanel,
            examplesLayout );
        examplesBuilder.addLabel( "http://www.host.com/path/file.zip", 
            cc.xy( 2, 1 ) );
        examplesBuilder.addLabel( "magnet:?xt=urn:sha1:AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPP", 
            cc.xy( 2, 3 ) );
        
        builder.add( new JSeparator(), cc.xywh( 1, 9, 6, 1 ) );
        
        JButton cancelBtn = new JButton( Localizer.getString( "Cancel" ));
        cancelBtn.addActionListener( new ActionListener()
            {
                public void actionPerformed( ActionEvent e )
                {
                    closeDialog();
                }
            });
        JButton okBtn = new JButton( Localizer.getString( "OK" ) );
        okBtn.addActionListener( new ActionListener()
            {
                public void actionPerformed( ActionEvent e )
                {
                    createNewDownload();
                    closeDialog();
                }
            });
        JPanel btnPanel = ButtonBarFactory.buildOKCancelBar( okBtn, cancelBtn);
        builder.add( btnPanel, cc.xywh( 2, 11, 4, 1 ) );
        
        pack();
        setLocationRelativeTo( getParent() );
    }
    
    private void createNewDownload()
    {
        String urlStr = urlTF.getText().trim();
        if ( urlStr.length() == 0 )
        {
            return;
        }
        
        
    }
    
    private void closeDialog( )
    {
        setVisible(false);
        dispose();
    }
}
