/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.dialogs;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.update.UpdateCheckRunner;
import phex.utils.Localizer;

public class UpdateNotificationDialog extends JDialog
{
    private UpdateCheckRunner updateChecker;
    private JCheckBox dontDisplayAgainChkBox;

    public UpdateNotificationDialog( UpdateCheckRunner aChecker )
    {
        super( GUIRegistry.getInstance().getMainFrame(),
            Localizer.getString( "PhexUpdateNotification" ), true );
        updateChecker = aChecker;
        prepareComponent();
    }

    private void prepareComponent()
    {
        addWindowListener(new WindowAdapter()
            {
                public void windowClosing( WindowEvent evt )
                {
                    closeDialog( );
                }
            }
        );

        Container contentPane = getContentPane();
        contentPane.setLayout( new GridBagLayout() );

        GridBagConstraints constraints;

        JPanel pane = new JPanel();
        pane.setLayout( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets( 20, 10, 0, 10 );
            constraints.anchor = GridBagConstraints.CENTER;
        contentPane.add( pane, constraints );

        StringBuffer text = new StringBuffer();
        String releaseVersion = updateChecker.getReleaseVersion();
        String betaVersion = updateChecker.getBetaVersion();
        if ( releaseVersion != null )
        {
            text.append( Localizer.getString( "NewPhexVersionFront" ) );
            text.append( ' ' );
            text.append( releaseVersion );
            text.append( ' ' );
            text.append( Localizer.getString( "NewPhexVersionEnd" ) );
        }
        else if ( betaVersion != null )
        {
            text.append( Localizer.getString( "NewPhexBetaVersionFront" ) );
            text.append( ' ' );
            text.append( betaVersion );
            text.append( ' ' );
            text.append( Localizer.getString( "NewPhexVersionEnd" ) );
        }

        JLabel label = new JLabel( text.toString() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets( 0, 0, 20, 0 );
            constraints.anchor = GridBagConstraints.CENTER;
        pane.add( label, constraints );

        dontDisplayAgainChkBox = new JCheckBox(
            Localizer.getString( "DontShowUpdateNotification" ) );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets( 0, 0, 5, 0 );
            constraints.anchor = GridBagConstraints.CENTER;
        pane.add( dontDisplayAgainChkBox, constraints );

        JSeparator separator = new JSeparator();
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.fill = GridBagConstraints.BOTH;
            constraints.anchor = GridBagConstraints.CENTER;
        contentPane.add( separator, constraints );

        pane = new JPanel();
        pane.setLayout( new GridBagLayout() );
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.insets = new Insets( 5, 10, 5, 10 );
            constraints.anchor = GridBagConstraints.CENTER;
        contentPane.add( pane, constraints );

        JButton okButton = new JButton( Localizer.getString( "OK" ) );
        okButton.setDefaultCapable( true );
        okButton.setRequestFocusEnabled( true );
        okButton.addActionListener( new ActionListener()
            {
                public void actionPerformed( ActionEvent e )
                {
                    saveUpdateNotificationState();
                    closeDialog();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = GridBagConstraints.CENTER;
        pane.add( okButton, constraints );

        setDefaultCloseOperation( JDialog.DISPOSE_ON_CLOSE );
        getRootPane().setDefaultButton( okButton );
        pack();
        setLocationRelativeTo( getParent() );
    }

    private void closeDialog( )
    {
        setVisible(false);
        dispose();
    }

    private void saveUpdateNotificationState()
    {
        boolean showUpdateNotification = !dontDisplayAgainChkBox.isSelected();
        if ( ServiceManager.sCfg.showUpdateNotification != showUpdateNotification )
        {
            ServiceManager.sCfg.showUpdateNotification = showUpdateNotification;
            ServiceManager.sCfg.save();
        }
    }
}