/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.models;

import javax.swing.*;

import phex.event.*;
import phex.host.*;

public class AutoConnectHostsListModel extends AbstractListModel
{
    private CaughtHostsContainer caughtHostsContainer;

    public AutoConnectHostsListModel()
    {
        HostManager hostMgr = HostManager.getInstance();
        caughtHostsContainer = hostMgr.getCaughtHostsContainer();
        caughtHostsContainer.addCaughtHostsChangeListener( new AutoConnectHostsListener() );
    }

    public int getSize()
    {
        return caughtHostsContainer.getAutoConnectHostsCount();
    }

    public Object getElementAt( int row )
    {
        HostAddress host = caughtHostsContainer.getAutoConnectHostAt( row );
        if ( host == null )
        {
            fireIntervalRemoved( this, row, row );
            return "";
        }
        return host;
    }

    private class AutoConnectHostsListener
        implements CaughtHostsChangeListener
    {
        /*public void caughtHostAdded( int position )
        {//ignore
        }

        public void caughtHostRemoved( int position )
        {//ignore
        }*/
        public void caughtHostsChanged( )
        {//ignore
        }

        public void autoConnectHostAdded( int position )
        {
            fireIntervalAdded( this, position, position );
        }
        public void autoConnectHostRemoved( int position )
        {
            fireIntervalRemoved( this, position, position );
        }
    }
}