/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.gui.renderer;

import java.awt.Component;

import javax.swing.JTable;

import phex.common.TransferDataProvider;
import phex.utils.StrUtil;

public class TransferRateCellRenderer extends FWTableCellRenderer
{
    public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column)
    {
        super.getTableCellRendererComponent(table, value,
            isSelected, hasFocus, row, column);

        if ( value instanceof TransferDataProvider )
        {
            TransferDataProvider provider = (TransferDataProvider) value;

            if ( isSelected )
            {// in case of selection always use default color...
                setForeground( table.getSelectionForeground() );
            }
            else
            {
                CellColorHandler.applyCellColor( provider, this );
            }

            long transferredSize = provider.getTransferredDataSize();
            long totalTransferSize = provider.getTransferDataSize();

            int shortTermTransferRate = provider.getShortTermTransferRate();
            int longTermTransferRate = provider.getLongTermTransferRate();
            
            if ( shortTermTransferRate == 0 && longTermTransferRate == 0 )
            {
                if ( provider.getRating() != null )
                    setText( provider.getRating().toString() );
                else
                    setText("");
            }
            else
            {
                long timeRemaining = (long)((totalTransferSize - transferredSize) / (longTermTransferRate + 1));
                timeRemaining = Math.max( 0, timeRemaining );
    
                StringBuffer buffer = new StringBuffer();
    
                // "Instantaneous" transfer rate
                buffer.append( StrUtil.FILE_LENGTH_FORMAT.format(shortTermTransferRate) );
                buffer.append( "/Sec, " );
    
                // Average transfer rate
                buffer.append( StrUtil.FILE_LENGTH_FORMAT.format(longTermTransferRate) );
                buffer.append( "/Sec avg, " );
    
                // Estimated time until completion
                buffer.append( StrUtil.formatSignificantElapsedTime( timeRemaining ) );
                buffer.append( " left" );
    
                // including rating information, if applicable/available.
                // This should probably have its own field eventually
                if ( provider.getRating() != null )
                    buffer.append( " " + provider.getRating() );
                setText( buffer.toString() );
            }
        }
        return this;
    }
}
