/*
 * Created on 05.04.2004
 *
 */
package phex.gui.tabs.network;

import java.awt.Component;

import javax.swing.*;

import phex.gui.common.*;
import phex.gui.common.IconFactory;
import phex.host.*;
import phex.host.FavoriteHost;

/**
 * 
 * @author gkoukkoullis
 */
public class FavoritesListRenderer extends DefaultListCellRenderer
{
    private IconFactory iconFactory;
    
    public FavoritesListRenderer()
    {
        iconFactory = GUIRegistry.getInstance().getIconFactory();
    }
    
    public Component getListCellRendererComponent( JList list, Object value,
        int index, boolean isSelected, boolean cellHasFocus)
    {
        super.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
        
        if ( value instanceof FavoriteHost )
        {
            FavoriteHost host = (FavoriteHost)value;
            HostAddress hostAddress = host.getHostAddress();
            setText( hostAddress.getFullHostName() );
            String countryCode = hostAddress.getCountryCode();
            Icon icon = null;
            if ( countryCode != null && countryCode.length() > 0 )
            {
                icon = iconFactory.getIcon( "Flag_" + countryCode );
            }
            setIcon( icon );
        }
        return this;
    }
}
