/*
 * Created on 02.04.2004
 *
 */
package phex.gui.tabs.network;

import java.awt.event.*;

import javax.swing.*;

import phex.gui.models.FavoritesListModel;
import phex.host.*;
import phex.utils.*;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.*;

/**
 * 
 * @author gkoukkoullis
 */
public class NetFavoritesPanel
    extends JPanel
    //extends FormDebugPanel
{
    private JTextField newFavoriteHostTF;
    private JButton addToFavoritesHostBtn;
    
    private JList favoritesList;
    
    private JButton removeFromFavoritesHostBtn;
    private JButton connectToFavoritesHostBtn;
    
    public NetFavoritesPanel()
    {
        init();
    }
    
    private void init()
    {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout(
            "8dlu, d, 2dlu, d, 8dlu", // columns
            "p, 3dlu, p, 4dlu, p, 2dlu, p, 2dlu, p:grow"); //rows
        PanelBuilder favoritesBuilder = new PanelBuilder( this, layout );
        
        favoritesBuilder.addSeparator( Localizer.getString( "NetworkTab_Favorites" ),
            cc.xywh( 1, 1, 5, 1 ) );
        
        newFavoriteHostTF = new JTextField( 20 );
        favoritesBuilder.add( newFavoriteHostTF, cc.xy( 2, 3 ) );
        
        addToFavoritesHostBtn = new JButton( Localizer.getString( "Add" ) );
        addToFavoritesHostBtn.addActionListener( new AddToFavoritesHostAction() );
        favoritesBuilder.add( addToFavoritesHostBtn, cc.xy( 4, 3 ) );
        
        favoritesList = new JList( new FavoritesListModel() );
        favoritesList.setPrototypeCellValue( "123.123.123.123:12345" );
        favoritesList.setVisibleRowCount( 5 );
        favoritesList.setCellRenderer( new FavoritesListRenderer() );
        favoritesBuilder.add( new JScrollPane( favoritesList ), cc.xywh( 2, 5, 1, 5 ) );
        
        connectToFavoritesHostBtn = new JButton( Localizer.getString( "Connect" ) );
        connectToFavoritesHostBtn.addActionListener( new ConnectToFavoritesHostAction());
        favoritesBuilder.add( connectToFavoritesHostBtn, cc.xy( 4, 5 ) );
        
        removeFromFavoritesHostBtn = new JButton( Localizer.getString( "Remove" ) );
        removeFromFavoritesHostBtn.addActionListener( new RemoveFromFavoritesHostAction());
        favoritesBuilder.add( removeFromFavoritesHostBtn, cc.xy( 4, 7 ) );
    }
    
    private final class RemoveFromFavoritesHostAction implements ActionListener
    {
        public void actionPerformed( ActionEvent e )
        {
            try
            {
                FavoriteHost host = (FavoriteHost) favoritesList.getSelectedValue();
                HostManager hostMgr = HostManager.getInstance();
                hostMgr.getFavoritesContainer().removeBookmarkedHost( host );
            }
            catch ( Exception exp )
            {// catch all errors left
                Logger.logError( exp );
            }
        }
    }
    
    private final class ConnectToFavoritesHostAction implements ActionListener
    {
        public void actionPerformed( ActionEvent e )
        {
            try
            {
                FavoriteHost host = (FavoriteHost) favoritesList.getSelectedValue();
                if ( host == null )
                {// nothing to do..
                    return;
                }
                HostManager hostMgr = HostManager.getInstance();
                // Add new host and connect.
                hostMgr.getNetworkHostsContainer().createOutgoingConnectionToHost(
                    host.getHostAddress() );
            }
            catch ( Exception exp )
            {// catch all errors left
                Logger.logError( exp );
            }
        }
    }
    
    private final class AddToFavoritesHostAction implements ActionListener
    {
        public void actionPerformed( ActionEvent e )
        {
            try
            {
                String host = newFavoriteHostTF.getText();
                host = host.trim();
                if ( host.length() > 0 )
                {
                    try
                    {
                        HostAddress address = new HostAddress( host );
                        HostManager hostMgr = HostManager.getInstance();
                        hostMgr.getFavoritesContainer().addFavorite( 
                            address );
                        newFavoriteHostTF.setText("");
                    }
                    catch ( MalformedHostAddressException exp )
                    {// TODO2 bring friendly error message about wrong format.
                    }
                }                
            }
            catch ( Exception exp )
            {// catch all errors left
                Logger.logError( exp );
            }
        }
    }
}
