/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: IRating.java,v 1.3 2004/09/14 06:44:25 nxf Exp $
 */
package phex.http;

import phex.common.*;
import java.util.Comparator;

public interface IRating
{
    
    /**
     * Create a new IRating object from the given one, involving some sort of calculation
    public IRating derive ( IRating source);
     */

    /**
     * Alter the existing rating based on the addition of the new IRating
     */
    public void accumulate ( IRating source );

    /**
     * hmm I wonder
     */
    public String toString();

    /**
     * Set an attribute of this rating
     */
    public void set ( String key, long value ) throws Exception;

    /**
     *
     */
    public long getValue ();

    public boolean equals (Object obj);

    public int hashCode();
}
