/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: GETRequest.java,v 1.8 2004/07/16 18:01:01 gregork Exp $
 */
package phex.msg;

import java.net.URLDecoder;

import phex.common.URN;

/**
 * <p>
 * Parse a get request to retrieve the file name/index and operation.
 * </p>
 *
 * @deprecated
 */
public class GETRequest
{
    private int fileIndex;
    private URN urn;
    private String filename;
    private boolean isFileRequest;

    /**
     * <p>Create a new GETRequest from a get line.</p>
     * Possible GET lines are:<br>
     * /get/1/foo.txt HTTP/1.1
     * /foo.txt HTTP/1.1
     * /uri-res/N2R?urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB HTTP/1.0
     *
     * <p>Presumably this line of text would have come from a server listening
     * for HTTP 'GET' requests.</p>
     *
     * @param getLine  the line to parse as a GET request
     */
    public GETRequest( String getLine )
    {
        // check if standard get request
        int index = getLine.indexOf( "/get/" );
        if ( index != -1 )
        {// this is a traditional /get/(index)/(file) request
            index += 5;
            isFileRequest = true;
            // find end of index
            int indexEndIdx = getLine.indexOf( "/", index );

            String indexStr = getLine.substring( index, indexEndIdx );
            try
            {
                fileIndex = Integer.parseInt( indexStr );
            }
            catch ( NumberFormatException exp )
            {
                // we need to try check for file name instead for index
                fileIndex = -1;
            }

            // the file name end with the HTTP/ statement string
            int fileEndIdx = getLine.indexOf( " HTTP/", indexEndIdx );
            if ( fileEndIdx == -1 )
            {// no HTTP/ in request assume end of line
                fileEndIdx = getLine.length();
            }
            filename = URLDecoder.decode(
                getLine.substring( indexEndIdx + 1, fileEndIdx ) );
            return;
        }

        // check if uri-res request
        index = getLine.indexOf( "/uri-res/N2R?" );
        if ( index != -1 )
        {
            isFileRequest = true;
            fileIndex = -1;
            //parse uri-res...
            index += 13;
            // the urn ends with the HTTP/ statement string
            int urnEndIdx = getLine.indexOf( " HTTP/", index );
            if ( urnEndIdx == -1 )
            {// no HTTP/ in request assume end of line
                urnEndIdx = getLine.length();
            }
            String urnStr = URLDecoder.decode(
                getLine.substring( index, urnEndIdx ) );
            urn = new URN( urnStr );
            return;
        }
        // neither standard get nor uri-res request so its no file request
        // maybe simple http request?
        isFileRequest = false;
    }

    /**
     * Returns true if this is a gnutella get or uri-res request. Otherwise
     * it returns false.
     */
    public boolean isFileRequest()
    {
        return isFileRequest;
    }

    /**
     * Get the name of the file to manipulate.
     *
     * @return the name of the file to fetch
     */
    public String getFileName()
    {
        return filename;
    }

    /**
     * Get the index of the file to manipulate. If the request did not specify
     * an index, then this will be -1
     *
     * @return the index of the file to fetch
     */
    public int getFileIndex()
    {
        return fileIndex;
    }

    /**
     * Get the urn of the requested file. If the request did not specify
     * an uri-res request, then this will be null
     *
     * @return the urn of the file to fetch
     */
    public URN getURN()
    {
        return urn;
    }
}