/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: TestHostAddress.java,v 1.7 2004/01/18 16:44:03 gregork Exp $
 */
package phex.test;

import junit.framework.TestCase;
import phex.host.HostAddress;



public class TestHostAddress extends TestCase
{

    public TestHostAddress(String s)
    {
        super(s);
    }

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }

    public void testIPClass()
    {
        try
        {
            HostAddress address;
            for ( int i = 1; i < 128; i++ )
            {
                address = new HostAddress(  i+ ".1.1.1:80" );
                assertEquals( String.valueOf( i ), HostAddress.CLASS_A, address.getIPClass() );
            }
            for ( int i = 128; i < 192; i++ )
            {
                address = new HostAddress(  i+ ".1.1.1:80" );
                assertEquals( String.valueOf( i ), HostAddress.CLASS_B,
                    address.getIPClass() );
            }
            for ( int i = 192; i < 224; i++ )
            {
                address = new HostAddress(  i+ ".1.1.1:80" );
                assertEquals( String.valueOf( i ), HostAddress.CLASS_C, address.getIPClass() );
            }
        }
        catch ( Exception exp )
        {
            exp.printStackTrace();
            fail( exp.getMessage() );
        }
    }

    public void testIsIPValid() throws Exception
    {
        HostAddress address;

        address = new HostAddress( "1.1.1.1:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "130.130.130.130:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "200.200.200.200:80" );
        assertTrue( address.isValidIP() );

        address = new HostAddress( "1.0.0.0:80" );
        assertFalse( address.isValidIP() );
        address = new HostAddress( "130.130.0.0:80" );
        assertFalse( address.isValidIP() );
        address = new HostAddress( "200.200.200.0:80" );
        assertFalse( address.isValidIP() );

        address = new HostAddress( "1.0.0.1:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "1.0.1.0:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "1.1.0.0:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "130.0.0.1:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "130.0.1.0:80" );
        assertTrue( address.isValidIP() );
        address = new HostAddress( "200.0.0.1:80" );
        assertTrue( address.isValidIP() );

        address = new HostAddress( "0.0.0.0:80" );
        assertFalse( address.isValidIP() );
        address = new HostAddress( "300.300.300.300:80" );
        assertFalse( address.isValidIP() );
    }

    public void testHashEquals()
    {
        try
        {
            HostAddress hostaddress = new HostAddress( "127.0.0.1:4444" );
            HostAddress hostaddress2 =  new HostAddress( "127.0.0.1:4444" );
            boolean booleanRet = hostaddress.equals(hostaddress2);
            assertEquals( true, booleanRet );

            int hash1 = hostaddress.hashCode();
            int hash2 = hostaddress2.hashCode();
            assertEquals( hash1, hash2 );
        }
        catch ( Exception exp )
        {
            fail( exp.getMessage() );
        }
    }

    public void testPortInRange()
    {
        assertEquals( false, HostAddress.isPortInRange( -1 ) );
        assertEquals( false, HostAddress.isPortInRange( 0 ) );
        assertEquals( true, HostAddress.isPortInRange( 1 ) );
        assertEquals( true, HostAddress.isPortInRange( 256 ) );
        assertEquals( true, HostAddress.isPortInRange( 13244 ) );
        assertEquals( true, HostAddress.isPortInRange( 0xFFFF ) );
    }
}