/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: TestXMLPerformance.java,v 1.3 2004/01/18 16:45:27 gregork Exp $
 */
package phex.test;

import java.io.File;
import java.util.List;

import junit.framework.TestCase;
import phex.xml.*;


public class TestXMLPerformance extends TestCase
{

    public TestXMLPerformance(String s)
    {
        super(s);
    }

    protected void setUp()
    {
    }

    protected void tearDown()
    {
    }

// results:
// genxjb: 7241 16134144
// parsexjb: 6529 0

// genxml: 10455 55447552
// parsexml: 15953 34992128



    public void testXJBSaveToFile()
    {
        long startMem = Runtime.getRuntime().totalMemory();
        long start = System.currentTimeMillis();
        try
        {
            File aFile1 = new File( "c:\\temp\\tempXJB.xml" );
            XJBPhex xjbPhex2 = ObjectFactory.createPhexElement();
            XJBSharedLibrary sharedLib = ObjectFactory.createXJBSharedLibrary();
            xjbPhex2.setSharedLibrary( sharedLib );
            List list = sharedLib.getSharedFileList();
            for ( int i = 0; i < 50000; i++ )
            {
                XJBSharedFile file = ObjectFactory.createXJBSharedFile();
                file.setFileName( String.valueOf( i ) );
                file.setHitCount( i );
                file.setLastModified( i );
                file.setLastSeen( i );
                file.setSHA1( String.valueOf( i ));
                file.setUploadCount( i );
                list.add( file );
            }
            XMLBuilder.saveToFile( aFile1, xjbPhex2 );
        }
        catch(Exception e)
        {
            System.err.println("Exception thrown:  "+e);
        }
        long end = System.currentTimeMillis();
        long endMem = Runtime.getRuntime().totalMemory();
        System.out.println( "genxjb: " + (end-start) + " " + ( endMem - startMem) );
    }

    public void testLoadXJBPhexFromFile()
    {
        long startMem = Runtime.getRuntime().totalMemory();
        long start = System.currentTimeMillis();
       File aFile1 = new File( "c:\\temp\\tempXJB.xml" );
       try
       {
           XJBPhex xjbphexRet = XMLBuilder.loadXJBPhexFromFile(aFile1);
       }
       catch(Exception e) {
           System.err.println("Exception thrown:  "+e);
       }
       long end = System.currentTimeMillis();
        long endMem = Runtime.getRuntime().totalMemory();
        System.out.println( "parsexjb: " + (end-start) + " " + ( endMem - startMem) );
   }
/*
    public void testXMLSaveToFile()
    {
        long startMem = Runtime.getRuntime().totalMemory();
        long start = System.currentTimeMillis();
        try
        {
            File aFile1 = new File( "c:\\temp\\tempXML.xml" );

            XMLPhex xphex = new XMLPhex();

            XMLSharedLibrary library = new XMLSharedLibrary();
            xphex.setSharedLibrary( library );

            for ( int i = 0; i < 50000; i++ )
            {
                XMLSharedFile file = new XMLSharedFile();
                file.setFileName( String.valueOf( i ) );
                file.setHitCount( i );
                file.setLastModified( i );
                file.setLastSeen( i );
                file.setSha1( String.valueOf( i ));
                file.setUploadCount( i );
                library.addXMLSharedFile( file );
            }

            XmlDocument doc = XMLPhexXMLCodec.encodeXML( xphex );

            XMLBuilder.saveToFile( aFile1, doc );
        }
        catch(Exception e) {
            System.err.println("Exception thrown:  "+e);
        }
        long end = System.currentTimeMillis();
        long endMem = Runtime.getRuntime().totalMemory();
        System.out.println( "genxml: " + (end-start) + " " + ( endMem - startMem) );
    }



    public void testXMLLoadFromFile()
   {
       long startMem = Runtime.getRuntime().totalMemory();
        long start = System.currentTimeMillis();
       File aFile1 = new File( "c:\\temp\\tempXML.xml" );
       Document documentRet = XMLBuilder.loadFromFile(aFile1);
       XMLPhex xphex = XMLPhexXMLCodec.decodeXML( documentRet.getDocumentElement() );
       long end = System.currentTimeMillis();
        long endMem = Runtime.getRuntime().totalMemory();
        System.out.println( "parsexml: " + (end-start) + " " + ( endMem - startMem) );
   }


*/

}