/*
 * Created on Aug 12, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package phex.test.performance;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

import org.apache.commons.io.FileUtils;

import junit.framework.TestCase;

/**
 * @author gregor
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */ 
public class TestFileCopy extends TestCase
{
    private File tempFile1;
    private RandomAccessFile raFile1;
    
    protected void setUp()
        throws Exception
    {
        super.setUp();
        tempFile1 = File.createTempFile( "TestFileUtils1", "tmp" );
        raFile1 = new RandomAccessFile( tempFile1, "rw");
        raFile1.setLength( 30 * 1024 * 1024  ); // 30MB
        raFile1.close();
    }
    
    protected void tearDown()
        throws Exception
    {
        super.tearDown();
        tempFile1.delete();
    }
    
    public void testCopy()
        throws Exception
    {
        File destinationFile = File.createTempFile( "TestFileUtils2", "tmp" );
        long start = System.currentTimeMillis();
        for ( int i = 0; i < 5; i++ )
        {
            copyFile( tempFile1, destinationFile );
        }
        destinationFile.delete();
        long end = System.currentTimeMillis();
        System.out.println( "standard: " + (end-start) );
        
    }
    
    public void testApacheCopy()
        throws Exception
    {
        File destinationFile = File.createTempFile( "TestFileUtils2", "tmp" );
        long start = System.currentTimeMillis();
        for ( int i = 0; i < 5; i++ )
        {
            FileUtils.copyFile( tempFile1, destinationFile );
        }
        destinationFile.delete();
        long end = System.currentTimeMillis();
        System.out.println( "apache: " + (end-start) );
        
    }
    
    private static final int BUFFER_LENGTH = 256 * 1024;
    /**
     * Copys the source file to the destination file. Old contents of the
     * destination file will be overwritten.
     * @deprecated use org.apache.commons.io.FileUtils.copyFile( source, destination );
     */
    public static void copyFile( File source, File destination )
        throws IOException
    {   
        // open files
        BufferedInputStream inStream = new BufferedInputStream(
            new FileInputStream( source ) );
        BufferedOutputStream outStream = new BufferedOutputStream(
            new FileOutputStream( destination ) );

        byte[] buffer = new byte[ (int)Math.min( BUFFER_LENGTH, source.length() + 1) ];
        int length;
        while ( true )
        {
            // read the min value of the buffer length or the value left to read
            length = inStream.read( buffer, 0, buffer.length );
            // end of stream
            if ( length == -1 )
            {
                break;
            }

            outStream.write( buffer, 0, length );
        }
        outStream.close();
        inStream.close();
    }
}
