/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package phex.utils;

import phex.common.URN;
import phex.download.RemoteFile;
import phex.host.HostAddress;
import phex.http.GnutellaRequest;


public class URLUtil
{
    /**
     * Returns a url to look up a URN over bitzi.com.
     * @param urn the URN to look up.
     * @return the bitzi url.
     */
    public static String buildBitziLookupURL( URN urn )
    {
        String url = "http://bitzi.com/lookup/" +
            urn.getNamespaceSpecificString() + "?detail&ref=phex";
        return url;
    }

    /**
     * Returns a magnet URL in the format:
     * magnet:?xt=urn:sha1:<sha1NSS>&dn=<filename>
     * @param sha1NSS the sha1 of the file.
     * @param filename the filename
     * @return the magnet URL string.
     */
    public static String buildMagnetURL( String sha1NSS, String filename )
    {
        String url = "magnet:?xt=urn:sha1:" + sha1NSS + "&dn="
            + URLCodecUtils.encodeURL( filename );
        return url;
    }

    public static String buildFileURL( RemoteFile file )
    {
        return "http://" + file.getHostAddress().getFullHostName() + "/get/"
            + file.getFileIndex() + "/" + URLCodecUtils.encodeURL( file.getFilename() );
    }

    public static String buildName2ResourceURL( URN urn )
    {
        return GnutellaRequest.GNUTELLA_URI_RES_PREFIX + urn.getAsString();
    }

    public static String buildFullName2ResourceURL( HostAddress ha, URN urn )
    {
        return buildHostURL( ha ) + GnutellaRequest.GNUTELLA_URI_RES_PREFIX + urn.getAsString();
    }

    public static String buildHostURL( HostAddress address )
    {
        return "http://" + address.getFullHostName();
    }
}