/*
 *  PHEX - The pure-java Gnutella-servent.
 *  Copyright (C) 2001 - 2004 Gregor Koukkoullis ( phex <at> kouk <dot> de )
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  --- CVS Information ---
 *  $Id: XMLUtils.java,v 1.2 2004/01/18 16:45:59 gregork Exp $
 */
package phex.xml;

import java.io.*;
import java.io.Writer;

/**
 * 
 */
public class XMLUtils
{
    /**
     * Writes a string XML encoded to a writer.
     */
    public void writeEncoded( Writer out, String str )
        throws IOException
    {
        for (int i = 0; i < str.length(); i++)
        {
            char ch = str.charAt(i);
            switch (ch)
            {
                case '<': out.write("&lt;");
                    break;
                case '>': out.write("&gt;");
                    break;
                case '&': out.write("&amp;");
                    break;
                case '"': out.write("&quot;");
                    break;
                case '\'': out.write("&apos;");
                    break;
                case '\r':
                case '\n':
                    out.write(ch);
                    break;
                default:
                    if (((int) ch < 32) || ((int) ch > 126))
                    {
                        out.write("&#x");
                        out.write(Integer.toString((int) ch, 16));
                        out.write(';');
                    }
                    else
                    {
                        out.write(ch);
                    }
            }
        }
    }
}
