/*
 * Created on 02.11.2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package phex.xml.thex;

import java.io.*;
import java.io.InputStream;

import javax.xml.parsers.*;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.*;
import org.xml.sax.InputSource;

import phex.utils.Logger;

/**
 * 
 * @author gkoukkoullis
 */
public class ThexHashTreeCodec
{
    public static ThexHashTree parseThexHashTreeXML( InputStream inStream )   
        throws IOException
    {
        ThexHashTree hashTree = new ThexHashTree();
        
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try
        {
            SAXParser saxParser = spf.newSAXParser();
        
            saxParser.parse( new InputSource( inStream ),
                new ThexHashTreeSAXHandler(hashTree) );
            return hashTree;
        }
        catch ( ParserConfigurationException exp )
        {
            Logger.logError( exp );
            throw new IOException( "Parsing Thex HashTree failed." );
        }
        catch ( SAXException exp )
        {
            Logger.logError( exp );
            throw new IOException( "Parsing Thex HashTree failed." );
        }
    }
    
    public static byte[] generateThexHashTreeXML( ThexHashTree hashTree )
        throws IOException
    {
        StringWriter writer = new StringWriter();
        writer.write( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        writer.write( "<!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\">" );
        writer.write( "<hashtree>" );
        writer.write( "<file size=\"" );
        writer.write( hashTree.getFileSize() );
        writer.write( "\" segmentsize=\"" );
        writer.write( hashTree.getFileSegmentSize() );
        writer.write( "\"/>" );
        writer.write( "<digest algorithm=\"" );
        writer.write( hashTree.getDigestAlgorithm() );
        writer.write( "\" outputsize=\"" );
        writer.write( hashTree.getDigestOutputSize() );
        writer.write( "\"/>" );
        writer.write( "<serializedtree depth=\"" );
        writer.write( hashTree.getSerializedTreeDepth() );
        writer.write( "\" type=\"" );
        writer.write( hashTree.getSerializedTreeType() );
        writer.write( "\" uri=\"" );
        writer.write( hashTree.getSerializedTreeUri() );
        writer.write( "\"/>" );
        writer.write( "</hashtree>" );
        
        String output = writer.toString();

        return output.getBytes( "UTF-8" );
    }
}
