  L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              ViewXbm              %%   \ @  *                %% |        BitmapCode.c  c2004        %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h"! #pragma module BITMAPCODE VERSION    #include <stdio.h> #include <descrip.h> #include <rms.h> #include <stdlib.h>  #include <X11/Xos.h> #include <Xm/ScrolledW.h>  #include <Xm/BulletinB.h>  #include <Xm/PushB.h>  #include <Xm/DrawingA.h> #include <Xm/ScrollBar.h>  #include "defs.h"  #include "externs.h" #include "toobig.xbm"  #include "badfile.xbm"   extern void DialogCB();  extern void ExposeCanvasCB();  extern void ToggleBtnCB();   extern FILE_LST *BitmapList;  J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: BitmapEditD  * Description: User has selected the Edit option from the Actions->F  *              Bitmaps cascade on the menubar. The pointer 'editfile'G  *              holds the selected bitmap file to edit. The DCL symbol  F  *              'bitmap' points to location of EDITXBM.EXE, a slightlyF  *              modified version of the traditional X11 bitmap editor.@  *              Modifications were made exclusively for VIEWXBM.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void BitmapEdit(char *editfile)  {      int endstat;     int retstat;     int flags = 0;     char CmdBuf[50];!     $DESCRIPTOR(Dsc_Cmd, CmdBuf);   3     sprintf(CmdBuf, "bitmap -ms red %s", editfile); =     if(VerboseFlg) printf("Starting edit of %s\n", editfile); @     retstat = lib$spawn(&Dsc_Cmd,  0, 0, &flags, 0, 0, &endstat,         0, 0, 0, 0, 0, 0);L     if(retstat != SS$_NORMAL) printf("LIB$SPAWN error (0x%08X)\n", retstat);     EditActiveFlg = False;<     CsTitleStr = XmStringCreateLtoR("Bitmap List", charset);
     n = 0;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;'     XtSetArg(args[n], XmNokLabelString, 4         XmStringCreateLtoR("Select", charset)); n++;%     XtSetValues(TxtListDlg, args, n); (     XtSetSensitive(TxtSelectBtn, False);G     if(VerboseFlg) printf("lib$spawn exit status - 0x%08X\n", retstat);  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetFileSize E  * Description: Filename passed in as 'fspec'. Initialize fab and xab E  *              structures then open and close specified file to fill F  *              in the structures. Extract number of blocks allocated,&  *              then return to caller.  *?  *              Results of this function are not currently used   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetFileSize(char *fspec) {      int BlockStat;   @     struct FAB AllocFab;            /* file alloccation block */H     struct XABFHC XabFhc;           /* file header characteristic XAB */   <     AllocFab = cc$rms_fab;          /* init FAB structure */>     XabFhc = cc$rms_xabfhc;         /* init XABFHC structure*/        AllocFab.fab$l_fna = fspec; '     AllocFab.fab$b_fns = strlen(fspec); #     AllocFab.fab$b_fac = FAB$M_GET; #     AllocFab.fab$l_fop = FAB$V_NAM; L     AllocFab.fab$l_xab = (char *) &XabFhc;   /* chain the file header xab */   $     BlockStat = SYS$OPEN(&AllocFab);K     if(BlockStat != RMS$_NORMAL) return(BlockStat); /* SYSTEM-E-BADPARAM */ %     BlockStat = SYS$CLOSE(&AllocFab); K     if(BlockStat != RMS$_NORMAL) return(BlockStat); /* SYSTEM-E-BADPARAM */    #     AllocSize = AllocFab.fab$l_alq;       UsedSize = XabFhc.xab$l_ebk;        return(SS$_NORMAL);    }     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetSquareRoot F  * Description: Get the integer square root of num. Originally used toI  *              calculate an equal number of rows and columns for a given H  *              number of bitmaps. Now, the return value only used if itE  *              is less than three, as three is the maximum number of H  *              columns ever displayed. This routine from O'Reilly book.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetSquareRoot(int num) {      int i, s = 0, t;       for(i = 15; i >= 0; i--) {         t = (s | (1L << i));         if(t * t <= num) s = t;      } 
     return s;  }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ListAllBitmapsF  * Description: User selected Actions->Bitmaps->List from the menubar.G  *              We create a message dialog containing a list of all the I  *              bitmaps in the selected directory. The user can close the E  *              dialog and return or select a filename and the Select @  *              button which displays that bitmap on main window  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ListAllBitmaps()  {      Widget button;     FILE_LST *XbmPtr;   <     CsTitleStr = XmStringCreateLtoR("Bitmap List", charset);D     CsLabelStr = XmStringCreateLtoR("Select Bitmap File:", charset);       if(!TxtListDlg) {          n = 0;/         XtSetArg(args[n], XmNheight, 255); n++; .         XtSetArg(args[n], XmNwidth, 240); n++;<         XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;=         XtSetArg(args[n], XmNmessageString, CsLabelStr); n++; +         XtSetArg(args[n], XmNokLabelString, 8             XmStringCreateLtoR("Select", charset)); n++;-         XtSetArg(args[n], XmNhelpLabelString, 7             XmStringCreateLtoR("Close", charset)); n++; 9         XtSetArg(args[n], XmNdefaultPosition, True); n++; I         XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON); n++; 7         XtSetArg(args[n], XmNautoUnmanage, False); n++; ;         XtSetArg(args[n], XmNdialogType, XmDIALOG_MESSAGE); L         TxtListDlg = XmCreateMessageDialog(MainForm, "TxtListDlg", args, n);  L         TxtSelectBtn = XmMessageBoxGetChild(TxtListDlg, XmDIALOG_OK_BUTTON);M         TxtCloseBtn = XmMessageBoxGetChild(TxtListDlg, XmDIALOG_HELP_BUTTON); J         button = XmMessageBoxGetChild(TxtListDlg, XmDIALOG_CANCEL_BUTTON);          XtUnmanageChild(button);,         XtSetSensitive(TxtSelectBtn, False);  K         XtAddCallback(TxtListDlg, XmNokCallback, DialogCB, TXT_SELECT_BTN); L         XtAddCallback(TxtListDlg, XmNhelpCallback, DialogCB, TXT_CLOSE_BTN);  !         XmStringFree(CsTitleStr); !         XmStringFree(CsLabelStr);   8         /* Create a list widget for bitmap file names */           n = 0;)         XtSetArg(args[n], XmNy, 20); n++; )         XtSetArg(args[n], XmNx, 20); n++; 6         XtSetArg(args[n], XmNshadowThickness, 3); n++;G         XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++; >         XtSetArg(args[n], XmNlistSizePolicy, XmCONSTANT); n++;7         XtSetArg(args[n], XmNvisibleItemCount, 8); n++; 0         XtSetArg(args[n], XmNitemCount, 0); n++;I         XbmListW = XmCreateScrolledList(TxtListDlg, "XbmListW", args, n);           XtManageChild(XbmListW);  ;         XtAddCallback(XbmListW, XmNbrowseSelectionCallback, 4                       DialogCB, LIST_ITEM_SELECTED);     }   9         /* if ListedXbmCount is nonzero, simply return */        if(ListedXbmCount) return;  ;         /* init pointer to top of bitmap filenames array */        XbmPtr = BitmapList;  &         /* populate the list widget */  #     XmListDeleteAllItems(XbmListW); %     while(strlen(XbmPtr->Filename)) { >         CpStr = XmStringCreateLtoR(XbmPtr->Filename, charset);*         XmListAddItem(XbmListW, CpStr, 0);         XmStringFree(CpStr);         XbmPtr++;      }         ListedXbmCount = NumBitmaps; }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowAllBitmapsK  * Description: Create a bulletinboard dialog displaying all bitmaps in the I  *              target directory. Create a scrolled window with a drawing H  *              area widget as the viewport. Read all the bitmaps into aE  *              single pixmap which is then displayed in the viewport J  *              withe the filename and an outline surrounding each bitmap.?  *              User can scroll the viewport via the scrollbar.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowAllBitmaps()  { !     int BitmapCount = NumBitmaps;      int GcMask = 0;      int XbmNameLen;      int XbmStatus = 0;     int h_indent = 0;      int indx = 0;      int sizeok = 1;      int status = RMS$_NORMAL;      int v_indent = 0;      int xoffset = 0;     int yoffset = 0;     int dummy;     char BtnStr[30];     char RejectStr[80];      char buf[128];     char *ptr = 0;'     Widget Bboard, CloseBtn, VisCanvas;      Widget scrolled_w;@     XFontStruct *VisFont;           /* font for bitmap labels */     XGCValues GcValues; &     Bitmap *XbmList = (Bitmap *) NULL;       int MaxWidth = 64;     int MaxHeight = 64;      FILE_LST *XbmPtr;   ,     VisFont = XLoadQueryFont (dpy, "fixed");     CellWidth = 0;     CellHeight = 0;      ViewHeight = 330;      ViewWidth = 430;  3         /* Use the foreground and background colors <            of the MainWindow to create a graphics context */  
     n = 0;>     XtSetArg(args[n], XtNforeground, &values.foreground); n++;>     XtSetArg(args[n], XtNbackground, &values.background); n++;%     XtGetValues(MainWindow, args, n); G     VisGc2 = XtGetGC(MainWindow, GCForeground | GCBackground, &values);   2         /* allocate memory for count of bitmaps */  E     if(BitmapCount) {       /* should never get here if count is 0 */ 1         memset(&RejectStr, 0, sizeof(RejectStr)); L         XbmList = (Bitmap *) XtRealloc(XbmList, BitmapCount*sizeof(Bitmap));         if(!XbmList) {:             XtError("Insuficient memory for bitmap data");             exit(1);	         }      }   C         /* we now know number of bitmap files in this directory, so *            allocate memory for each xbm */  <     printf("\n");       /* clean start for verbose output */C     if(VerboseFlg) printf("Creating full pixmap of all bitmaps\n");        XbmPtr = BitmapList;%     while(strlen(XbmPtr->Filespec)) { &         strcpy(buf, XbmPtr->Filename);C         if(VerboseFlg) printf(" Loading %s ", buf), fflush(stdout); @         XbmStatus = XReadBitmapFile(dpy, DefaultRootWindow(dpy),N                 XbmPtr->Filespec, &XbmList[indx].width, &XbmList[indx].height,<                 &XbmList[indx].bitmap, &XbmNameLen, &dummy);(         if(XbmStatus == BitmapSuccess) {$             ptr = strrchr(buf, ']');             if(ptr) ptr++;             else ptr = &buf;  A         /* if bitmap is larger than  MaxWidth and/or MaxHeight we @            display its name and a generic bitmap indication this!            bitmap is too large */   C             if(VerboseFlg) printf("(%dx%d)\n", XbmList[indx].width, &                 XbmList[indx].height);1             if(XbmList[indx].width > MaxWidth  || 7                     XbmList[indx].height > MaxHeight) { B                 printf(" Rejected %s, Bitmap Too Big (%d x %d)\n",D                     buf, XbmList[indx].width, XbmList[indx].height);5                 XbmList[indx].width = toolarge_width; 7                 XbmList[indx].height = toolarge_height; A                 XbmList[indx].bitmap = XCreateBitmapFromData(dpy, ;                     RootWindowOfScreen(XtScreen(TopLevel)), D                     toolarge_bits, toolarge_width, toolarge_height);                 BitmapCount--;
             } ,             XbmList[indx].len = strlen(ptr);N             XbmList[indx].name = strcpy(XtMalloc(XbmList[indx].len + 1), ptr);	         }   H         /* if we can't open the file, it's not a bitmap file or there isD            not enough memory, then display error popup and display a<            generic bitmap to indicate file was not loaded */           else {-             printf("Couldn't load bitmap, ");              BitmapCount--;             switch(XbmStatus) { &                 case BitmapOpenFailed:=                     printf("bitmap open failed (%s)\n", buf); H                     sprintf(ErrorMsg, "Bitmap open failed (%s)\n", buf);                     break;'                 case BitmapFileInvalid: 6                     printf("invalid bitmap format\n");K                     sprintf(ErrorMsg, "Invalid bitmap format (%s)\n", buf);                      break;$                 case BitmapNoMemory:>                     printf("insufficient memory (%s)\n", buf);I                     sprintf(ErrorMsg, "Insufficient memory (%s)\n", buf);                      break;
             } 7             ErrorPopup(&ErrorMsg, "Bitmap Load Error");              PopupActive = True; &             XmUpdateDisplay(MainForm);/             XbmList[indx].width = badxbm_width; 1             XbmList[indx].height = badxbm_height; =             XbmList[indx].bitmap = XCreateBitmapFromData(dpy, 7                 RootWindowOfScreen(XtScreen(TopLevel)), :                 badxbm_bits, badxbm_width, badxbm_height);,             XbmList[indx].len = strlen(ptr);N             XbmList[indx].name = strcpy(XtMalloc(XbmList[indx].len + 1), ptr);	         }          indx++;          XbmPtr++;      }   N     printf("\nQualified bitmaps loaded: %d of %d\n", BitmapCount, NumBitmaps);  2         /* calculate size for VisPixmap by getting,            the dimensions of each bitmap. */  3     printf("Calculating sizes for VisPixmap...\n");   .     for(indx = 0; indx < NumBitmaps; indx++) {L         if(XbmList[indx].width > CellWidth) CellWidth = XbmList[indx].width;P         if(XbmList[indx].height > CellHeight) CellHeight = XbmList[indx].height;P         XbmNameLen = XTextWidth(VisFont, XbmList[indx].name, XbmList[indx].len);:         if(XbmNameLen > CellWidth) CellWidth = XbmNameLen;     }   <         /* Compensate for vertical font height and grid line)            by adding a 6 pixel padding */   9     CellHeight += 6 + VisFont->ascent + VisFont->descent;      CellWidth += 6;   (     NumCols = GetSquareRoot(NumBitmaps);     if(NumCols > 3) {          NumCols = 3;5         NumRows = (NumBitmaps + NumCols-1) / NumCols;      } 6     else NumRows = (NumBitmaps + NumCols-1) / NumCols;  D         /* here we set up the size info for the drawing process. TheF            v_indent and h_indent move the pixmap to center of viewportD            when there are not enought bitmaps to create an array of !            3 colums and 4 rows */   )     DrawingHeight = NumRows * CellHeight; '     DrawingWidth = NumCols * CellWidth; K     if(DrawingWidth < ViewWidth) h_indent = (ViewWidth - DrawingWidth) / 2; O     if(DrawingHeight < ViewHeight) v_indent = (ViewHeight - DrawingHeight) / 2; )     TotalWidth = DrawingWidth + h_indent; +     TotalHeight = DrawingHeight + v_indent;   H     printf("Creating drawing area of %dx%d pixels (%d rows, %d cols)\n",7             TotalWidth, TotalHeight, NumRows, NumCols);   @     printf ("h_indent: %d, v_indent: %d\n", h_indent, v_indent);J     printf ("TotalWidth: %d, TotalHeight: %d\n", TotalWidth, TotalHeight);  E         /* Create a single, 1-bit deep pixmap. It is extended on both*I            x and y panes to permit right and bottom grid lines visible */   .     if(VisPixmap) XFreePixmap(dpy, VisPixmap);:     VisPixmap = XCreatePixmap(dpy, DefaultRootWindow(dpy),*             TotalWidth+10, TotalHeight+10,6             DefaultDepthOfScreen(XtScreen(TopLevel)));5     if(!VisPixmap) XtError("Can't Create VisPixmap");   :     VisGc2 = XCreateGC(dpy, VisPixmap, GcMask, &GcValues);+     if(!VisGc2) XtError("Can't create gc");   I         /* Clear pixmap by setting the entire image to 'appbackground' */|  L     XSetForeground(dpy, VisGc2, appbackground); /* init VisGc2's fg to bg */P     XFillRectangle(dpy, VisPixmap, VisGc2, 0, 0, TotalWidth+10, TotalHeight+10);/     XSetForeground(dpy, VisGc2, appforeground); /     XSetBackground(dpy, VisGc2, appbackground);\(     XSetFont(dpy, VisGc2, VisFont->fid);  0         /* Draw the grid lines around bitmaps */  @     if(v_indent < 3) v_indent = 3;      /* cannot be negative */H     for (indx = v_indent-3; indx <= ((NumRows * CellHeight) + v_indent);!             indx += CellHeight) {a:         XDrawLine (dpy, VisPixmap, VisGc2, h_indent, indx,              TotalWidth, indx); 
 #ifdef XBMDBGd:         printf("drawing horz line from %d,%d to %d,%d\n", /              h_indent, indx, TotalWidth, indx);* #endif     }*E     for (indx = h_indent; indx <= ((NumCols * CellWidth) + h_indent);u              indx += CellWidth) {<         XDrawLine (dpy, VisPixmap, VisGc2, indx, v_indent-3,!             indx, TotalHeight-3);i
 #ifdef XBMDBGl9         printf("drawing vert line from %d,%d to %d,%d\n", 4              indx, v_indent-3, indx, TotalHeight-3); #endif     }s  8         /* Draw the names and bitmaps into the pixmap */  
 #ifdef XBMDBG I         printf("CellWidth: %d, CellHeight: %d\n", CellWidth, CellHeight);e #endif  .     for(indx = 0; indx < NumBitmaps; indx++) {<         xoffset = (CellWidth * (indx % NumCols)) + h_indent;=         yoffset = (CellHeight * (indx / NumCols)) + v_indent;e  
 #ifdef XBMDBG ;         printf("  indx: %2d, xoffset: %3d, yoffset: %3d\n",n(                 indx, xoffset, yoffset); #endif9         XDrawString(dpy, VisPixmap, VisGc2, xoffset + 5,  N             yoffset + VisFont->ascent, XbmList[indx].name, XbmList[indx].len);  :         if(DefaultDepthOfScreen (XtScreen (TopLevel)) > 1)E             XCopyPlane (dpy, XbmList[indx].bitmap, VisPixmap, VisGc2,*@                 0, 0, XbmList[indx].width, XbmList[indx].height,                 xoffset + 5,B                 yoffset + VisFont->ascent + VisFont->descent, 1L);K         else XCopyArea(dpy, XbmList[indx].bitmap, VisPixmap, VisGc2, 0, 0, BH                 XbmList[indx].width,  XbmList[indx].height, xoffset + 5,>                 yoffset + VisFont->ascent + VisFont->descent);  ?         /* Once we copy them to drawing area, we no longer needt*            the bitmap and its name */       /         XFreePixmap(dpy, XbmList[indx].bitmap); #         XtFree(XbmList[indx].name);B     }iO     XtFree ((char *) XbmList);    /* don't need the array of structs anymore */+  ,         /* Now we get into the Motif code...?            first create a bulletin board to hold the display */e  ?     CsTitleStr = XmStringCreateLtoR("Bitmap Display", charset); 
     n = 0;7     XtSetArg(args[n], XmNdialogTitle, CsTitleStr); n++;)*     XtSetArg(args[n], XmNwidth, 450); n++;+     XtSetArg(args[n], XmNheight, 390); n++; 2     XtSetArg(args[n], XmNshadowThickness, 3); n++;P     VisListDlg = XmCreateBulletinBoardDialog(MainWindow, "VisListDlg", args, n);     XmStringFree(CsTitleStr);l  =         /* Create Scrolled Window as a child of VisListDlg */b  
     n = 0;2     XtSetArg(args[n], XmNunitType, XmPIXELS); n++;<     XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;*     XtSetArg(args[n], XmNwidth, 430); n++;+     XtSetArg(args[n], XmNheight, 330); n++;F4     XtSetArg(args[n], XmNworkWindow, ViewPort); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;K     scrolled_w = XmCreateScrolledWindow(VisListDlg, "scrolled_w", args, n);A     XtManageChild(scrolled_w);  D         /* Create a drawing area as a child of the ScrolledWindow */  
     n = 0;6     XtSetArg(args[n], XmNwidth, TotalWidth + 10); n++;8     XtSetArg(args[n], XmNheight, TotalHeight + 10); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;=     XtSetArg(args[n], XmNborderColor, GetPixel("blue")); n++;hI     XtSetArg(args[n], XmNbackground, GetPixel("Window Background")); n++;k;     XtSetArg(args[n], XmNresizePolicy, XmRESIZE_NONE); n++;*D     ViewPort = XmCreateDrawingArea(scrolled_w, "ViewPort", args, n);     XtManageChild(ViewPort);  E     XtAddCallback(ViewPort, XmNexposeCallback, ExposeCanvasCB, NULL);i  2         /* create a pushbutton to close window  */  J     strcpy(BtnStr, "Close");     /* create label string for exit button */=     CpStr = XmStringCreate(BtnStr, XmSTRING_DEFAULT_CHARSET);   
     n = 0;&     XtSetArg(args[n], XmNx, 190); n++;&     XtSetArg(args[n], XmNy, 350); n++;)     XtSetArg(args[n], XmNwidth, 80); n++; *     XtSetArg(args[n], XmNheight, 30); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;C     CloseBtn = XmCreatePushButton(VisListDlg, "CloseBtn", args, n);d     XtManageChild(CloseBtn);J     XtAddCallback(CloseBtn, XmNactivateCallback, DialogCB, VIS_CLOSE_BTN);  4         /* Get an id for the drawing area widget  */  6     VisCanvas = XtNameToWidget (TopLevel, "ViewPort");       FirstTime = False;/     if(!PopupActive) XtManageChild(VisListDlg);n#     else XmUpdateDisplay(MainForm);*  :         /* print the width and height for the visible area)            of the drawing area  widget */n  <     printf("   ViewPort: %d x %d\n", ViewWidth, ViewHeight);>     printf("DrawingArea: %d x %d\n", TotalWidth, TotalHeight); }     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: SetOptions  * Description: .a  *              .   *              .w  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */* void SetOptions()* {*     char buffer[50];     Widget WorkArea, btn;   +     sprintf(buffer, "ViewXbm %s", VERSION); 5     CsLabelStr = XmStringCreateLtoR(buffer, charset);t<     CsTitleStr = XmStringCreateLtoR("Set Options", charset);  
     n = 0;+     XtSetArg(args[n], XmNheight, 245); n++; *     XtSetArg(args[n], XmNwidth, 250); n++;8     XtSetArg(args[n], XmNdialogTitle, CsTitleStr);  n++;9     XtSetArg(args[n], XmNmessageString, CsLabelStr); n++; +     XtSetArg(args[n], XmNcancelLabelString,r3         XmStringCreateLtoR("Close", charset)); n++; 5     XtSetArg(args[n], XmNdefaultPosition, True); n++;+E     XtSetArg(args[n], XmNdefaultButtonType, XmDIALOG_OK_BUTTON); n++;g3     XtSetArg(args[n], XmNautoUnmanage, False); n++;gD     XtSetArg(args[n], XmNmessageAlignment, XmALIGNMENT_CENTER); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;.     XtSetArg(args[n], XmNnoResize, TRUE); n++;H     OptionsDlg = XmCreateMessageDialog(MainForm, "OptionsDlg", args, n);     XmStringFree(CsTitleStr);e     XmStringFree(CsLabelStr);a  A     btn = XmMessageBoxGetChild(OptionsDlg, XmDIALOG_HELP_BUTTON);m     XtUnmanageChild(btn); ?     btn = XmMessageBoxGetChild(OptionsDlg, XmDIALOG_OK_BUTTON);O     XtUnmanageChild(btn);sL     XtAddCallback (OptionsDlg, XmNcancelCallback, DialogCB, OPTS_CLOSE_BTN);  E         /* create a form widget to enclose label and toggle widget */l  
     n = 0;+     XtSetArg(args[n], XmNheight, 125); n++; *     XtSetArg(args[n], XmNwidth, 220); n++;8     XtSetArg(args[n], XmNrubberPositioning, False); n++;2     XtSetArg(args[n], XmNshadowThickness, 3); n++;7     XtSetArg(args[n], XmNshadowType, XmSHADOW_IN); n++;/=     WorkArea = XmCreateForm(OptionsDlg, "WorkArea", args, n);      XtManageChild(WorkArea);  ,         /* create File Type toggle button */  '     sprintf(buffer, "File Type - XBM");[0     CpStr = XmStringCreateLtoR(buffer, charset);  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;-     XtSetArg(args[n], XmNtopOffset, 10); n++; =     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;s.     XtSetArg(args[n], XmNleftOffset, 10); n++;?     XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;l0     XtSetArg(args[n], XmNbottomOffset, 70); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; 1     XtSetArg(args[n], XmNset, FileTypesFlg); n++; /     XtSetArg(args[n], XmNmarginRight, 20); n++;r+     XtSetArg(args[n], XmNspacing, 10); n++; I     FileTypeBtn = XmCreateToggleButton(WorkArea, "FileTypeBtn", args, n);      XtManageChild(FileTypeBtn);      XmStringFree(CpStr);7     XtAddCallback(FileTypeBtn, XmNvalueChangedCallback,I#         ToggleBtnCB, FILETYPE_BTN);t  0         /* create File Versions toggle button */  /     sprintf(buffer, "File Versions - Highest");*0     CpStr = XmStringCreateLtoR(buffer, charset);  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;-     XtSetArg(args[n], XmNtopOffset, 40); n++; =     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;w.     XtSetArg(args[n], XmNleftOffset, 10); n++;?     XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;e0     XtSetArg(args[n], XmNbottomOffset, 40); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++; 0     XtSetArg(args[n], XmNset, FileVersFlg); n++;/     XtSetArg(args[n], XmNmarginRight, 10); n++;*+     XtSetArg(args[n], XmNspacing, 10); n++; I     FileVersBtn = XmCreateToggleButton(WorkArea, "FileVersBtn", args, n);L     XtManageChild(FileVersBtn);      XmStringFree(CpStr);7     XtAddCallback(FileVersBtn, XmNvalueChangedCallback,_#         ToggleBtnCB, FILEVERS_BTN);   /         /* create Verbose Mode toggle button */m  /     sprintf(buffer, "Verbose Mode - Disabled"); 0     CpStr = XmStringCreateLtoR(buffer, charset);  
     n = 0;<     XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;-     XtSetArg(args[n], XmNtopOffset, 70); n++; =     XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++; .     XtSetArg(args[n], XmNleftOffset, 10); n++;>     XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;/     XtSetArg(args[n], XmNrightOffset, 10); n++;0?     XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;e0     XtSetArg(args[n], XmNbottomOffset, 10); n++;2     XtSetArg(args[n], XmNlabelString, CpStr); n++;5     XtSetArg(args[n], XmNhighlightThickness, 0); n++;u/     XtSetArg(args[n], XmNset, VerboseFlg); n++;c/     XtSetArg(args[n], XmNmarginRight, 10); n++;e+     XtSetArg(args[n], XmNspacing, 10); n++;CG     VerboseBtn = XmCreateToggleButton(WorkArea, "VerboseBtn", args, n);t     XtManageChild(VerboseBtn);     XmStringFree(CpStr);6     XtAddCallback(VerboseBtn, XmNvalueChangedCallback,"         ToggleBtnCB, VERBOSE_BTN);       XtManageChild(OptionsDlg); })    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: ShowVers?  * Description: Displays current image version, build date, and ?  *              required privs for interactive usage and/or the $  *              VMS install utility.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */e void ShowVers()t { 1     sprintf(Buffer, " ViewXbm by Lyle W West\n");t@     sprintf(Buffer+strlen(Buffer), "   Version: %s\n", VERSION);A     sprintf(Buffer+strlen(Buffer), " Link Date: %s\n", __DATE__);"C     sprintf(Buffer+strlen(Buffer), "User Privs: None (ReadAll)\n");f }t    ndow(dpy),N                 XbmPtr->Filespec, &XbmList[indx].width, &XbmList[indx].height,<                 &XbmList[indx].bitmap, &XbmNameLen, &dummy);(         if(XbmStatus == BitmapSuccess) {$                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         