/*
 *  SRM console for FreeVMS
 *  Copyright (C) 1996   Erich Boleyn  <erich@uruk.org>
 *  Copyright (C) 2001   BERTRAND Jol
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "shared.h"

static int saved_sector;

static void
disk_read_savesect_func (int sector, int offset, int length)
{
  saved_sector = sector;
}

void
cmain (void)
{
  printf ("\n\nSRM console loading...\n");

  /*
   *  Here load the true second-stage boot-loader.
   */

  if (srm_open (config_file))
    {
      int ret;

      disk_read_hook = disk_read_savesect_func;
      srm_read ((char *) 0x8000, SECTOR_SIZE * 2);
      disk_read_hook = NULL;
      
      ret = srm_read ((char *) 0x8000 + SECTOR_SIZE * 2, -1);
      
      srm_close ();

      if (ret)
	chain_stage2 (0, 0x8200, saved_sector);
    }

  /*
   *  If not, then print error message and die.
   */

  print_error ();

  stop ();
}
