/*
 * Decompiled with CFR 0.152.
 */
package T4Chart;

import T4Chart.SqlIterator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class Database {
    private static Database _instance = new Database();
    private Connection _cnx = null;

    private Database() {
    }

    public static Database getInstance() {
        return _instance;
    }

    public void open(String driver, String host, String user, char[] password, String dbname) {
        try {
            String str = "";
            Properties connProp = new Properties();
            connProp.put("user", user);
            char[] charArray = password;
            for (int i = 0; i < charArray.length; ++i) {
                str = str + charArray[i];
            }
            connProp.put("password", str);
            String connectString = "jdbc:mysql://" + host + ":3306/" + dbname;
            Class.forName(driver).newInstance();
            this._cnx = DriverManager.getConnection(connectString, connProp);
        }
        catch (ClassNotFoundException ecnf) {
            ecnf.printStackTrace();
        }
        catch (IllegalAccessException eia) {
            eia.printStackTrace();
        }
        catch (InstantiationException ei) {
            ei.printStackTrace();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        try {
            Statement stmt = this._cnx.createStatement();
            stmt.execute("SET SESSION sql_mode='ansi'");
            stmt.close();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
    }

    public void close() {
        if (this._cnx != null) {
            try {
                this._cnx.close();
                this._cnx = null;
            }
            catch (SQLException esql) {
                esql.printStackTrace();
            }
        }
    }

    public Vector getTables(String nodeName) {
        String[] tt = new String[]{"TABLE", "VIEW"};
        ResultSet rs = null;
        Vector<String> v = null;
        if (this._cnx == null) {
            throw new RuntimeException("You are not connected to the database");
        }
        try {
            rs = this._cnx.getMetaData().getTables(null, null, "%", tt);
            Statement stmt = this._cnx.createStatement();
            v = new Vector<String>();
            while (rs.next()) {
                String tableName = rs.getString(3);
                if ("node".equals(tableName)) continue;
                String req = "select 1 from node, " + tableName + " where node.node_name = '" + nodeName + "' and node.node_id = " + tableName + ".node_id";
                ResultSet rsb = stmt.executeQuery(req);
                if (rsb.next()) {
                    v.add(tableName);
                }
                rsb.close();
            }
            stmt.close();
            rs.close();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        return v;
    }

    public Vector getNodes() {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = null;
        if (this._cnx == null) {
            throw new RuntimeException("You are not connected to the database");
        }
        try {
            v = new Vector<String>();
            stmt = this._cnx.createStatement();
            rs = stmt.executeQuery("select node_name from node order by node_name");
            while (rs.next()) {
                String nodeName = rs.getString(1);
                v.add(nodeName);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        return v;
    }

    public Vector getColumns(String tableName) {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<String> v = null;
        if (this._cnx == null) {
            throw new RuntimeException("You are not connected to the database");
        }
        try {
            v = new Vector<String>();
            stmt = this._cnx.createStatement();
            rs = stmt.executeQuery("select * from " + tableName + " limit 1");
            for (int i = 3; i <= rs.getMetaData().getColumnCount(); ++i) {
                v.add(rs.getMetaData().getColumnName(i));
            }
            stmt.close();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        return v;
    }

    public Vector getDatesRange(String nodeName, String tableName, String tsColName) {
        Statement stmt = null;
        ResultSet rs = null;
        Vector<Timestamp> v = null;
        if (this._cnx == null) {
            throw new RuntimeException("You are not connected to the database");
        }
        try {
            stmt = this._cnx.createStatement();
            String s = "select date_format(min(\"" + tsColName + "\"), '%Y-%m-%d %H:%i:%s'),date_format(max(\"" + tsColName + "\"),'%Y-%m-%d %H:%i:%s')" + " from node," + tableName + "  where node.node_name = '" + nodeName + "' and node.node_id = " + tableName + ".node_id";
            rs = stmt.executeQuery(s);
            v = new Vector<Timestamp>(2);
            rs.next();
            v.add(rs.getTimestamp(1));
            v.add(rs.getTimestamp(2));
            rs.close();
            stmt.close();
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        return v;
    }

    public SqlIterator getItemValues(String nodeName, String tableName, String colName, String tsColName, String startDate, String endDate) {
        Statement stmt = null;
        ResultSet rs = null;
        if (this._cnx == null) {
            throw new RuntimeException("You are not connected to the database");
        }
        try {
            String s = "select date_format(\"" + tsColName + "\",'%Y-%m-%d %H:%i:00'),\"" + colName + "\" from node," + tableName + "  where node.node_name = '" + nodeName + "' and node.node_id = " + tableName + ".node_id and \"" + tsColName + "\" >= '" + startDate + "' and \"" + tsColName + "\" <= '" + endDate + "' order by 1";
            stmt = this._cnx.createStatement();
            rs = stmt.executeQuery(s);
        }
        catch (SQLException esql) {
            esql.printStackTrace();
        }
        return new SqlItemValuesIterator(stmt, rs);
    }

    private class SqlItemValuesIterator
    extends SqlIterator {
        public SqlItemValuesIterator(Statement stmt, ResultSet rs) {
            super(stmt, rs);
        }

        Object createObjectFromRow(ResultSet resultset) throws Exception {
            Vector<Comparable<Date>> v = new Vector<Comparable<Date>>(2);
            v.add(resultset.getTimestamp(1));
            v.add(new Double(resultset.getDouble(2)));
            return v;
        }
    }
}

