/*
 * Decompiled with CFR 0.152.
 */
package T4Chart;

import T4Chart.SqlIterator;
import java.awt.Color;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.SeriesException;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.Spacer;

public class T4ChartChart
extends JFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    public T4ChartChart(String[] lineName, SqlIterator[] it, boolean isStacked, boolean isDifference) {
        super("T4Chart");
        XYDataset dataset = isDifference ? this.createDifferenceDataset(lineName, it) : this.createDataset(lineName, it);
        JFreeChart chart = isStacked ? this.createStackedChart("", dataset, isStacked) : (isDifference ? this.createDifferenceChart("", dataset) : this.createStackedChart("", dataset, isStacked));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(750, 405));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private JFreeChart OldcreateChart(String title, XYDataset dataset, boolean isStacked) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart(title, "Timestamp", "Value", dataset, true, true, false);
        chart.setBackgroundPaint(Color.white);
        StandardLegend sl = (StandardLegend)chart.getLegend();
        sl.setDisplaySeriesShapes(true);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
            rr.setItemLabelsVisible(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("dd HH:mm:ss"));
        return chart;
    }

    private JFreeChart createStackedChart(String title, XYDataset dataset, boolean isStacked) {
        AbstractXYItemRenderer renderer;
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator("{0}: ({1}, {2})", (DateFormat)new SimpleDateFormat("dd HH:mm:ss"), NumberFormat.getInstance());
        DateAxis xAxis = new DateAxis(null);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        NumberAxis yAxis = new NumberAxis(null);
        yAxis.setAutoRangeIncludesZero(true);
        if (isStacked) {
            renderer = new StackedXYAreaRenderer(4, toolTipGenerator, null);
            ((XYAreaRenderer)renderer).setOutline(true);
        } else {
            renderer = new StandardXYItemRenderer(2, toolTipGenerator, null);
        }
        renderer.setItemLabelsVisible(true);
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("dd HH:mm:ss"));
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, plot, true);
        return chart;
    }

    private JFreeChart createDifferenceChart(String title, XYDataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart(null, null, null, dataset, true, true, false);
        XYPlot plot = chart.getXYPlot();
        XYDifferenceRenderer renderer = new XYDifferenceRenderer(Color.red, Color.blue, false);
        plot.setRenderer(renderer);
        plot.setBackgroundPaint(Color.lightGray);
        plot.setDomainGridlinePaint(Color.white);
        plot.setRangeGridlinePaint(Color.white);
        plot.setAxisOffset(new Spacer(1, 5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        DateAxis domainAxis = new DateAxis(null);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        plot.setDomainAxis(domainAxis);
        plot.setForegroundAlpha(0.5f);
        return chart;
    }

    private XYDataset createDataset(String[] lineTitle, SqlIterator[] iter) {
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-d H:m:s.S");
        for (int i = 0; i < iter.length; ++i) {
            SqlIterator it = iter[i];
            XYSeries s1 = new XYSeries(lineTitle[i], true, false);
            while (it.hasNext()) {
                Vector res = (Vector)it.next();
                Timestamp ts = (Timestamp)res.get(0);
                Double v = (Double)res.get(1);
                try {
                    s1.add((double)sdf.parse(ts.toString()).getTime(), (Number)v);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SeriesException e) {
                    e.printStackTrace();
                }
            }
            it.close();
            dataset.addSeries(s1);
        }
        return dataset;
    }

    private XYDataset createDifferenceDataset(String[] lineTitle, SqlIterator[] iter) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        SqlIterator it0 = iter[0];
        SqlIterator it1 = iter[1];
        TimeSeries s0 = new TimeSeries(lineTitle[0], class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = T4ChartChart.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        TimeSeries s1 = new TimeSeries(lineTitle[1], class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = T4ChartChart.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        Minute minute = new Minute(0, 0, 1, 1, 2000);
        while (it0.hasNext() && it1.hasNext()) {
            Vector res0 = (Vector)it0.next();
            Vector res1 = (Vector)it1.next();
            Double v0 = (Double)res0.get(1);
            Double v1 = (Double)res1.get(1);
            s0.add((RegularTimePeriod)minute, v0);
            s1.add((RegularTimePeriod)minute, v1);
            minute = (Minute)minute.next();
        }
        it0.close();
        it1.close();
        dataset.addSeries(s0);
        dataset.addSeries(s1);
        dataset.setDomainIsPointsInTime(true);
        return dataset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

