/* Time-stamp: <2005-09-03 19:55:31 poser> */

/*
 * Copyright (C) 1993-2002 William J. Poser (billposer@alum.mit.edu).
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#ifdef INTLIZE
#include <libintl.h>
#else
#define gettext(x) (x)
#endif
#include "limits.h"

static char rcsid[] = "$Id: info.c,v 1.16 2005/09/03 23:32:05 poser Exp poser $";

void
PrintFlags(FILE *fp)
{
   fprintf(fp,gettext("Flags:\n"));
   fprintf(fp,gettext("\t-h                   Print usage message\n"));
   fprintf(fp,gettext("\t-v                   Print version message\n"));
   fprintf(fp,gettext("\t-D                   List defaults\n"));
   fprintf(fp,gettext("\t-F                   List command line flags\n"));
   fprintf(fp,gettext("\t-L                   List limits\n"));
   fputc('\n',fp);

   fprintf(fp,gettext("\tThe following two options must precede any sort order specifications.\n"));
   fprintf(fp,gettext("\t-B                   No characters fall outside the BMP.\n"));
   fprintf(fp,gettext("\t-p                   Do not use the Private Use areas.\n"));
   fputc('\n',fp);

   fprintf(fp,gettext("\t-b                   A record is terminated by two or more end-of-line characters.\n"));
   fprintf(fp,gettext("\t-l                   A record consists of a single line\n"));
   fprintf(fp,gettext("\t-r <separator>       A record is terminated by separator character\n"));
	
   fputc('\n',fp);
   fprintf(fp,gettext("\t-d <character>+      Fields are delimited by the named character(s)\n"));
   fprintf(fp,gettext("\t-w                   Sort on the entire text of the record\n"));
   fputc('\n',fp);	
   fprintf(fp,gettext("\t-M <records>         Set initial maximum number of records \n"));
   fprintf(fp,gettext("\t-m                   End of line is marked by Carriage Return (0x0D)\n"));
   fprintf(fp,gettext("\t-I                   Invert sense of comparisons globally\n"));
   fprintf(fp,gettext("\t-q                   Be quiet - do not chat while working\n"));
   fprintf(fp,gettext("Key specific flags:\n"));
   fprintf(fp,gettext("\t-e <m,n>             Sort on characters m through n (counting from one;\n\t\t\t\tnegative means from right)\n"));
   fprintf(fp,gettext("\t-n <field number>    Sort on the specified field (counting from one;\n\t\t\t\tnegative means from right)\n"));
   fprintf(fp,gettext("\t-t <tag regexp>      Sort on the field with the specified tag\n"));
   fprintf(fp,gettext("\t-o <comparison>      Optional: if absent compare as (<,=,>)\n"));
   fprintf(fp,gettext("\t-C                   Fold case\n"));
   fprintf(fp,gettext("\t-c <key type>        l(exicographic)\n"));
   fprintf(fp,gettext("\t                     n(umeric)\n"));
   fprintf(fp,gettext("\t                     h(ybrid)\n"));
   fprintf(fp,gettext("\t                     s(ize)\n"));
   fprintf(fp,gettext("\t                     d(ate)\n"));
   fprintf(fp,gettext("\t                     t(ime)\n"));
   fprintf(fp,gettext("\t                     i(so8601 date/time)\n"));
   fprintf(fp,gettext("\t                     r(andom)\n"));
   fprintf(fp,gettext("\t-f <date format>     Permutation of ymd with separators\n"));
   fprintf(fp,gettext("\t-W <file name>       Read separators for sort order file.\n"));
   fprintf(fp,gettext("\t-S <file name>       Read substitutions from named file\n"));
   fprintf(fp,gettext("\t-s <file name>       Read sort order from named file\n"));
   fprintf(fp,gettext("\t-x <file name>       Read exclusions from named file\n"));
   fprintf(fp,gettext("\t-X <exclusions>      Exclude specified characters\n"));
   fprintf(fp,gettext("\t-i                   Invert sense of comparisons\n"));
   fprintf(fp,gettext("\t-R                   Reverse characters of key\n"));
   fputc('\n',fp);				
	
}

void
PrintDefaults(FILE *fp)
{

   fprintf(fp,gettext("Defaults:\n"));
   fprintf(fp,gettext("    Field terminator character(s)\n"));
   fprintf(fp,gettext("        Record = line               whitespace (space or tab)\n"));
   fprintf(fp,gettext("        Record = block              end-of-line\n"));
   fprintf(fp,gettext("    Key specification               whole record\n"));
   fprintf(fp,gettext("    Initial number of records       %4d\n"),DEFMAXRECORDS);
   fprintf(fp,gettext("    Presence of key                 obligatory\n"));
   fprintf(fp,gettext("    Record type                     double end-of-line terminated block\n"));
   fprintf(fp,gettext("    Sense of sort                   forward\n"));	
   fprintf(fp,gettext("    Date format                     International Date Format (year-month-day)\n"));
   fprintf(fp,gettext("    Sort order                      numerical Unicode order\n"));
   fprintf(fp,gettext("    Sort type                       lexicographic\n"));
   fprintf(fp,"\n");
}

void
PrintLimits(FILE *fp)
{

   fprintf(fp,gettext("Limits:\n"));
   fprintf(fp,gettext("   Number of keys                     %2d\n"),MAXKEYS);
   fprintf(fp,gettext("   Number of multigraphs per key %'6d\n"),FUL_MAXMULTIGRAPHS);
   fprintf(fp,"\n");
}


void
PrintUsage(void)
{
   extern char progname[];
	
   fprintf(stdout,"\n");
   fprintf(stdout,gettext("This program sorts text using arbitrary sort orders\non fields specified on the command-line.\n"));
   fprintf(stdout,gettext("If no input file is specified, input is read from the standard input.\n"));
   fprintf(stdout,gettext("Usage: %s <flags> (<input file name>)\n"),progname);
   fprintf(stdout,gettext("Type %s -F to obtain a list of flags.\n"),progname);
   fprintf(stdout,gettext("There is also a graphical interface called msg.\n\n"));
}
