 $! File: config_h.com  $!E $! This procedure attempts to figure out how to build a config.h file  $! for the current project.  $!A $! It assumes that the CONFIGURE_THIS has been run to produce the < $! the setup_'package'_com, and that procedure has been run. $!J $! The CONFIGURE shell script will be examined for hints and a few symbolsI $! but most of the tests will not produce valid results on OpenVMS.  Some F $! will produce false positives and some will produce false negatives. $!I $! It is easier to just read the config.h_in file and make up tests based  $! on what is in it! $!J $! This file will create an empty config_vms.h file if one does not exist.F $! The config_vms.h is intended for manual edits to handle things that $! this procedure can not. $!C $! The config_vms.h will be invoked by the resulting config.h file.  $!G $! This procedure knows about the DEC C RTL on the system it is on, and = $! will also be able to detect and use the FRONTPORT library. F $! Future versions may be handle the GNV, the OpenVMS porting library, $! and others. $!M $! This procedure may not guess the options correctly for both architectures.  $!I $! P1 Indicates the porting libraries to be used.  If not specified, this 0 $!    procedure will default to using FRONTPORT. $!C $!    If you specify a P1 parameter, then it must contain the names F $!    of all porting libraries in addition to the DECC RTL that should $!    be used. $!6 $!    FRONTPORT is currently the only name recognized. $!# $! 15-Jan-2001	J. Malmberg	Original D $! 29-Apr-2001	J. Malmberg	Also look for config.*in* in a [.include] $!				subdirectory2 $! 30-Apr-2001	J. Malmberg	Update for SAMBA checksN $!============================================================================ $! $ss_normal = 1 $ss_abort = 44 $ss_control_y = 1556 $status = ss_normal ! $on control_y then goto control_y # $on warning then goto general_error  $!; $! Some information for writing timestamps to created files < $!----------------------------------------------------------% $my_proc = f$environment("PROCEDURE") E $my_proc_file = f$parse(my_proc,,,"NAME") + f$parse(my_proc,,,"TYPE") 
 $tab[0,8] = 9 = $datetime = f$element(0,".",f$cvtime(,"ABSOLUTE","DATETIME")) 2 $username = f$edit(f$getjpi("","USERNAME"),"TRIM") $! $pid = f$getjpi("","PID") 2 $tfile1 = "SYS$SCRATCH:config_h_temp1_''pid'.TEMP"2 $dchfile = "SYS$SCRATCH:config_h_decc_''pid'.TEMP" $! $!! $! Has the proper setup been run? ! $!------------------------------- - $prj_setup_file = "PRJ_SRC:SETUP_*_BUILD.COM"   $if f$trnlnm("PRJ_SRC") .eqs. "" $then # $   file = f$search(prj_setup_file)  $   if file .eqs. "" $   thenI $	write sys$output "Configure_this.com must be run before this procedure"  $	status = ss_abort  $	goto all_exit  $   else $!@ $!	Help the person out and run the setup procedure to create the $!	logical namesH $!----------------------------------------------------------------------	 $	@'file' 	 $   endif  $endif* $prj_setup_file = f$search(prj_setup_file) $!  $! Look for possible options of:/ $! "DECCRTL,FRONTPORT,POSIX,GNV,DIICOE,VMSPORT" / $!---------------------------------------------  $!@ $! Note POSIX,GNV,DIICOE are more likely to try a real configureE $!-------------------------------------------------------------------  $! $!  Should we use FRONTPORT? $!---------------------------  $use_frontport = 0( $if f$trnlnm("FRONTPORT__CRTL") .nes. "" $then  $! $!  Frontport library detected $!-----------------------------  $   if p1 .nes. "" $   then $	x1 = "," + p1 ? $	if f$locate(",F",x1) .lt. f$length(x1) then use_frontport = 1  $   else $	use_frontport = 1 	 $   endif  $endif $!' $!  Quick cheat to get the project name ' $!------------------------------------- F $   proj_name = f$parse(prj_setup_file,,,"NAME") - "SETUP_" - "_BUILD" $! $! Does config_vms.h exist?  $!-------------------------  $update_config_vms = 0( $file = f$search("PRJ_SRC:config_vms.h") $if file .nes. ""  $then : $   write sys$output "Found existing custom file ''file'." $else  $   update_config_vms = 1 A $   write sys$output "Creating new PRJ_SRC:CONFIG_VMS.H for you."  $   gosub write_config_vms $endif $! $! $! Write out the header  $!---------------------- $gosub write_config_h_header $! $! $!A $! config.h.in could have at least four different names depending ' $! on how it was transferred to OpenVMS D $!------------------------------------------------------------------( $cfile = f$search("PRJ_SRC:config.h.in") $if cfile .eqs. "" $then + $   cfile = f$search("PRJ_SRC:config.h_in")  $   if cfile .eqs. ""  $   then, $	cfile = f$search("PRJ_SRC:config__2eh.in") $	if cfile .eqs. ""  $	then0 $	    cfile = f$search("PRJ_SRC:config.h__2ein") $	endif 	 $   endif  $endif$ $if f$trnlnm("PRJ_INCLUDE") .nes. "" $then / $   cfile = f$search("PRJ_INCLUDE:config.h.in")  $   if cfile .eqs. ""  $   then- $	cfile = f$search("PRJ_INCLUDE:config.h_in")  $	if cfile .eqs. ""  $	then4 $	    cfile = f$search("PRJ_INCLUDE:config__2eh.in") $	    if cfile .eqs. "" 
 $	    then1 $		cfile = f$search("PRJ_INCLUDE:config.h__2ein")  $	    endif  $	endif 
 $    endif $endif $if cfile .eqs. "" $then 7 $   write sys$output "Can not find PRJ_SRC:config.h.in"  $   write sys$output -G   "Looked for config.h.in, config.h_in, config__2eh.in, config.h__2ein" ' $   if f$trnlnm("PRJ_INCLUDE") .nes. ""  $   thenA $	write sys$output "Also looked in PRJ_INCLUDE: for these files." 	 $   endif  $! $   write tf ""  $   write tf -H 	"   /* Could not find PRJ_SRC:config.h.in                           */" $   write tf -F 	"  /*  Looked also for config.h_in, config__2eh.in, config.h__2ein */' $   if f$trnlnm("PRJ_INCLUDE") .nes. ""  $   then $	write tf -9 	" /* Also looked in PRJ_INCLUDE: for these files.		  */" 	 $   endif  $   write tf -D 	"/*--------------------------------------------------------------*/ $   write tf ""  $   goto write_tail  $endif $! $!# $! Locate the DECC libraries in use % $!----------------------------------- : $decc_rtldef = f$parse("decc$rtldef","sys$library:.tlb;0")2 $decc_shr = f$parse("decc$shr","sys$share:.exe;0") $!) $! Dump the DECC header names into a file * $!----------------------------------------6 $if f$search(dchfile) .nes. "" then delete 'dchfile';*4 $if f$search(tfile1) .nes. "" then delete 'tfile1';*  $define/user sys$output 'tfile1' $library/list 'decc_rtldef' . $open/read/error=rtldef_loop1_end tf1 'tfile1'0 $open/write/error=rtldef_loop1_end tf2 'dchfile' $rtldef_loop1:) $   read/end=rtldef_loop1_end tf1 line_in - $   line_in = f$edit(line_in,"TRIM,COMPRESS") # $   key1 = f$element(0," ",line_in) # $   key2 = f$element(1," ",line_in) ? $   if key1 .eqs. " " .or. key1 .eqs. "" then goto rtldef_loop1 @ $   if key2 .nes. " " .and. key2 .nes. "" then goto rtldef_loop1 $   write tf2 "|",key1,"|" $   goto rtldef_loop1  $rtldef_loop1_end:G $if f$trnlnm("tf1","lnm$process",,"SUPERVISOR") .nes. "" then close tf1 G $if f$trnlnm("tf2","lnm$process",,"SUPERVISOR") .nes. "" then close tf2 4 $if f$search(tfile1) .nes. "" then delete 'tfile1';* $! $!8 $! Now calculate what should be in the file from reading $! config.h.in and CONFIGURE. A $!---------------------------------------------------------------  $open/read inf 'cfile' $do_comment = 0 
 $if_block = 0  $cfgh_in_loop1:  $!set nover * $   read/end=cfgh_in_loop1_end inf line_in+ $   xline = f$edit(line_in,"TRIM,COMPRESS")  $! $!  Blank line handling  $!---------------------  $   if xline .eqs. ""  $   then
 $	write tf ""  $	goto cfgh_in_loop1	 $   endif  $   xlen = f$length(xline) $   key = f$extract(0,2,xline) $!) $!  deal with comments by copying exactly + $!----------------------------------------- 0 $   if (do_comment .eq. 1) .or. (key .eqs. "/*") $   then $	do_comment = 1 $	write tf line_in% $	key = f$extract(xlen - 2, 2, xline) ' $	if key .eqs. "*/" then do_comment = 0  $	goto cfgh_in_loop1	 $   endif  $! $!  Some quick parsing $!----------------------  $   keyif = f$extract(0,3,xline)! $   key1 = f$element(0," ",xline) ! $   key2 = f$element(1," ",xline) ! $   key2a = f$element(0,"_",key2) ! $   key2b = f$element(1,"_",key2)  $   key2_len = f$length(key2) - $   key2_h = f$extract(key2_len - 2, 2, key2) - $   key2_t = f$extract(key2_len - 5, 5, key2) . $   if key2_t .eqs. "_TYPE" then key2_h = "_T"
 $   key64 = 0 5 $   if f$locate("64", xline) .lt. xlen then key64 = 1  $!% $!write sys$output "xline = ''xline'"  $!+ $!  Comment out this section of the ifblock + $!-----------------------------------------  $   if if_block .ge. 3 $   then $	write tf "/* ", xline, " */"( $	if keyif .eqs. "#en" then if_block = 0 $	goto cfgh_in_loop1	 $   endif  $!  $!  Handle the end of an ifblock! $!-------------------------------  $   if keyif .eqs. "#en" $   then $	write tf xline $	if_block = 0 $	goto cfgh_in_loop1	 $   endif  $! $   if key1 .eqs. "#ifndef"  $   then, $!	Manual check for _ALL_SOURCE on AIX error1 $!-----------------------------------------------  $	if key2 .eqs. "_ALL_SOURCE"  $	then! $	   write tf "/* ", xline, " */"  $!" $!	   Ignore the rest of the block( $!-------------------------------------- $	   if_block = 3  $	   goto cfgh_in_loop1  $	endif 	 $   endif  $! $!* $!  Default action for an #if/#else/#endif, $!------------------------------------------/ $   if keyif .eqs. "#if" .or. keyif .eqs. "#el"  $   then $	if_block = 1 $	write tf xline $	goto cfgh_in_loop1	 $   endif  $! $! $!  Process "normal?" stuff  $!---------------------------  $   if key1 .eqs. "#undef" $   then! $	key2c = f$element(2, "_", key2) = $	if (key2c .eqs. "_") .or. (key2c .eqs. "H") then key2c = "" ! $	key2d = f$element(3, "_", key2) = $	if (key2d .eqs. "_") .or. (key2d .eqs. "H") then key2d = ""  $	if key2d .eqs. "T" $	then% $	    key2e = f$element(4, "_", key2)  $	    if key2e .eqs. "TYPE" 
 $	    then $		key2_h = "_T"
 $		key2d = ""  $	    endif  $	endif  $! $	double_under = 0/ $	if key2a .eqs. "HAVE" .or. key2a .eqs. "STAT"  $	then $!  $!	    Process extra underscores& $!------------------------------------0 $	    if f$locate("HAVE___", key2) .lt. key2_len
 $	    then $		key2b = "__" + key2dc
 $		key2d = ""! $		double_under = 1t
 $	    else, $		if f$locate("HAVE__", key2) .lt. key2_len $		thene $		    key2b = "_" + key2c $		    key2c = ""U $		    double_under = 1r $		endif $	    endifp $! $	    if key2_h .eqs. "_H"
 $	    then $! $!		Looking for a header filer) $!---------------------------------------m $		headf = key2b5 $		if key2c .nes. "" then headf = headf + "_" + key2c 5 $		if key2d .nes. "" then headf = headf + "_" + key2dr $! $!		   (key2b .eqs. "READLINE")e $! $!		Some special parsing, $!------------------------------------------: $		if (key2b .eqs. "SYS") .or. (key2b .eqs. "ARPA") .or. -5 		   (key2b .eqs. "NET") .or. (key2b .eqs. "NETINET")i $		theno $		    if key2c .nes. "" $		    then! $			headf = key2c 6 $			if key2d .nes. "" then headf = key2c + "_" + key2d $		    endif $		endif $!9 $!		And of course what's life with out some special casestF $!-------------------------------------------------------------------- $		if key2b .eqs. "FILE" $		thend $		   write sys$output ""t $		   write sys$output -1   "%CONFIG_H-I-NONPORT, ''key2' being asked for!"  $		   write sys$output -F  "-CONFIG_H-I-FILE_OLD, file.h will not be configured as is obsolete!" $		   write sys$output -F  "-CONFIG_H_I-FCNTL_NEW, "Expecting fcntl.h to be configured instead!" $		   write sys$output -9  "-CONFIG_H_I-FCNTL_CHK, "Unable to verify at this time!"n $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!"t $! $		    if update_config_vms1 $		    then ) $			open/append tfcv PRJ_SRC:CONFIG_VMS.He $			write tfcv ""n $			write tfcv -= 		"/* Check config.h for use of fcntl.h instead of file.h */"o $			write tfcv ""= $			close tfcv $		    endif $		endif $!# $!		Now look it up in the DEC C RTLs/ $!---------------------------------------------6 $		define/user sys$output nl:t $		define/user sys$error nl:. $		search/output=nl: 'dchfile' |'headf'|/exact $		if '$severity' .eq. 1 $		thent. $		    if key64 then write tf "#ifdef __ALPHA"! $		    write tf "#ifndef ''key2'"_# $		    write tf "#define ''key2' 1"mF $if p2 .nes. "" then write sys$output "''dchfile' - #define ''key2' 1" $		    write tf "#endif"& $		    if key64 then write tf "#endif" $		    goto cfgh_in_loop1d $		endif $!# $!		Try the FRONTPORT__DIR listingst0 $!----------------------------------------------4 $		if use_frontport .ne. 0 .and. double_under .eq. 0 $		thenT1 $		    xx = f$search("FRONTPORT__DIR:''headf'.H")! $		    if xx .nes. ""- $		    thenj< $			write tf " /* In header file supplied with FRONTPORT */"; $			write tf "/*----------------------------------------*/" + $			if key64 then write tf "#ifdef __ALPHA"u $			write tf "#ifndef ''key2'"  $			write tf "#define ''key2' 1" $if p2 .nes. ""  $thenaA $   write sys$output "FRONTPORT__DIR:''headf'  #define ''key2' 1"o $endif $			write tf "#endif"l# $			if key64 then write tf "#endif"- $			goto cfgh_in_loop1 $		    endif $		endif
 $	    else $!% $!		Looking for a routine or a symbolp2 $!------------------------------------------------ $		if key2c .eqs. "MACRO"I $		thenC: $		    if (key2b .eqs. "FILE") .or. (key2b .eqs. "DATE") -6 			.or. (key2b .eqs. "LINE") .or. (key2b .eqs. "TIME") $		    thenu$ $			write tf "#ifndef HAVE_''key2b'"& $			write tf "#define HAVE_''key2b' 1" $			write tf "#endif"N $		    endif $		    goto cfgh_in_loop1u $		endif $! $!		Special false testsR' $!-------------------------------------p $		if double_under $		then-9 $		    if key2b .eqs. "_FCNTL" .or. key2b .eqs. "__FCNTL"1 $		    then ) $			write tf "/* #undef HAVE_''key2b' */"e $			goto cfgh_in_loop1 $		    endif $!7 $		    if key2b .eqs. "_STAT" .or. key2b .eqs. "__STAT"t $		    thenn) $			write tf "/* #undef HAVE_''key2b' */"- $			goto cfgh_in_loop1 $		    endif $!7 $		    if key2b .eqs. "_READ" .or. key2b .eqs. "__READ"h $		    then-) $			write tf "/* #undef HAVE_''key2b' */"s $			goto cfgh_in_loop1 $		    endif $		endif $! $		keysym = key2be7 $		if key2c .nes. "" then keysym = keysym + "_" + key2cl7 $		if key2d .nes. "" then keysym = keysym + "_" + key2du $! $!		Stat structure members' $!-------------------------------------g $		if key2b .eqs. "ST" $		thent# $		    keysym = key2b + "_" + key2c-* $		    keysym = f$edit(keysym,"LOWERCASE") $		endif $		if key2a .eqs. "STAT" $		thenrB $		    if (f$locate("STATVFS", key2b) .eq. 0) .and. key2c .eqs. "" $		    then-' $			keysym = f$edit(key2b, "LOWERCASE")- $		    endif? $!$		    if (key2b .eqs. "STATVFS" .or. key2b .eqs. "STATFS2" - 5 $!			.or. key2b .eqs. "STATFS3") .and. key2c .nes. ""i $!6 $		    if (key2b .eqs. "STATVFS") .and. key2c .nes. "" $		    thenf, $!			Should really verify that the structure* $!			named by key2b actually exists first.> $!------------------------------------------------------------ $! $!			Statvfs structure members3 $!------------------------------------------------- - $			keysym = "f_" + f$edit(key2c,"LOWERCASE")i $		    endif $		endif $! $!		UTMPX structure members:( $!--------------------------------------- $		if key2b .eqs. "UT" .and. key2c .eqs. "UT"c $		then21 $		    keysym = "ut_" + f$edit(key2d,"LOWERCASE")  $		endif $!) $		if f$locate("MMAP",key2) .lt. key2_len  $		thenS $		   write sys$output ""  $		   write sys$output -1   "%CONFIG_H-I-NONPORT, ''key2' being asked for!"h $		   write sys$output -J  "-CONFIG_H-I-MMAP, MMAP operations only work on STREAM and BINARY files!" $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!"" $		    if update_config_vmsc $		    then ) $			open/append tfcv PRJ_SRC:CONFIG_VMS.H  $			write tfcv ""  $			write tfcv -4 		"/* Check config.h for use of ''key2' settings */" $			write tfcv ""  $			close tfcv $		    endif $		endif $! $! $		if keysym .eqs. "CRYPT" $		then  $		   write sys$output ""  $		   write sys$output -1   "%CONFIG_H-I-NONPORT, ''key2' being asked for!"t $		   write sys$output -F  "-CONFIG_H-I-CRYPT, CRYPT operations on the VMS SYSUAF may not work!" $		   write sys$output -M  "-CONFIG_H_I-FPORT, FRONTPORT FPORT__VMS_CRYPT requires special conditions!"s $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!"  $		    if update_config_vms- $		    then-) $			open/append tfcv PRJ_SRC:CONFIG_VMS.He $			write tfcv ""$ $			write tfcv -- 		"/* Check config.h for use of ''keysym' */"o $			write tfcv ""b $			close tfcv $		    endif $		endif $! $! $		if keysym .eqs. "EXECL" $		then/ $		   write sys$output ""' $		   write sys$output -1   "%CONFIG_H-I-NONPORT, ''key2' being asked for!"e $		   write sys$output -?  "-CONFIG_H-I-EXCEL, EXECL configured, Will probably not work."e $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!"e $		    if update_config_vms  $		    then.) $			open/append tfcv PRJ_SRC:CONFIG_VMS.Hf $			write tfcv ""  $			write tfcv -- 		"/* Check config.h for use of ''keysym' */"r $			write tfcv """ $			close tfcv $		    endif $		endif $! $		if keysym .eqs. "VOLATILE"  $		thent' $		    write tf "#ifndef HAVE_VOLATILE".) $		    write tf "#define HAVE_VOLATILE 1"c $		    write tf "#endif" $		    goto cfgh_in_loop1c $		endif $! $		if keysym .eqs. "ERRNO_DECL"- $		then-) $		    write tf "#ifndef HAVE_ERRNO_DECL"/+ $		    write tf "#define HAVE_ERRNO_DECL 1"  $		    write tf "#endif" $		    goto cfgh_in_loop1g $		endif $! $		if keysym .eqs. "LONGLONG"t $		then"  $		    write tf "#ifdef __ALPHA"6 $		    write tf "#pragma message disable longlongtype"' $		    write tf "#ifndef HAVE_LONGLONG"c) $		    write tf "#define HAVE_LONGLONG 1"t $		    write tf "#endif" $		    write tf "#endif" $		    goto cfgh_in_loop1  $		endif $!: $		if keysym .eqs. "FCNTL_LOCK" .and. use_frontport .ne. 0 $		then. $		    write sys$output -h0   "%CONFIG_H-I-NONPORT, ''key2' being asked for! $		   write sys$output -O  "-CONFIG_H-I-FCNTL_LOCK, RMS locking from FRONTPORT library requires patches!"  $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!", $			    write tf -5 	" /* Routine found in the FRONTPORT shared image */"e $			    write tf -4 	"/*---------------------------------------------*/"( $		    write tf "#ifndef HAVE_''keysym'"* $		    write tf "#define HAVE_''keysym' 1"K $if p2 .nes. "" then write sys$output "FRONTPORT__CRTL #define ''keysym' 1"k $		    write tf "#endif"* $		    write tf "#ifndef HAVE_FCNTL_PATCH", $		    write tf "#define HAVE_FCNTL_PATCH 1" $		    write tf "#endif" $		    if update_config_vmsf $		    then-) $			open/append tfcv PRJ_SRC:CONFIG_VMS.H  $			write tfcv ""  $			write tfcv -5 		"/* FCNTL_LOCK requested, requires source patch */"b $			write tfcv ""g $			close tfcv $		    endif $		    goto cfgh_in_loop1o $		endif $!/ $!		Frontport has the TZ option in GETTIMEOFDAY"< $!----------------------------------------------------------? $		if keysym .eqs. "GETTIMEOFDAY_TZ" .and. use_frontport .ne. 0M $		thenc $		    write tf -n5 	" /* Routine found in the FRONTPORT shared image */"- $		    write tf -e4 	"/*---------------------------------------------*/". $		    write tf "#ifndef HAVE_GETTIMEOFDAY_TZ"0 $		    write tf "#define HAVE_GETTIMEOFDAY_TZ 1"K $if p2 .nes. "" then write sys$output "FRONTPORT__CRTL #define ''keysym' 1"a $		    write tf "#endifs $		    goto cfgh_in_loop1- $		endif $!* $!		Frontport provides READLINE simulation7 $!-----------------------------------------------------x; $		if keysym .eqs. "LIBREADLINE" .and. use_frontport .ne. 0n $		thent $		    write tf --8 	" /* Library supplied in the FRONTPORT shared image */" $		    write tf -,7 	"/*------------------------------------------------*/""* $		    write tf "#ifndef HAVE_LIBREADLINE", $		    write tf "#define HAVE_LIBREADLINE 1"K $if p2 .nes. "" then write sys$output "FRONTPORT__CRTL #define ''keysym' 1"l $		    write tf "#endif  $		    goto cfgh_in_loop1	 $		endif $!1 $!		These libraries are provided by the DEC C RTL ? $!-------------------------------------------------------------.: $		if keysym .eqs. "LIBINET" .or. keysym .eqs. "LIBSOCKET" $		then-( $		    write tf "#ifndef HAVE_''keysym'"* $		    write tf "#define HAVE_''keysym' 1"G $if p2 .nes. "" then write sys$output "''decc_shr' #define ''keysym' 1"l $		    write tf "#endif_ $		    goto cfgh_in_loop1t $		endif $!@ $		if keysym .eqs. "FTRUNCATE_EXTEND" .and. use_frontport .ne. 0 $		then  $		    write sys$output -k0   "%CONFIG_H-I-NONPORT, ''key2' being asked for! $		   write sys$output -O  "-CONFIG_H-I-FTRNCT_EXT, FRONTPORT library FTRUNCATE_EXTEND has side effects!"d $		   write sys$output -3  "-CONFIG_H-I-REVIEW, Manual Code review required!"r $		    write tf - 5 	" /* Routine found in the FRONTPORT shared image */"- $		    write tf --4 	"/*---------------------------------------------*/"/ $		    write tf "#ifndef HAVE_FTRUNCATE_EXTEND")1 $		    write tf "#define HAVE_FTRUNCATE_EXTEND 1" K $if p2 .nes. "" then write sys$output "FRONTPORT__CRTL #define ''keysym' 1"h $		    write tf "#endif" $		    if update_config_vms  $		    thenu) $			open/append tfcv PRJ_SRC:CONFIG_VMS.Ht $			write tfcv ""- $			write tfcv -5 		"/* Check config.h use of HAVE_FTRUNCATE_EXTEND */"F $			write tfcv ""  $			close tfcv $		    endif $		    goto cfgh_in_loop1F $		endif $!3 $		if keysym .eqs. "HERRNO" then keysym = "h_errno"-4 $		if keysym .eqs. "UTIMBUF" then keysym = "utimbuf" $		if key2c .eqs. "STRUCT" $		thenu) $		    keysym = f$edit(key2d,"LOWERCASE")  $		elseo $		    if key2_h .eqs. "_T"  $		    thenu $			if key2_t .eqs. "_TYPE"H $			then; $			    keysym = f$extract(0, key2_len - 5, key2) - "HAVE_"I	 $			endifW' $			keysym = f$edit(keysym,"LOWERCASE")  $		    endif $		endif $!* $!		Check the DEC C RTL shared image first8 $!------------------------------------------------------6 $		if f$search(tfile1) .nes. "" then delete 'tfile1';* $		define/user sys$output nl:f $		define/user sys$error nl:8 $		search/format=nonull/out='tfile1' 'decc_shr' 'keysym' $		if '$severity' .eq. 1 $		thend $!, $!		    Not documented, but from observation8 $!------------------------------------------------------! $		    define/user sys$output nl:	  $		    define/user sys$error nl:  $		    search/out=nl: 'tfile1' ->    "$''keysym'<BS>","$g''keysym'<BS>","$__utc_''keysym'<BS>",-I    "$__utctz_''keysym'<BS>","$__bsd44_''keysym'<BS>","$bsd_''keysym'<BS>"  $		    severity = '$severity'w $!/ $!		    Of course the 64 bit stuff is differentf; $!----------------------------------------------------------% $		    if severity .ne. 1 .and. key64s $		    thenn $			define/user sys$output nl: $			define/user sys$error nl:"- $			search/out=nl: 'tfile1' "$_''keysym'<BS>".* $!			search/out 'tfile1' "$_''keysym'<BS>" $			severity = '$severity' $		    endif $!# $!		    UNIX compatability routines-/ $!---------------------------------------------f $		    if severity .ne. 1i $		    then" $			define/user sys$output nl: $			define/user sys$error nl:  $			search/out=nl: 'tfile1' -DJ     "$__unix_''keysym'<BS>","$__vms_''keysym'<BS>","$_posix_''keysym'<BS>" $			severity = '$severity' $		    endif $!% $!		    Show the result of the searche2 $!------------------------------------------------ $		    if 'severity' .eq. 1- $		    then-+ $			if key64 then write tf "#ifdef __ALPHA"  $			write tf "#ifndef ''key2'"  $			write tf "#define ''key2' 1"E $if p2 .nes. "" then write sys$output "''decc_shr' #define ''key2' 1"" $			write tf "#endif" # $			if key64 then write tf "#endif"" $			goto cfgh_in_loop1 $		    endif $		endif6 $		if f$search(tfile1) .nes. "" then delete 'tfile1';* $!$ $!		Check the DECC Header files next0 $!---------------------------------------------- $		define/user sys$output nl:  $		define/user sys$error nl:! $		search/out=nl: 'decc_rtldef' -/: 		    "''keysym';", "''keysym'[", "struct ''keysym'"/exact $		severity = '$severity'. $		if severity .eq. 1t $		then	. $		    if key64 then write tf "#ifdef __ALPHA"! $		    write tf "#ifndef ''key2'"	# $		    write tf "#define ''key2' 1"bH $if p2 .nes. "" then write sys$output "''decc_rtldef' #define ''key2' 1" $		    write tf "#endif"& $		    if key64 then write tf "#endif" $		    goto cfgh_in_loop1" $		endif $!$ $!		Check the FRONTPORT library next1 $!-----------------------------------------------	6 $		if use_frontport .ne. 0 .and. double_under .eq. 0 - 		   .and. keysym .nes. "ROOT" $		thent! $		    define/user sys$output nl:2  $		    define/user sys$error nl:A $		    search/format=nonull/out='tfile1' FRONTPORT__CRTL 'keysym'i $		    severity = '$severity'e $		    if severity .eq. 1  $		    then  $			define/user sys$output nl: $			define/user sys$error nl: + $			search/out=nl: 'tfile1' "''keysym'<BS>"S $			if '$severity' .eq. 1  $			then $			    write tf -5 	" /* Routine found in the FRONTPORT shared image */"e $			    write tf -4 	"/*---------------------------------------------*/"/ $			    if key64 then write tf "#ifdef __ALPHA"-" $			    write tf "#ifndef ''key2'"$ $			    write tf "#define ''key2' 1"I $if p2 .nes. "" then write sys$output "FRONTPORT__CRTL #define ''key2' 1"	 $			    write tf "#endif"y' $			    if key64 then write tf "#endif"  $			    goto cfgh_in_loop1	 $			endif- $		    endif $!, $!		    Look for it in a supplimental header> $!------------------------------------------------------------! $		    define/user sys$output nl:i  $		    define/user sys$error nl:* $		    search/out=nl: FRONTPORT__DIR:*.H -6 		"''keysym';", "''keysym'[", "struct ''keysym'"/exact $		    severity = '$severity't $		    if severity .eq. 1- $		    theno $			write tf -4 	" /* symbol found in the FRONTPORT header files */" $			write tf -3 	"/*--------------------------------------------*/" + $			if key64 then write tf "#ifdef __ALPHA"p $			write tf "#ifndef ''key2'"  $			write tf "#define ''key2' 1"L $if p2 .nes. "" then write sys$output "FRONTPORT__DIR:*.H #define ''key2' 1" $			write tf "#endif"e# $			if key64 then write tf "#endif". $			goto cfgh_in_loop1 $		    endif $		endif $	    endift" $	    write tf "/* ", xline, " */" $	    goto cfgh_in_loop1 $	endif  $! $!+ $!	Process SIZEOF directives found in SAMBAa2 $!------------------------------------------------ $	if key2a .eqs. "SIZEOF"- $	then2 $	    if key2b .eqs. "INO" .and. key2_h .eqs. "_T"
 $	    then" $		write tf "#ifndef SIZEOF_INO_T"& $		write tf "#define SIZEOF_INO_T (6)" $		write tf "#endif" $		goto cfgh_in_loop1	 $	    endiff2 $	    if key2b .eqs. "OFF" .and. key2_h .eqs. "_T"
 $	    then" $		write tf "#ifndef SIZEOF_OFF_T"& $		write tf "#define SIZEOF_OFF_T (4)" $		write tf "#endif" $		goto cfgh_in_loop1  $	    endif" $	    if key2b .eqs. "INT"
 $	    then  $		write tf "#ifndef SIZEOF_INT"$ $		write tf "#define SIZEOF_INT (4)" $		write tf "#endif" $		goto cfgh_in_loop1I $	    endifE $	    if key2b .eqs. "LONG"y
 $	    then! $		write tf "#ifndef SIZEOF_LONG"I% $		write tf "#define SIZEOF_LONG (4)"e $		write tf "#endif" $		goto cfgh_in_loop1e $	    endifa $	    if key2b .eqs. "SHORT"
 $	    then" $		write tf "#ifndef SIZEOF_SHORT"& $		write tf "#define SIZEOF_SHORT (2)" $		write tf "#endif" $		goto cfgh_in_loop1e $	    endiff" $	    write tf "/* ", xline, " */" $	    goto cfgh_in_loop1 $	endiff $! $!	Process NEED directives! $!-------------------------------  $	if key2a .eqs. "NEED"  $	then6 $	    if key2b .eqs. "STRINGS" .and. key2_h .eqs. "_H"
 $	    then$ $		write tf "#ifndef NEED_STRINGS_H"& $		write tf "#define NEED_STRINGS_H 1" $		write tf "#endif" $		goto cfgh_in_loop1  $	    endifi" $	    write tf "/* ", xline, " */" $	    goto cfgh_in_loop1 $	endif  $!1 $!	Process ENABLE directives (Allow DCL OVERRIDE)s6 $!---------------------------------------------------- $	if key2a .eqs. "ENABLE"t $	then $	    fnam = key2 - "ENABLE_"i9 $	    fflag = "with_" + f$edit(fnam,"LOWERCASE") + "=yes"i# $	    tsym = "''proj_name'_''key2'".& $	    if f$type('tsym') .eqs. "STRING"
 $	    then $		tsym_val = &'tsym't $		if tsym_val $		thenN! $		    write tf "#ifndef ''key2'" # $		    write tf "#define ''key2' 1"C $		    write tf "#endif" $		    goto cfgh_in_loop1  $		endif $	    endif   $	    define/user sys$output nl: $	    define/user sys$error nl: 8 $	    search/out=nl: PRJ_SRC:configure. "''fflag'"/exact $	    if '$severity' .eq. 1t
 $	    then $		write tf "#ifndef ''key2'"- $		write tf "#define ''key2' 1"  $		write tf "#endif" $		goto cfgh_in_loop1e $	    endife" $	    write tf "/* ", xline, " */" $	    goto cfgh_in_loop1 $	endife $! $!	Process STATFS directives! $!-------------------------------V $!	if key2a .eqs. "STATFS" $!	theni# $!	    write tf "/* ", xline, " */"t $!	    goto cfgh_in_loop1e $!	endif $! $!	Process inline directive   $!------------------------------ $	if key2 .eqs. "inline" $	then $	    write tf "#ifndef inline"s( $	    write tf "#define inline __inline" $	    write tf "#endif"f $	    goto cfgh_in_loop1 $	endifd $! $!	Process RETSIGTYPE directiveo$ $!---------------------------------- $	if key2 .eqs. "RETSIGTYPE" $	then# $	    write tf "#ifndef RETSIGTYPE"Y( $	    write tf "#define RETSIGTYPE void" $	    write tf "#endif"/ $	    goto cfgh_in_loop1 $	endifa $!  $!	Process STDC_HEADERS (SAMBA!) $!---------------------------- $	if key2 .eqs. "STDC_HEADERS" $	then% $	    write tf "#ifndef STDC_HEADERS"e' $	    write tf "#define STDC_HEADERS 1"  $	    write tf "#endif"s $	    goto cfgh_in_loop1 $	endifk $! $!	Process PROTOTYPES directive ' $!-------------------------------------  $	if key2 .eqs. "PROTOTYPES" $	then# $	    write tf "#ifndef PROTOTYPES"-% $	    write tf "#define PROTOTYPES 1". $	    write tf "#endif"u $	    goto cfgh_in_loop1 $	endif  $!# $!	Special for SEEKDIR_RETURNS_VOID ) $!---------------------------------------e& $	if key2 .eqs. "SEEKDIR_RETURNS_VOID" $	then- $	    write tf "#ifndef SEEKDIR_RETURNS_VOID"_/ $	    write tf "#define SEEKDIR_RETURNS_VOID 1"A $	    write tf "#endif"  $	endife $!6 $!	Unknown - See if CONFIGURE can give a clue for this< $!---------------------------------------------------------- $	pflag = 0r $	set_flag = 0* $	gproj_name = proj_name - "_VMS" - "-VMS"5 $	if f$search(tfile1) .nes. "" then delete 'tfile1';*. $	define/user sys$output nl: $	define/user sys$error nl: 8 $	if f$locate("FILE", key2) .lt. key2_len then pflag = 1; $	if f$locate("DIR", key2) .eq. key2_len - 3 then pflag = 1 < $	if f$locate("PATH", key2) .eq. key2_len - 4 then pflag = 19 $	search/out='tfile1' PRJ_SRC:configure. "''key2'="/exact. $	search_sev = '$severity' $	if 'search_sev' .eq. 1 $	then3 $	    open/read/err=unknown_cf_rd_error sf 'tfile1'2+ $	    read/end=unknown_cf_rd_err sf line_in & $	    skey1 = f$element(0,"=",line_in) $	    if skey1 .eqs. key2d
 $	    then# $		skey2 = f$element(1,"=",line_in)_  $		skey2a = f$extract(0,2,skey2) $!: $!		Keep these two cases separate to make it easier to add, $!		more future intelligence to this routineH $!---------------------------------------------------------------------- $		if skey2a .eqs. """`" $		theni $		    if pflag .eq. 1 $		    then1 $			write tf "#ifndef ''key2'"; $			write tf "#define ",key2," """,gproj_name,"_",key2,""""e $			write tf "#endif"  $		    else_ $!			Ignore this for now, $!------------------------------------------  $			write tf "/* ", xline, " */" $		    endif $		    set_flag = 1A $		    goto found_in_configure $		endif $		if skey2a .eqs. """$" $		then  $		    if pflag .eq. 1 $		    thene $			write tf "#ifndef ''key2'"; $			write tf "#define ",key2," """,gproj_name,"_",key2,""""m $			write tf "#endif"  $		    elset $!			Ignore this for now- $!-------------------------------------------2  $			write tf "/* ", xline, " */" $		    endif $		    set_flag = 1  $		    goto found_in_configure $		endif $		write tf "#ifndef ''key2'" , $		write tf "#define ",key2," """,skey2,"""" $		write tf "#endif" $		set_flag = 1E
 $	    else $		if pflag .eq. 1 $		then-! $		    write tf "#ifndef ''key2'"-> $		    write tf "#define ",key2," """,gproj_name,"_",key2,"""" $		    write tf "#endif" $		    set_flag = 1s $		endif $	    endif/ $found_in_configure: $unknown_cf_rd_err:y< $	    if f$trnlnm("sf","lnm$process",,"SUPERVISOR") .nes. ""
 $	    then $		close sfn $	    endif-9 $	    if f$search(tfile1) .nes. "" then delete 'tfile1';*/0 $	    if set_flag .eq. 1 then goto cfgh_in_loop1 $	endif 	 $   endifu $! $! $!7 $!  If it falls through everything else, comment it outs7 $!-----------------------------------------------------m  $   write tf "/* ", xline, " */" $   goto cfgh_in_loop1 $cfgh_in_loop1_end:u
 $close inf $! $! $! Write out the tail- $!-------------------- $write_tail: $gosub write_config_h_tail $! $! Exit and clean up $!-------------------- $general_error:t $status = '$status' 
 $all_exit:	 $set noonrE $if f$trnlnm("sf","lnm$process",,"SUPERVISOR") .nes. "" then close sfeE $if f$trnlnm("tf","lnm$process",,"SUPERVISOR") .nes. "" then close tfcG $if f$trnlnm("inf","lnm$process",,"SUPERVISOR") .nes. "" then close inf G $if f$trnlnm("tf1","lnm$process",,"SUPERVISOR") .nes. "" then close tf1 G $if f$trnlnm("tf2","lnm$process",,"SUPERVISOR") .nes. "" then close tf2nI $if f$trnlnm("tfcv","lnm$process",,"SUPERVISOR") .nes. "" then close tfcvi! $if f$type(tfile1) .eqs. "STRING"  $then 7 $   if f$search(tfile1) .nes. "" then delete 'tfile1';*- $endif" $if f$type(dchfile) .eqs. "STRING" $then 9 $   if f$search(dchfile) .nes. "" then delete 'dchfile';*A $endif $exit 'status' $! $! $control_y:  $   status = ss_control_y  $   goto all_exiti $! $! $!$ $! Gosub to write a new config_vms.h% $!-----------------------------------  $write_config_vms:! $outfile = "PRJ_SRC:CONFIG_VMS.H"f $create 'outfile'$ $open/append tf 'outfile'n! $write tf "/* File: CONFIG_VMS.H"h $write tf "**"E $write tf "** This file contains the manual edits needed for porting"s2 $write tf "** the ''proj_name' package to OpenVMS. $write tf "**"J $write tf "** Edit this file as needed.  The procedure that automatically"H $write tf "** generated this header stub will not overwrite or make any"$ $write tf "** changes to this file." $write tf "**" $write tf -yD  "** ", datetime, tab, username, tab, "Generated by ''my_proc_file'" $write tf "**" $write tf -dO  "**========================================================================*/"" $write tf "" $if use_frontport .ne. 0 $then	 $write tf ""H $write tf " /* Porting library defines wrappers for common functions */"G $write tf "/*-------------------------------------------------------*/"n' $write tf "#ifndef FRONTPORT_HIDE_DECC"s' $write tf "#define FRONTPORT_HIDE_DECC"r$ $write tf "#include ""frontport.h""" $write tf "#endif" $write tf "" $endif	 $close tf  $returni $!9 $! gosub to write out a documentation header for config.h B $!---------------------------------------------------------------- $write_config_h_header:  $outfile = "PRJ_SRC:CONFIG.H"	 $create 'outfile'  $open/append tf 'outfile'n $write tf "/* File: CONFIG.H"e $write tf "**" $write tf --H   "** This file contains the options needed for porting ''proj_name' to"8 $write tf "** the ''proj_name' project on a VMS system." $write tf "**"? $write tf "** Try not to make any edits to this file, as it is"T' $write tf "** automagically generated."r $write tf "**"D $write tf "** Manual edits should be made to the CONFIG_VMS.H file." $write tf "**" $write tf -!D  "** ", datetime, tab, username, tab, "Generated by ''my_proc_file'" $write tf "**" $write tf --O  "**========================================================================*/"  $write tf ""* $write tf " /* Allow compiler builtins */") $write tf "/*-------------------------*/"	 $write tf "#ifdef __DECC_VER"	! $write tf "#include <builtins.h>"e $write tf "#endif" $write tf "" $returnh $!8 $! gosub to write out the tail for config.h and close it; $!---------------------------------------------------------  $write_config_h_tail:	 $write tf ""7 $write tf " /* Include the hand customized settings */".6 $write tf "/*--------------------------------------*/"- $write tf "#include ""prj_src:config_vms.h"""y	 $close tft $returnd $!