 $! File: Configure_this.com  $!B $! This procedure attempts to make some sense out of the CONFIGURE0 $! information supplied with a GNU distribution. $!G $! This is and will continue to be a work in progress, and may not work 4 $! with projects that it has not been supplied with. $!F $! If the project name is not specified, the current default directory? $! is assumed to be the start of the work/build directory tree.  $!A $! The current default should not be a CMS library, and I plan to ! $! put in a check to insure that.  $!A $! The project name of the GNU package to be built needs to match A $! the name of the default directory this is run out of, but with # $! out any "-VMS" or "_VMS" suffix.  $!E $! A "-VMS" or "_VMS" specific suffix on the directory indicates that C $! there is no VMS support in the main package at this time so that H $! the VMS specific modifications will need to be maintained separately. $!D $! This procedure is also assuming that CMS (Code Management System)D $! may be in use to manage the source trees.  If this routine is notC $! being run from the current default directory it will assume that B $! the device and directory the procedure is being run from is the* $! CMS library and the CMS library device. $!H $! If this procedure is being run from the current default directory, itF $! will assume that the CMS library can be found from the logical nameI $! CMS_ROOT:.  I may need to change this in the future as it assumes that D $! one device can handle all of the CMS libraries.  For now mine can $! handle all I have.  $!H $! If there is a "-VMS" specific suffix on the current default directoryG $! then this procedure will expect that there should be two CMS library F $! trees, one for the "pristine" GNU source, and the other for the VMSL $! specific parts.  It will create any reference libraries that are missing. $! $! P1 - Project name $!D $! P2 - The location of GNU distribution sources.  If not specified,8 $!	and the CMS reference library is known and there is a9 $!	"-VMS" or "_VMS" suffix on the default directory, then = $!	a CMS library tree with out the suffix will be looked for. 3 $!	If that fails then the search will continue with 2 $!	USR:[SRC...'proj_name'*] will be tried and then: $!      LINUX_ROOT:[usr.src...'proj_name'*] will be tried. $!J $! P3 - The location of the base of the CMS library trees for this project/ $!	for when the CMS library can not be guessed.  $!H $! While this procedure will create the CMS directory tree structure, itJ $! will not populate it.  I have a different set of procedures in mind for $! that. $!$ $! 12-Jan-2001	J. Malmberg		OriginalG $! 11-Feb-2001	J. Malmberg	Fix to work with GNU source in a CMS library D $! 29-Apr-2001	J. Malmberg	Fix to work with projects like SAMBA that* $! 				have a special directory structure.M $!===========================================================================  $! $! some setups $!---------------  $ss_normal = 1 $ss_abort = 44 $status = ss_normal  $! $! Find out where we are.  $!------------------------8 $my_base_dir = f$edit(f$environment("DEFAULT"),"UPCASE") $!' $! Find out where we are being run from ( $!--------------------------------------6 $my_proc = f$edit(f$environment("PROCEDURE"),"UPCASE")E $my_proc_file = f$parse(my_proc,,,"NAME") + f$parse(my_proc,,,"TYPE")  $! $! $!' $! Find out if the CMS library is known > $!------------------------------------------------------------
 $cms_dev = "" 5 $tdev1 = f$parse(my_base_dir,,,"DEVICE","NO_CONCEAL") E $tdev2 = f$edit(f$parse(P3, my_proc,,"DEVICE","NO_CONCEAL"),"UPCASE") 8 $tdir1 = f$parse(my_base_dir,,,"DIRECTORY","NO_CONCEAL")H $tdir2 = f$edit(f$parse(P3, my_proc,,"DIRECTORY","NO_CONCEAL"),"UPCASE")1 $if (tdev1 .eqs. tdev2) .and. (tdir1 .eqs. tdir2)  $then  $!D $!   Either we are running out of the reference directory (very bad): $!   or we do not know enough where the CMS libraries are.< $!   we could try harder, such as look at CMS$LIB logical or8 $!   or we could guess that it should be in CMS_ROOT: by= $!   my personal convention.  Or we could look at a parameter  $!   from the input.F $!--------------------------------------------------------------------* $   if f$search("[...]0%CMS.CMS") .nes. "" $   then $	write sys$output -9 $	"Do not set your default to the CMS reference library!"  $	status = ss_abort  $	goto all_exit 	 $   endif  $!D $!  We could look at the CMS$LIB logical, but this could be not be a9 $!  good assumption, so we will not make any assumptions.  $else < $   cms_dev = f$edit(f$parse(P3,my_proc,,"DEVICE"),"UPCASE") $endif $!" $! Now figure out the project name" $!--------------------------------D $my_dir = f$parse(my_base_dir,,,"DIRECTORY") - "[" - "]" - "<" - ">" $prname = "" $i = 0
 $prname_loop: # $   xname = f$element(i,".",my_dir) D $   if xname .eqs. "" .or. xname .eqs. "." then goto prname_loop_end $   xname_len = f$length(xname)  $! $!  ODS-5 extended parsing $!----------------------------- 3 $   if f$extract(0, xname_len - 1, xname) .eqs. "^"  $   then $	i = i + 1 
 $	prname_loop 	 $   endif  $   prname = xname
 $   i = i + 1  $   goto prname_loop $prname_loop_end:  $if p1 .nes. ""  $then # $   proj_name = f$edit(p1,"UPCASE")  $else ' $   proj_name = f$edit(prname,"UPCASE")  $endif $!/ $!WRITE SYS$OUTPUT "Project name: ''proj_name'"  $! $! Find the GNU project  $!--------------------- ) $gproj_name = proj_name - "_VMS" - "-VMS" / $gbase_dir = f$parse(my_base_dir,,,"DIRECTORY") @ $gbase_dir = gbase_dir - "_VMS" - "-VMS" - "[" - "]" - "<" - ">"4 $!write sys$output "GNU Project name: ''gproj_name'"/ $!write sys$output "GNU base dir: ''gbase_dir'"  $!F $! If there is a "%VMS" variant of the project, look for an additional $! CMS library firstG $!---------------------------------------------------------------------  $gname = prname  $gproj_dir = gproj_name  $if xname .eqs. gproj_name $then  $   gproj_dir = "000000" $   gname = gproj_name $endif $cms_is_src = 0 
 $tdir = "" $if p2 .nes. ""  $then @ $   p2 = f$parse(p2,"[000000]''gproj_name'.dir",,,"SYNTAX_ONLY") $endif $if gproj_name .nes. proj_name $then  $   if cms_dev .nes. ""  $   thenJ $	tdir = f$search(f$parse(p2,"''cms_dev'[''gproj_dir'*...]''gname'*.DIR"))	 $   endif  $   if tdir .eqs. "" $   thenI $	tdir = f$search(f$parse(p2,"CMS_ROOT:[''gproj_dir'*...]''gname'*.dir")) 	 $   endif ( $   if tdir .nes. "" then cms_is_src = 1 $endif $if tdir .eqs. ""  $then A $   tdir = f$search(f$parse(P2,"USR:[SRC...]''gproj_name'*.dir"))  $   if tdir .eqs. "" $   thenJ $	tdir = f$search(f$parse(P2,"LINUX_ROOT:[usr.src...]''gproj_name'*.dir"))	 $   endif  $endif $if tdir .eqs. ""  $then K $   write sys$output "Unable to find GNU sources for project ''gproj_name'"  $   status = ss_abort  $   goto all_exit  $else   $   tdir = f$edit(tdir,"UPCASE") $endif $!# $!write sys$output "tdir = ''tdir'"  $!D $! Now VMSTAR does not currently handle imbedded dots in a directory@ $! as expected on an ODS-5 volume, we must fix things up for it.G $!---------------------------------------------------------------------   $gdev = f$parse(tdir,,,"DEVICE")# $gdir_name = f$parse(tdir,,,"NAME") ( $gdir_base = f$parse(tdir,,,"DIRECTORY") $!0 $! Also must get rid of phathom 000000 directory0 $!----------------------------------------------& $gdx1 = f$locate("[000000", gdir_base)& $gdx2 = f$locate("<000000", gdir_base)$ $if (gdx1 .eq. 0) .or. (gdx2 .eq. 0) $then $ $   gdir_base = gdir_base - "000000" $endifI $if f$extract(1, 1, gdir_base) .eqs. "." then gdir_base = gdir_base - "."  $! $len = f$length(gdir_base)( $dlim = f$extract(len - 1, 1, gdir_base)) $gdir_path = gdev + gdir_base - "]" - ">"  $!show sym gdir_path3 $if (gdir_base .ne. "[") .and. (gdir_base .ne. "<")  $then  $   gdir_path = gdir_path + "."  $endif $!show sym gdir_path) $gdir_path = gdev + gdir_base - "]" - ">"  $if f$length(gdir_base) .gt. 2 $then  $   gdir_path = gdir_path + "."  $endif" $gdir_path = gdir_path + gdir_name $!show sym gdir_path $!G $! We look to skip the directories that only contain a single directory H $!---------------------------------------------------------------------- $x_path = gdir_path  $gdir_loop1: $   fcnt = 0 $   xfile = "" $gdir_loop2:+ $	tfile = f$search("''x_path'''dlim'*.*",1) , $	if tfile .eqs. "" then goto gdir_loop2_end $	fcnt = fcnt + 1  $	xfile = tfile % $	if fcnt .le. 3 then goto gdir_loop2  $gdir_loop2_end:+ $   if fcnt .ne. 1 then goto gdir_loop1_end & $   new_path = f$parse(xfile,,,"NAME") $   if new_path .nes. "" $   then" $	x_path = x_path + "." + new_path $	goto gdir_loop1 	 $   endif  $gdir_loop1_end: $gdir_path = x_path  $!. $!write sys$output "GNU Path is: ''gdir_path'" $!C $! Is CMS present?  Use only if we are going to setup CMS libraries A $! Then we need some way of specifying a comment.  If we can find B $! a consistant file to read from the GNU sources, that would helpC $!-----------------------------------------------------------------  $!$cms_present = 0$ $!$if f$search("SYS$SYSTEM:CMS.EXE") $!$then  $!$!L $!$!  The executable is present, but it may not be licensed or other problemM $!$!-------------------------------------------------------------------------  $!$   set noon  $!$   define/user sys$output nl: $!$   define/user sys$error nl:  $!$   cms show version: $!$   if ('$severity' .and. 7) .eq. 1 then cms_present = 1 $!$endif $! $!  $! Now build the directory trees" $!--------------------------------" $my_base_path = my_base_dir - dlim $if cms_dev .nes. "" $then @ $   cms_dir = f$edit(f$parse(P3, my_proc,,"DIRECTORY"),"UPCASE"). $   xcms_dir = cms_dir - "[" - "]" - "<" - ">"' $   cms_path = cms_dev + cms_dir - dlim 5 $   if xcms_dir .eqs. "" .or. xcms_dir .eqs. "000000"  $   then $	if gdir_name .nes. ""  $	then+ $	    cms_path = cms_path + "." + gdir_name % $	    cms_path = cms_path - "000000."  $	endif 	 $   endif  $   cms_is_src = 0 $endif $!show sym cms_path  $!goto all_exit  $build_dir_loop:. $   ndir = f$search("''gdir_path'...]*.dir",1)1 $   if ndir .eqs. "" then goto build_dir_loop_end   $   ndir = f$edit(ndir,"UPCASE") $! $!  Exclude CMS libraries  $!------------------------I $   if f$locate("CMS$",ndir) .lt. f$length(ndir) then goto build_dir_loopuI $   if f$locate("CVS.",ndir) .lt. f$length(ndir) then goto build_dir_loop! $!
 $   fflag = 0o# $   tnfile = f$parse(ndir,,,"NAME")m. $   tndir = f$parse(ndir,,,"DIRECTORY") - dlim/ $   tnpath = gdev + tndir + "." + tnfile + dlim  $!' $!  Exclude the CMS library directories ' $!-------------------------------------/F $   if f$search("''tnpath'*cms.cms") .nes. "" then goto build_dir_loop $!I $!  Only create directories that .C and .H files are in (Add more later?)nK $!-------------------------------------------------------------------------t7 $   if f$search("''tnpath'*.h") .nes. "" then fflag = 1S7 $   if f$search("''tnpath'*.c") .nes. "" then fflag = 1s $!5 $!  Look also for makefiles and input files to configs5 $!---------------------------------------------------e> $   if f$search("''tnpath'makefile.*") .nes. "" then fflag = 1: $   if f$search("''tnpath'*.*_in") .nes. "" then fflag = 1: $   if f$search("''tnpath'*.*.in") .nes. "" then fflag = 18 $   if f$search("''tnpath'*.in") .nes. "" then fflag = 1 $! $! $   if fflag .eq. 1u $   then $!- $!	First create in the default directory treer3 $!-------------------------------------------------v& $	ndir_path = gdev + tndir - gdir_path% $	nx_path = ndir_path + dlim + tnfile 7 $	if f$search("''my_base_path'''nx_path'.dir") .eqs. ""  $	then9 $	    create/dir 'my_base_path''ndir_path'.'tnfile''dlim'uL $!write sys$output "Create/dir ''my_base_path'''ndir_path'.''tnfile'''dlim'" $	endifi $!C $!	Then if the CMS reference library is known, create a tree for itiI $!-----------------------------------------------------------------------  $	if cms_dev .nes. ""  $	then7 $	    if f$search("''cms_path'''nx_path'.dir") .eqs. ""h
 $	    then2 $		create/dir 'cms_path''ndir_path'.'tnfile''dlim'H $!write sys$output "Create/dir ''cms_path'''ndir_path'.''tnfile'''dlim'" $	    endif  $!D $!	    I plan to use another procedure to do the initial CMS libraryC $!	    create and initial element insertion.  It might end up here.iJ $!------------------------------------------------------------------------ $	endif  $!	 $   endif  $   goto build_dir_loopw $build_dir_loop_end:( $!write sys$output "CMS_DEV: ''cms_dev'" $! $!goto all_exit. $!6 $! Some symbols to make building a command file easier7 $!-----------------------------------------------------r
 $tic = "'" $t2 = tic + tic  $t3 = t2 + tic
 $tab[0,8] = 9  $!' $! Now build the command procedure thats< $! will set the logical names needed for the build procedure> $!------------------------------------------------------------) $outfile = "setup_''proj_name'_build.com"F $if f$search(outfile) .nes. "" $thenrA $   write sys$output "''outfile' already exists, will not modify"B $   goto build_file_done $endif! $on error then goto general_error= $open/write tf 'outfile' $write tf "$! File: ''outfile'"  $write tf "$!" $write tf --I   "$! This file sets up logical name search lists that are used to build"n8 $write tf "$! the ''proj_name' project on a VMS system." $write tf "$!"= $datetime = f$element(0,".",f$cvtime(,"ABSOLUTE","DATETIME"))b2 $username = f$edit(f$getjpi("","USERNAME"),"TRIM") $write tf -cD  "$! ", datetime, tab, username, tab, "Generated by ''my_proc_file'" $write tf "$!" $write tf -(M  "$!========================================================================"- $write tf "$!" $write tf "$!"> $write tf "$! First find out what type of CPU model we are on"> $write tf "$!------------------------------------------------". $write tf "$hw_model = f$getsyi(""HW_MODEL"")"" $write tf "$if hw_model .ge. 1000" $write tf "$then"i $write tf "$   arch = ""AXP"""% $write tf "$   __ALPHA__ == ""TRUE"""i $write tf "$else"2 $write tf "$   arch = ""VAX"""# $write tf "$   __VAX__ == ""TRUE"""o $write tf "$endif" $write tf "$!" $write tf "$!"5 $write tf "$procedure = f$environment(""PROCEDURE"")"w5 $write tf "$device = f$parse(procedure,,,""DEVICE"")" 8 $write tf "$direct = f$parse(procedure,,,""DIRECTORY"")" $write tf "$!"4 $write tf "$my_default = f$environment(""DEFAULT"")"6 $write tf "$my_dev = f$parse(my_default,,,""DEVICE"")"9 $write tf "$my_dir = f$parse(my_default,,,""DIRECTORY"")".) $write tf "$source_dir = my_dev + my_dir"t2 $write tf "$source_dir_len = f$length(source_dir)"> $write tf "$dl = f$extract(source_dir_len - 1, 1, source_dir)"> $write tf "$src = f$extract(0, source_dir_len -1, source_dir)" $write tf "$!" $write tf "$!"@ $write tf "$! This is the base path to the original GNU sources"@ $write tf "$!--------------------------------------------------"$ $write tf "$gsrc = ""''gdir_path'""" $write tf "$!"0 $if (cms_dev .nes. "") .and. (cms_is_src .eq. 0) $then- $write tf "$!"G $write tf "$! This is the base path to the CMS library for the sources"rG $write tf "$!---------------------------------------------------------" $ $write tf "$cms_p = ""''cms_path'""" $write tf "$!" $endif $write tf "$!"- $write tf "$! Logical names to build against"_- $write tf "$!-------------------------------- , $write tf "$define/job lcl_src 'source_dir'"* $!write sys$output "cms path: ''cms_path'" $line =  "$define/job ref_src ""0 $if (cms_dev .nes. "") .and. (cms_is_src .eq. 0) $then 1 $   line = line + tic + "cms_p" + t2 + "dl" + tic! $endif6 $   line = line + "," + tic + "gsrc" + t2 + "dl" + tic $write tf line0 $line =  "$define/job prj_src lcl_src:,ref_src:" $write tf line $write tf "$!"A $write tf "$! Now loop through the work directories and set up a"V+ $write tf "$! a search path for the build." F $write tf "$!--------------------------------------------------------" $write tf "$dir_loop1:"!O $write tf "$   dpath = f$search(""",t2,"src",tic,"...",t2,"dl",tic,"*.dir"",1)"l; $write tf "$   if dpath .eqs. """" then goto dir_loop1_end"-/ $write tf "$   dfn = f$parse(dpath,,,""NAME"")"j; $write tf "$   tdpath = f$parse(dpath,,,""DIRECTORY"") - dlp9 $write tf "$   ndir_path = device + tdpath - src - ""."""_' $write tf "$   if ndir_path .nes. """""t $write tf "$   then" $write tf "$''tab'i = 0" $write tf "$''tab'tn = """"" $write tf "$dir_loop2:"o9 $write tf "$''tab'    tn1 = f$element(i,""."",ndir_path)"= $write tf -aK  "$''tab'    if tn1 .eqs. """" .or. tn1 .eqs. ""."" then goto dir_loop2_end   $write tf "$''tab'    i = i + 1", $write tf "$''tab'    tn = tn + ""_"" + tn1"% $write tf "$''tab'    goto dir_loop2"  $write tf "$dir_loop2_end:" ( $write tf "$''tab'df = tn + ""_"" + dfn"= $write tf "$''tab'df2 = ""."" + ndir_path + ""."" + dfn + dl"  $write tf "$   else"# $write tf "$''tab'df = ""_"" + dfn"") $write tf "$''tab'df2 = ""."" + dfn + dl") $write tf "$   endif"iD $write tf "$   define/job lcl'df' " + tic + "src" + t2 + "df2" + tic" $line =  "$   define/job ref'df' "0 $if (cms_dev .nes. "") .and. (cms_is_src .eq. 0) $thenr2 $   line = line + tic + "cms_p" + t2 + "df2" + tic $endif7 $   line = line + "," + tic + "gsrc" + t2 + "df2" + ticl $write tf line3 $line =  "$   define/job prj'df' lcl'df':,ref'df':"  $write tf line $write tf "$   goto dir_loop1" $write tf "$dir_loop1_end:"-
 $write tf "$!- $write tf "$all_exit:" $write tf "$exit"g $!
 $outfile_err:t	 $close tf" $! $build_file_done:e $!
 $! Run it! $!------------. $if f$search(outfile) .nes. "" then @'outfile' $!: $! Now attempt to create the *.MMS file, the config.h file: $! and any file that would contain the version information= $!----------------------------------------------------------- > $file = f$search(f$parse("RECONFIGURE_VMS.COM;0",my_base_dir)) $if file .eqs. ""s $thenrB $   file = f$search(f$parse("RECONFIGURE_VMS.COM;0", P3, my_proc)) $endif $if file .nes. "" then @'file' $! $! $! $general_error:w $  status = '$status'i
 $all_exit: $   set noonH $   if f$trnlnm("tf","lnm$process",,"SUPERVISOR") .nes. "" then close tf $   exit 'status'g