 /* File: VMS_GETPASS.C **) ** This implements the getpass() routine. ' ** Borrowed from the Frontport project.  ** ** 19-Mar-1999	J. Malmberg? ** 10-Jun-2001	J. Malmberg	Fixed non-fatal compiler diagnostics  **O ******************************************************************************/ N /*============================================================================ **8 ** Copyright 2000, John E. Malmberg, All Rights Reserved **I **   This program is free software; you can redistribute it and/or modify I **   it under the terms of the GNU General Public License as published by F **   the Free Software Foundation; either version 2 of the License, or( **   (at your option) any later version. **D **   This program is distributed in the hope that it will be useful,C **   but WITHOUT ANY WARRANTY; without even the implied warranty of B **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the1 **   GNU General Public License for more details.  **F **   You should have received a copy of the GNU General Public License@ **   along with this program; if not, write to the Free Software> **   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. **N ============================================================================*/  4  /* Make sure the prototype matches the real code */3 /*-----------------------------------------------*/  #include <iodef.h> #include <ssdef.h> #include <descrip.h> #include <string.h>  #include <unistd.h>  #include <unixio.h>    unsigned long sys$assign/        (const struct dsc$descriptor_s * devnam,  	unsigned short * chan,  	unsigned long acmode,( 	const struct dsc$descriptor_s * mbxnam, 	unsigned long flags);     unsigned long sys$qiow        (unsigned long efn,; 	unsigned short chan,	/* This is right, 7.0 doc is wrong */  	unsigned long func,
 	void * iosb,   	void (* astadr)(unsigned long), 	...);    /* For terminal input */  /*--------------------*/- static unsigned short VMS__termchan = 0xffff;     *  /* Return a channel for Standard Input */) /*=====================================*/ # unsigned short VMS_stdin_chan(void)  {  unsigned short chan; unsigned long call_stat;       chan = 0xffff;      if (VMS__termchan == 0xffff)     {      char termname[256];      char * retname; &     struct dsc$descriptor_s term_desc;   	if (isatty(STDIN_FILENO)) 	{2 	    retname = getname(STDIN_FILENO, termname, 1); 	    if (retname != NULL)  	    {% 		term_desc.dsc$a_pointer = termname; , 		term_desc.dsc$w_length = strlen(termname);( 		term_desc.dsc$b_dtype = DSC$K_DTYPE_T;( 		term_desc.dsc$b_class = DSC$K_CLASS_S;   		call_stat = sys$assign) 			(&term_desc, &VMS__termchan, 0, 0, 0);   - 		if ((call_stat & SS$_NORMAL) == SS$_NORMAL)  		    chan = VMS__termchan;  	    } 	}     }      else     {  	chan = VMS__termchan;     }      return chan; }     &  /* Get the password from sys$input */% /*=================================*/   /* VMS allows 39 characters */ *  /* Windows NT 4.0 allows 14 characters */! static char VMS__newpassword[40];   ' char * VMS_getpass(const char * prompt)  {  unsigned long call_stat; int tty; unsigned long funct;	 int plen; 
 int pwlen; unsigned short iosb[4];  unsigned short channel;        VMS__newpassword[0] = '\0';      tty = isatty(STDIN_FILENO);   4      /* This is only meaningfull for TTY sessions */3     /*-------------------------------------------*/      if (tty)     { $ 	 /* Look up the existing channel */# 	/*------------------------------*/  	channel = VMS_stdin_chan();    	 /* Need a leading line feed */ 	/*--------------------------*/  	putchar('\n');   % 	 /* Read the password with prompt */ $ 	/*-------------------------------*/ 	plen = strlen(prompt); & 	pwlen = sizeof(VMS__newpassword) - 1;3 	funct = IO$_READPROMPT | IO$M_NOECHO | IO$M_PURGE;  	call_stat = sys$qiow  		       (0, 			channel, 	 			funct,  			iosb, 			0,  			0,  			VMS__newpassword,	 			pwlen,  			0,  			0, 
 			prompt,	 			plen);    	 /* Check the result */ 	/*------------------*/ , 	if ((call_stat & SS$_NORMAL) == SS$_NORMAL) 	{. 	    if ((iosb[0] & SS$_NORMAL) == SS$_NORMAL) 	    {* 		 /* Null terminate the given password */) 		/*-----------------------------------*/ # 		VMS__newpassword[iosb[1]] = '\0';  	    }	 	    else  		VMS__newpassword[0] = '\0';  	} 	else   	    VMS__newpassword[0] = '\0';  , 	 /* Fake the echo of the carriage return */+ 	/*--------------------------------------*/  	putchar('\r');      }      return(VMS__newpassword);    } 