& /* FILE: vms_open_socket_out_wrapped.c **? ** This routine replaces the open_socket_out_wrapped routine in  ** socket.c. **C ** It really only needs to replace the sock_exec() routine, but the E ** sock_exec routine is referenced internally to the socket.c module, . ** and thus can not be externally substituted. **8 ** The static socketpair_tcp must also be brought along. **B ** The open_socket_out_wrapped routine is only called by a routineG ** in the clientserver.c module.  Thus a macro can redefine it to point / ** to the OpenVMS specific replacement routine.  **- ** 16-Feb-2002	J. Malmberg	OpenVMS conversion  **M ****************************************************************************/   /* -*- c-file-style: "linux" -*-  )    rsync -- fast file replication program   @    Copyright (C) 1992-2001 by Andrew Tridgell <tridge@samba.org>:    Copyright (C) 2001, 2002 by Martin Pool <mbp@samba.org><    OpenVMS specific portions copyright 2002 by John Malmberg 	<wb8tyw@qsl.net>   G    This program is free software; you can redistribute it and/or modify G    it under the terms of the GNU General Public License as published by D    the Free Software Foundation; either version 2 of the License, or&    (at your option) any later version.  B    This program is distributed in the hope that it will be useful,A    but WITHOUT ANY WARRANTY; without even the implied warranty of @    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the/    GNU General Public License for more details.   D    You should have received a copy of the GNU General Public License>    along with this program; if not, write to the Free Software<    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */   #include "rsync.h"   #ifndef _FRONTPORT_H #include <descrip.h> #endif #include <clidef.h>  #include <stsdef.h>  #include <ssdef.h> #include <jpidef.h>  #include <libclidef.h>    /* From TCPIP$INETDEF.H */  /*----------------------*/ #ifndef TCPIP$C_AUXS #define TCPIP$C_AUXS 127 #endif   struct item_list_3 {    unsigned short buffer_len;     unsigned short item_code;    void * buffer_addr;    unsigned short * ret_len;    };    int SYS$GETJPIW     (unsigned int efn,      unsigned long * process_id, 1     const struct dsc$descriptor_s * process_name, )     const struct item_list_3 * item_list,      unsigned long * iosb, #     void (* astadr)(unsigned long),       unsigned long ast_argument);   int LIB$GET_SYMBOL+    (const struct dsc$descriptor_s * symbol, )     struct dsc$descriptor_s * result_str,       unsigned short * result_len,     long * table_type);    int LIB$SET_SYMBOL+    (const struct dsc$descriptor_s * symbol, .     const struct dsc$descriptor_s * value_str,     const long * table_type);     ( int LIB$SIGNAL(unsigned long call_stat);  
 int LIB$SPAWN 0    (const struct dsc$descriptor_s * command_str,/     const struct dsc$descriptor_s * input_file, 0     const struct dsc$descriptor_s * output_file,      const unsigned long * flags,1     const struct dsc$descriptor_s * process_name,      unsigned long * process_id, *     const void * * completion_status_addr,%     const unsigned char * event_flag, #     void (* astadr)(unsigned long),      unsigned long ast_argument, /     const struct dsc$descriptor_s * prompt_str, .     const struct dsc$descriptor_s * cli_shell,/     const struct dsc$descriptor_s * cli_table);    /** J  * Open a socket of the specified type, port and address for incoming data  *E  * Try to be better about handling the results of getaddrinfo(): when C  * opening an inbound socket, we might get several address results, -  * e.g. for the machine's ipv4 and ipv6 name.   *H  * If binding a wildcard, then any one of them should do.  If an addressE  * was specified but it's insufficiently specific then that's not our 	  * fault.   *I  * However, some of the advertized addresses may not work because e.g. we I  * don't have IPv6 support in the kernel.  In that case go on and try all    * addresses until one succeeds.  *D  * @param bind_address Local address to bind, or NULL to allow it to  * default.   **/K static int vms_open_socket_in(int type, int port, const char *bind_address,  			  int af_hint)  {  	int one=1;  	int s; ' 	struct addrinfo hints, *all_ai, *resp;  	char portbuf[10]; 	int error;   " 	memset(&hints, 0, sizeof(hints)); 	hints.ai_family = af_hint;  	hints.ai_socktype = type; 	hints.ai_flags = AI_PASSIVE; 0 	snprintf(portbuf, sizeof(portbuf), "%d", port);= 	error = getaddrinfo(bind_address, portbuf, &hints, &all_ai); 
 	if (error) { D 		rprintf(FERROR, RSYNC_NAME ": getaddrinfo: bind address %s: %s\n",& 			bind_address, gai_strerror(error)); 		return -1; 	}  ? 	/* We may not be able to create the socket, if for example the = 	 * machine knows about IPv6 in the C library, but not in the  	 * kernel. */2 	for (resp = all_ai; resp; resp = resp->ai_next) {0 		s = socket(resp->ai_family, resp->ai_socktype, 			   resp->ai_protocol);    		if (s == -1)9 			/* See if there's another address that will work... */  			continue;  ) 		setsockopt(s, SOL_SOCKET, SO_REUSEADDR,   			   (char *)&one, sizeof one);  3 		/* now we've got a socket - we need to bind it */ 9 		if (bind(s, all_ai->ai_addr, all_ai->ai_addrlen) < 0) {  			/* Nope, try another */ 			close(s); 			continue; 		}    		freeaddrinfo(all_ai);  		return s;  	}  G 	rprintf(FERROR, RSYNC_NAME ": open inbound socket on port %d failed: " 	 		"%s\n",  		port,  		strerror(errno));    	freeaddrinfo(all_ai); 	return -1;  }      /*D  * This rouine is used to return true if standard input is a socket.  *'  * With OpenVMS, this must be replaced.   *A  * If this process has been launched by the auxilliary server, or 9  * is a child server process, than this must return true.   *D  * It must also close the specified channel and open a socket on it.  *  */  int vms_is_a_socket(int sd)  {  int call_stat; int vms_server_fd;! const long mode_item = JPI$_MODE;   struct item_list_3 jpi_items[3]; unsigned long pid; unsigned long master_pid;  unsigned short master_pid_len; unsigned long mode;  unsigned short mode_len; extern int rsync_port;  6      /* This is only to be called with STDIN_FILENO */5     /*---------------------------------------------*/      if (sd != STDIN_FILENO)      {  	rprintf 	   (FINFO, E 	    "Sanity error, vms_is_a_socket not testing STDIN_FILENO = %d\n", 	 	    sd); 
 	return 0;     }   H       /* Now as far as C is concerned, STDIN_FILENO is never a socket */5      /*  So alternate methods must be used.			     */ F     /*--------------------------------------------------------------*/  B      /* First test is to see what type of process that this is. */A     /*---------------------------------------------------------*/ 0     jpi_items[0].buffer_len = sizeof master_pid;-     jpi_items[0].item_code = JPI$_MASTER_PID; +     jpi_items[0].buffer_addr = &master_pid; +     jpi_items[0].ret_len = &master_pid_len;   *     jpi_items[1].buffer_len = sizeof mode;'     jpi_items[1].item_code = JPI$_MODE; %     jpi_items[1].buffer_addr = &mode; %     jpi_items[1].ret_len = &mode_len;         jpi_items[2].buffer_len = 0;     jpi_items[2].item_code = 0;        pid = 0;E     call_stat = SYS$GETJPIW(0, &pid, NULL, jpi_items, NULL, NULL, 0);   (     if (!$VMS_STATUS_SUCCESS(call_stat))     {  	rprintf 	   (FINFO, 5 	    "vms_is_a_socket - SYS$GETJPI VMS error = %x\n",  	    call_stat);
 	return 0;     }   <     if((mode == JPI$K_BATCH) || (mode == JPI$K_INTERACTIVE))     {      int captive;  < 	  /* If this is an interactive process, then we need to	 */2 	 /*  see if this is a captive server process.		*/: 	/*-----------------------------------------------------*/
 	captive = 0;  	if (master_pid != pid)  	{ 	struct sockaddr_in sock;  	socklen_t socklen;  	unsigned short value_len; 	int call_stat;  	long table_type; # 	struct dsc$descriptor_s value_dsc; 0 	$DESCRIPTOR(symbol_dsc,"RSYNC__CLIENT_SOCKET");  - 	    value_dsc.dsc$a_pointer = (char *)&sock; 6 	    value_dsc.dsc$w_length = sizeof(struct sockaddr);+ 	    value_dsc.dsc$b_dtype = DSC$K_DTYPE_T; + 	    value_dsc.dsc$b_class = DSC$K_CLASS_S;   $ 	    memset(&sock, 0, sizeof(sock)); 	    call_stat = LIB$GET_SYMBOL 5 		(&symbol_dsc, &value_dsc, &value_len, &table_type); ( 	    if ($VMS_STATUS_SUCCESS(call_stat)) 	    {  ) 		 /* This is a captive server process */ ( 		/*----------------------------------*/ 		socklen = value_len; 		captive = 1; 		close(STDIN_FILENO);2 		vms_server_fd = socket(PF_INET, SOCK_STREAM, 0); 		if (vms_server_fd >= 0)  		{ % 		    set_nonblocking(vms_server_fd); 4 		    sock.sin_addr.s_addr = htonl(INADDR_LOOPBACK);   		    captive = 1; #if 0  		    call_stat = bind 			       (vms_server_fd,  				(struct sockaddr *)&sock, 
 				socklen);  		    if (call_stat == -1) 		    { 
 			rprintf
 			   (FINFO, 7 			    "vms_is_a_socket bind to loopback failed 0.\n");  			close(vms_server_fd); 			return 0; 		    }  #endif 		    call_stat = connect ; 			(vms_server_fd, (struct sockaddr *)&sock, sizeof(sock));  		}  		if (call_stat == -1) 		{ 
 		    rprintf  		       (FINFO,* 			"vms_is_a_socket connect failed 0.\n"); 		    close(vms_server_fd);  		    return 0;  		}  	    } 	}    < 	  /* In the case of no CLI being present or interactive  */ 	 /*  run as a daemon					*/: 	/*-----------------------------------------------------*/ 	if (captive == 0) 	{ 	extern char *bind_address;  	extern int default_af_hint;  6 	     /* This is the daemon being run interactively */5 	    /*--------------------------------------------*/  	    close(STDIN_FILENO); ' 	    vms_server_fd = vms_open_socket_in ; 		(SOCK_STREAM, rsync_port, bind_address, default_af_hint);  	}       }      else     { 7 	  /* If this is a network or other type process	    */ 6 	 /*  Then assume this is from the auxiliary server */5 	/*------------------------------------------------*/  	close(STDIN_FILENO); , 	vms_server_fd = socket(TCPIP$C_AUXS, 0, 0);     }   .      /* This should not happen, so complain */-     /*-------------------------------------*/ &     if (vms_server_fd != STDIN_FILENO)     {  	rprintf 	   (FINFO, = 	    "vms_is_a_socket socket number is = %d, should be 0.\n",t 	    vms_server_fd); 	close(vms_server_fd);
 	return 0;     }.  
     return 1;y }l   #if 0oD /*******************************************************************> this was like socketpair but uses tcp. It is used by the Samba regression test codeA The unix version of this function guarantees that nobody else can.@ attach to the socket, or if they do that this function fails and: the socket gets closed returns 0 on success, -1 on failure. the resulting file descriptors are symmetrical  A On OpenVMS, the sockets are not inherited by the child processes,s) so just start creating the parent socket.*  ? The when running a captive server process like this, the client"> actually is the server, and the captive server is it's client.D  ******************************************************************/C static int vms_open_client_tcp(int * fd, struct sockaddr_in *sock2)i {o struct sockaddr_in sock;! socklen_t socklen = sizeof(sock);  int ret_status;s int status;e  
     *fd = -1;i     ret_status = -1;  #     memset(&sock, 0, sizeof(sock));r        /* Create the socket */     /*-------------------*/d*     *fd = socket(PF_INET, SOCK_STREAM, 0);        /* Bind the socket */     /*-----------------*/      if (*fd >= 0)h     {t  4        memset(&sock, 0, sizeof(struct sockaddr_in)); #ifdef HAVE_SOCK_SIN_LEN2         sock.sin_len = sizeof(struct sockaddr_in); #endif"         sock.sin_family = PF_INET;           ret_status = bind A 	    (*fd, (struct sockaddr *)&sock, sizeof(struct sockaddr_in));n       }o  '      /* Set the socket for listening */F&     /*------------------------------*/     if (ret_status >= 0)     {. 	ret_status = listen(*fd, 1);i     }F  4      /* Get the socket name that was just created */3     /*-------------------------------------------*/c     if (ret_status == 0)     {iC 	ret_status = getsockname(*fd, (struct sockaddr *)&sock, &socklen);i  0 	 /* Pass the socket name to the child server *// 	/*------------------------------------------*/r 	if (ret_status == 0)r 	{ 	int call_stat; - 	const long table_type = LIB$K_CLI_LOCAL_SYM; # 	struct dsc$descriptor_s value_dsc;d0 	$DESCRIPTOR(symbol_dsc,"RSYNC__CLIENT_SOCKET");  - 	    value_dsc.dsc$a_pointer = (char *)&sock; 6 	    value_dsc.dsc$w_length = sizeof(struct sockaddr);+ 	    value_dsc.dsc$b_dtype = DSC$K_DTYPE_T;n+ 	    value_dsc.dsc$b_class = DSC$K_CLASS_S;   F 	    call_stat = LIB$SET_SYMBOL(&symbol_dsc, &value_dsc, &table_type);  ) 	    if (!$VMS_STATUS_SUCCESS(call_stat))s 	    { 		ret_status = -1; 	    } 	}       }n        /* Error Cleanup */     /*---------------*/      if (ret_status != 0)     {s 	if (*fd != -1)_ 	    close(*fd);     }b     return ret_status;  
 #ifndef __VMSoB 	if ((fd[1] = socket(PF_INET, SOCK_STREAM, 0)) == -1) goto failed;   	set_nonblocking(fd[1]);  / 	sock.sin_addr.s_addr = htonl(INADDR_LOOPBACK);u  B 	if (connect(fd[1],(struct sockaddr *)&sock,sizeof(sock)) == -1) {( 		if (errno != EINPROGRESS) goto failed;	 	} else {  		connect_done = 1;c 	}W 	if ((fd[0] = accept(listener, (struct sockaddr *)&sock, &socklen)) == -1) goto failed;    	close(listener);n 	if (connect_done == 0) {d? 		if (connect(fd[1],(struct sockaddr *)&sock,sizeof(sock)) != 0s' 		    && errno != EISCONN) goto failed;  	}   	set_blocking (fd[1]); #endif   }_ #endif   #if 0  /** C  * Run a program on a local tcp socket, so that we can talk to it'snC  * stdin and stdout.  This is used to fake a connection to a daemoni9  * for testing -- not for the normal case of running SSH.v  *=  * @return a socket which is attached to a subprocess runningeD  * "prog". stdin and stdout are attached. stderr is left attached to  * the original stderr  **/# int vms_sock_exec(const char *prog)t {' int call_stat; int fd;* unsigned long flags; unsigned long pid;  struct dsc$descriptor_s cmd_dsc;  struct item_list_3 dvi_items[2]; struct sockaddr_in sock;! socklen_t socklen = sizeof(sock);l    7      /* Get a client socket for the local connection */i6     /*----------------------------------------------*/0     call_stat = vms_open_client_tcp(&fd, &sock);     if (call_stat != 0)i     {i 	rprintfI 	 (FERROR, RSYNC_NAME ": socketpair_tcp failed (%s)\n", strerror(errno));t 	return -1;t     }   @      /* Now get look up the device name from the fd[1] device */?     /*-------------------------------------------------------*/p     if (verbose > 3)     {)H 	fprintf (stderr, RSYNC_NAME ": execute socket program \"%s\"\n", prog);     }i  9      /* Build up the string descriptor for the command */n8     /*------------------------------------------------*/)     cmd_dsc.dsc$a_pointer = (char *)prog;b(     cmd_dsc.dsc$w_length = strlen(prog);(     cmd_dsc.dsc$b_dtype = DSC$K_DTYPE_T;(     cmd_dsc.dsc$b_class = DSC$K_CLASS_S;    '      /* Now spawn the private server */x&     /*------------------------------*/     flags = CLI$M_NOWAIT;>     pid = 0;       call_stat = LIB$SPAWN  	       (&cmd_dsc, 		NULL,a 		NULL,r	 		&flags,	 		NULL,; 		&pid,s 		NULL,  		NULL,T 		NULL,E 		0, 		NULL,c 		NULL,e 		NULL);  (     if (!$VMS_STATUS_SUCCESS(call_stat))     {nE 	fprintf (stderr, RSYNC_NAME ": LIB$SPAWN failed - %x\n", call_stat);	 	return -1;      }        /* temporary */n     LIB$SIGNAL(SS$_DEBUG);  @       /* Give the server 5 seconds to get it's sockets set up */?      /*  Future: replace this with an interlock function     */t>     /*------------------------------------------------------*/
     sleep(5);o           /* Connect to the server */     /*-----------------------*/ 2     sock.sin_addr.s_addr = htonl(INADDR_LOOPBACK);?     call_stat = accept(fd, (struct sockaddr *)&sock, &socklen);l         return call_stat;  }t #endif   #if 0*   /** A  * Open an outgoing socket, but allow for it to be intercepted by A  * $RSYNC_CONNECT_PROG, which will execute a program across a TCPv2  * socketpair rather than really opening a socket.  *D  * We use this primarily in testing to detect TCP flow bugs, but not@  * cause security problems by really opening remote connections.  *2  * This is based on the Samba LIBSMB_PROG feature.  *F  * @param bind_address Local address to use.  Normally NULL to get the  * stack default.   **/, int vms_open_socket_out_wrapped (char *host, 			     int port,i! 			     const char *bind_address,n 			     int af_hint) {  	char *prog;  4 	if ((prog = getenv ("RSYNC_CONNECT_PROG")) != NULL) 		return vms_sock_exec (prog); 	else 3 		return open_socket_out (host, port, bind_address,  					af_hint);   }- #endif