/* pdp11_dn.c: PDP-11 DN-11 simulator

   Copyright (c) 1993-2005, Robert M Supnik

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   ROBERT M SUPNIK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

   Except as contained in this notice, the name of Robert M Supnik shall not be
   used in advertising or otherwise to promote the sale, use or other dealings
   in this Software without prior written authorization from Robert M Supnik.

    dn         DN11 

*/

#if defined (VM_PDP10)                                  /* PDP10 version */
#error "DN11 is not supported on the PDP-10!"

#elif defined (VM_VAX)                                  /* VAX version */
#include ".\VAX\vax_defs.h"

#else                                                   /* PDP-11 version */
#include "pdp11_defs.h"
#endif
#define FCRQ         1				       /* Call Request */
#define FDPR         2				       /* Digit Present */
#define MINAB        4				       /* Master Enable */
#define MAINT      010				       /* Maintenace loopback*/
#define FPND       011				       /* Present Next Digit */
#define DSS        012				       /* Data Set Status */
/* CSR_IE	   014				       /* Interrupt enable */
/* CSR_DONE        020                                 /* Done */
#define NB	  0740				       /* Digits */
#define FDLO     01000				       /* Data Line Occupied */
/* unused	 02000				       /* unused */
#define ACR	 04000				       /* abandon call */
/*      CSR_ERR  10000				       /* Power in */
#define DNCSR_W        (CSR_IE | FCRQ | FDPR | MINAB | MAINT | NB)    /*write */
#define DNCSR_R        (CSR_ERR | ACR | FDLO | DSS | NB | CSR_DONE | CSR_IE | DSS | FPND | MAINT | MINAB | FDPR)

extern int32 int_req[IPL_HLVL];
extern int32 SleepCountMaster;
extern uint32 NOQUEUE_WAIT;
int32 dn_csr = 0;                                      /* control/status */
int32 dn_stopioe = 0;                                  /* stop on error */

DEVICE dn_dev;
t_stat dn_rd (int32 *data, int32 PA, int32 access);
t_stat dn_wr (int32 data, int32 PA, int32 access);

t_stat dn_reset (DEVICE *dptr);
// t_stat dn_attach (UNIT *uptr, char *ptr);
// t_stat dn_detach (UNIT *uptr);

/* dn data structures

   dn_dev      dn device descriptor
   dn_unit     dn unit descriptor
   dn_reg      dn register list
*/

DIB dn_dib = {
    IOBA_DN, IOLN_DN, &dn_rd, &dn_wr,
    1, IVCL (DN), VEC_DN, { NULL }
    };

UNIT dn_unit = {
    UDATA (NULL,UNIT_RAW, 0)
    };

REG dn_reg[] = {
    { GRDATA (CSR, dn_csr, DEV_RDX, 16, 0) },
    { FLDATA (INT, IREQ (DN), INT_V_DN) },
    { FLDATA (DONE, dn_csr, CSR_V_DONE) },
    { FLDATA (IE, dn_csr, CSR_V_IE) },
    { GRDATA (DEVADDR, dn_dib.ba, DEV_RDX, 32, 0), REG_HRO },
    { GRDATA (DEVVEC, dn_dib.vec, DEV_RDX, 16, 0), REG_HRO },
    { NULL }
    };

MTAB dn_mod[] = {
    { MTAB_XTD|MTAB_VDV, 004, "ADDRESS", "ADDRESS",
      &set_addr, &show_addr, NULL },
    { MTAB_XTD|MTAB_VDV, 0, "VECTOR", "VECTOR",
      &set_vec, &show_vec, NULL },
    { 0 }
    };

DEVICE dn_dev = {
    "DN", &dn_unit, dn_reg, dn_mod,
    1, 10, 31, 1, DEV_RDX, 32,
    NULL, NULL, &dn_reset,
    NULL, NULL,NULL,
    &dn_dib, DEV_UBUS | DEV_QBUS
    };

/* dn-11 routines

   dn_rd       I/O page read
   dn_wr       I/O page write
   dn_reset    process reset
*/

t_stat dn_rd (int32 *data, int32 PA, int32 access)
{
//printf(" in dn_rd %8x \n",PA);	
*data = SleepCountMaster; // & DNCSR_R;   
return SCPE_OK;
}

t_stat dn_wr (int32 data, int32 PA, int32 access)
{
  SleepCountMaster = data;
//printf (" DN-11 A SleepCountMaster is %8x \n",SleepCountMaster);  
  if ((SleepCountMaster > 20) || (SleepCountMaster == 0))
      {NOQUEUE_WAIT = DEF_NOQUEUE_WAIT;}
  else if (SleepCountMaster > 10) 
	  {NOQUEUE_WAIT = DEF_NOQUEUE_WAIT /10;}
	  else {NOQUEUE_WAIT = DEF_NOQUEUE_WAIT /100;}
  
  //printf (" DN-11 B SleepCountMaster is %8x \n",SleepCountMaster);

  if (SleepCountMaster >= 1000){
	      SleepCountMaster = 0;}
//  if (SleepCountMaster == 0){
//	      NOQUEUE_WAIT = DEF_NOQUEUE_WAIT;}
//  printf (" DN-11 C SleepCountMaster is %8x \n",SleepCountMaster);
return SCPE_OK;
};


t_stat dn_reset (DEVICE *dptr)
{
//printf(" reset DN-11\n");
SleepCountMaster = 0;
NOQUEUE_WAIT = DEF_NOQUEUE_WAIT;
dn_csr = CSR_DONE; 
CLR_INT (DN);
return SCPE_OK;
}

