/* @(#)vms.c	1.8 03/04/13 joerg */
#ifndef lint
static	char sccsid[] =
	"@(#)vms.c	1.8 03/04/13 joerg";

#endif
/*
 * File vms.c - assorted bletcherous hacks for VMS.
 *
 * Written by Eric Youngdale (1993).
 * 2005-03-08 SMS.  Largely rewritten, greatly reducing bletcherosity.
 *
 */

#ifdef VMS
#include <stdlib.h>
#include <string.h>
#include <starlet.h>
#include <rms.h>
#include <descrip.h>
#include <ssdef.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mkisofs.h"
#include <stdio.h>

#include "vms.h"
#include "vms_init.h"
#include "vms_misc.h"

/*
   VMS-specific initialization for MKISOFS.

   2005-03-06 SMS.  New.
*/

int vms_init_done = -1;

#ifdef DECC_INIT

decc_feat_t decc_feat_array[] = {

   /* Preserve command-line case with SET PROCESS/PARSE_STYLE=EXTENDED. */
 { "DECC$ARGV_PARSE_STYLE", 1 },

   /* Preserve case for file names on ODS5 disks. */
 { "DECC$EFS_CASE_PRESERVE", 1 },

   /* Enable multiple dots (and most characters) in ODS5 file names,
      while preserving VMS-ness of ";version". */
 { "DECC$EFS_CHARSET", 1 },

   /* List terminator. */
 { (char *)NULL, 0 } };

#endif /* def DECC_INIT */

/* VMS initialization diagnostic flag. */

int vms_init_diag( void)
{
    return (verbose > 2);
}

/* 2005-03-07 SMS.
   vms_path_fixup().

   Convert VMS directory file name to VMS directory spec.  That is,
   change "dev:[a.b.c]e.DIR;1" to "dev:[a.b.c.e]".  The result (always
   smaller than the source) is left in the original buffer.

   This is a re-write of older code, adding compatibility with ODS5
   extended file names which may contain "]" or ">".
*/

void
vms_path_fixup( char *name)
{
    char *dir_start;
    char *dir_type_start;
    int dir_len;

    dir_len = strlen( name)- (sizeof( DIR_TYPE_VER)- 1);
    if (dir_len > 2)
    {
        /* Name is long enough for "[].DIR;1".  Type-vers must start here: */
        dir_type_start = name+ dir_len;

        /* Test (case-insensitive for ODS5) for final ".DIR;1". */
        if (strcasecmp( dir_type_start, DIR_TYPE_VER) == 0)
        {
            dir_len = find_dir( name, &dir_start);
            if (dir_len > 0)
            {
                /* Found directory delimiters.  Change:
                                v--- dir_type_start
                   "dev:[a.b.c]e.DIR;1" to:
                   "dev:[a.b.c.e]"
                              ^--- dir_start+ dir_len- 1
                */
                *dir_type_start = *(dir_start+ dir_len- 1);     /* Move end. */
                *(dir_start+ dir_len- 1) = '.';         /* Old end -> ".". */
                *(dir_type_start+ 1) = '\0';            /* Term aft new end. */
            }
        }
    }
} /* vms_path_fixup(). */


/* RMS structure pointers for I/O code below. */

static struct NAM_STRUCT *nam;
static struct RAB *rab;
static int rms_status;

/* RMS I/O code. */

/* 2005-03-07 SMS.
   Added code to accomodate ODS5 extended file names.
*/

static
error_exit( char *text)
{
    fprintf( stderr, "%s\n", text);
    exit(33);
}

static
int
open_file( char *fn)
{
    /* RMS file open. */

    struct NAM_STRUCT *nam;
    struct FAB *fab;

    nam = (struct NAM_STRUCT *) e_malloc( sizeof( struct NAM_STRUCT));
    rab = (struct RAB *) e_malloc( sizeof( struct RAB));
    fab = (struct FAB *) e_malloc( sizeof( struct FAB));

    *rab = cc$rms_rab;          /* Initialize RAB. */
    *fab = cc$rms_fab;          /* Initialize FAB. */
    *nam = CC_RMS_NAM;          /* Initialize NAM[L]. */

    rab->rab$l_fab = fab;       /* Point RAB to FAB. */
    fab->FAB_NAM = nam;         /* Point FAB to NAM[L]. */

#ifdef NAML$C_MAXRSS

    fab->fab$l_dna = (char *) -1;   /* Using NAML for default name. */
    fab->fab$l_fna = (char *) -1;   /* Using NAML for file name. */

#endif /* def NAML$C_MAXRSS */

    FAB_OR_NAM( fab, nam)->FAB_OR_NAM_FNA = fn;
    FAB_OR_NAM( fab, nam)->FAB_OR_NAM_FNS = strlen( fn);

    fab->fab$w_mrs = 512;                       /* Record size. */
    fab->fab$b_fac = FAB$M_BIO | FAB$M_GET;     /* Block, get access. */
    fab->fab$b_org = FAB$C_SEQ;                 /* Sequential access. */
    fab->fab$b_rfm = FAB$C_FIX;                 /* Fixed record format. */

    rms_status = sys$open( rab->rab$l_fab);
    if (rms_status != RMS$_NORMAL && rms_status != RMS$_CREATED)
        error_exit("$OPEN");
    rms_status = sys$connect( rab);
    if (rms_status != RMS$_NORMAL)
        error_exit("$CONNECT");
    return 1;
}

static
void
close_file( struct RAB *prab)
{
    rms_status = sys$close( prab->rab$l_fab);   /* Close file. */

    free( prab->rab$l_fab->FAB_NAM);            /* Free NAM[L]. */
    free( prab->rab$l_fab);                     /* Free FAB. */
    free( prab);                                /* Free RAB. */
    if (rms_status != RMS$_NORMAL)
        error_exit( "$CLOSE");
}

#define NSECT 16
extern unsigned int last_extent_written;

void
vms_write_one_file( char *filename, off_t size, FILE *outfile)
{
    char buffer[ SECTOR_SIZE* NSECT];
    int count;
    int i;
    int progress_mod;
    off_t remain;
    int status;
    off_t use;

    open_file( filename);

    remain = size;
    progress_mod = (gui ? 500 : 5000);

    while (remain > 0)
    {
        use = (remain > SECTOR_SIZE* NSECT- 1 ? NSECT* SECTOR_SIZE : remain);
        use = ISO_ROUND_UP( use);       /* Round up to whole sector. */
        memset( buffer, 0, use);
        rab->rab$l_ubf = buffer;
        rab->rab$w_usz = sizeof( buffer);
        status = sys$read( rab);
        fwrite( buffer, 1, use, outfile);
        last_extent_written += use/ SECTOR_SIZE;
        if (verbose > 0)
        {
            write_one_file_progress( use, progress_mod);
        }
        remain -= use;
    };
    close_file( rab);
}

#endif

