#                                               6 March 2006.  SMS.
#
#    MTOOLS 3.9.10 for VMS - MMS (or MMK) Description File.
#
# Usage:
#
#    MMS /DESCRIP = [.VMS]DESCRIP.MMS [/MACRO = (<see_below>)] [target]
#
# Note that this description file must be used from the main
# distribution directory, not from the [.VMS] subdirectory.
#
# Optional macros:
#
#    CCOPTS=xxx     Compile with CC options xxx.  For example:
#                   "CCOPTS=/ARCH=HOST" or "CCOPTS=/NAMES=AS_IS"
#
#    DBG=1          Compile with /DEBUG /NOOPTIMIZE.
#                   Link with /DEBUG /TRACEBACK.
#                   (Default is /NOTRACEBACK.)
#
#    LARGE=1        Enable large-file (>2GB) support.  Non-VAX only.
#
#    LINKOPTS=xxx   Link with LINK options xxx.  For example:
#                   "LINKOPTS=/NOINFO"
#
#    LIST=1         Compile with /LIST /SHOW = (ALL, NOMESSAGES).
#                   Link with /MAP /CROSS_REFERENCE /FULL.
#
#    "LOCAL_MTOOLS=c_macro_1=value1 [, c_macro_2=value2 [...]]"
#                   Compile with these additional C macros defined.
#
# The default target, ALL, builds the selected product executables.
#
# Other targets:
#
#    CLEAN       deletes architecture-specific files, but leaves any
#                individual source dependency files and the help files.
#
#    CLEAN_ALL   deletes all generated files, except the main
#                (collected) source dependency file.
#
#    CLEAN_EXE   deletes only the architecture-specific executables.
#                Handy if all you wish to do is re-link the executables.
#
#    CLEAN_OLB   deletes only the architecture-specific object
#                libraries.
#
#
#
# Example commands:
#
# To build the conventional small-file product (Note: DESCRIP.MMS is the
# default description file name.):
#
#    MMS /DESCRIP = [.VMS]
#
# To get the large-file executables (on a non-VAX system):
#
#    MMS /DESCRIP = [.VMS] /MACRO = (LARGE=1)
#
# To delete the architecture-specific generated files for this system
# type:
#
#    MMS /DESCRIP = [.VMS] /MACRO = (LARGE=1) CLEAN     ! Large-file.
# or
#    MMS /DESCRIP = [.VMS] CLEAN                        ! Small-file.
#
# To build a complete small-file product for debug with compiler
# listings and link maps:
#
#    MMS /DESCRIP = [.VMS] CLEAN
#    MMS /DESCRIP = [.VMS] /MACRO = (DBG=1, LIST=1)
#
########################################################################

# Include primary product description file.

INCL_DESCRIP_SRC = 1
.INCLUDE [.vms]descrip_src.mms

# Object library names.

LIB_MTOOLS = [.$(DEST)]libmtools.olb


# TARGETS.

# Default target, ALL.  Build all executables.

ALL : $(MTOOLS)
	@ write sys$output "Done."

# CLEAN target.  Delete the [.$(DEST)] directory and everything in it.

CLEAN :
	if (f$search( "[.$(DEST)]*.*") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.*;*
	if (f$search( "$(DEST).dir", 1) .nes. "") then -
	 set protection = w:d $(DEST).dir;*
	if (f$search( "$(DEST).dir", 2) .nes. "") then -
	 delete /noconfirm $(DEST).dir;*

# CLEAN_ALL target.  Delete:
#    The [.$(DEST)] directories and everything in them.
#    CONFIG.H.
#    All individual C dependency files.
# Also mention:
#    Comprehensive dependency file.

CLEAN_ALL :
	if (f$search( "[.ALPHA*]*.*") .nes. "") then -
	 delete /noconfirm [.ALPHA*]*.*;*
	if (f$search( "ALPHA*.dir", 1) .nes. "") then -
	 set protection = w:d ALPHA*.dir;*
	if (f$search( "ALPHA*.dir", 2) .nes. "") then -
	 delete /noconfirm ALPHA*.dir;*
	if (f$search( "[.IA64*]*.*") .nes. "") then -
	 delete /noconfirm [.IA64*]*.*;*
	if (f$search( "IA64*.dir", 1) .nes. "") then -
	 set protection = w:d IA64*.dir;*
	if (f$search( "IA64*.dir", 2) .nes. "") then -
	 delete /noconfirm IA64*.dir;*
	if (f$search( "[.VAX*]*.*") .nes. "") then -
	 delete /noconfirm [.VAX*]*.*;*
	if (f$search( "VAX*.dir", 1) .nes. "") then -
	 set protection = w:d VAX*.dir;*
	if (f$search( "VAX*.dir", 2) .nes. "") then -
	 delete /noconfirm VAX*.dir;*
	if (f$search( "$(CONFIG_H)") .nes. "") then -
	 delete /log /noconfirm $(CONFIG_H);*
	if (f$search( "*.MMSD") .nes. "") then -
	 delete /noconfirm *.MMSD;*
	if (f$search( "[.vms]*.MMSD") .nes. "") then -
	 delete /noconfirm [.vms]*.MMSD;*
	@ write sys$output ""
	@ write sys$output "Note:  This procedure will not"
	@ write sys$output "   DELETE [.VMS]DESCRIP_DEPS.MMS;*"
	@ write sys$output -
 "You may choose to, but a recent version of MMS (V3.5 or newer?) is"
	@ write sys$output -
 "needed to regenerate it.  (It may also be recovered from the original"
	@ write sys$output -
 "distribution kit.)  See [.VMS]DESCRIP_MKDEPS.MMS for instructions on"
	@ write sys$output -
 "generating [.VMS]DESCRIP_DEPS.MMS."
	@ write sys$output ""

# CLEAN_EXE target.  Delete the executables in [.$(DEST)].

CLEAN_EXE :
	if (f$search( "[.$(DEST)]*.exe") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.exe;*

# CLEAN_OLB target.  Delete the object libraries in [.$(DEST)].

CLEAN_OLB :
	if (f$search( "[.$(DEST)]*.olb") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.olb;*

# CLEAN_TEST target.  Delete the test result files in [.$(DEST)].

CLEAN_TEST :
	if (f$search( "[.$(DEST)]*.rb2") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.rb2;*
	if (f$search( "[.$(DEST)]*.tst") .nes. "") then -
	 delete /noconfirm [.$(DEST)]*.tst;*


# Include CONFIG.H dependency and rule.

INCL_CONFIG_SRC = 1
.INCLUDE [.VMS]descrip_config.mms

# Object library module dependencies.

$(LIB_MTOOLS) : $(LIB_MTOOLS)($(MODS_OBJS_LIB_MTOOLS))
	@ write sys$output "$(MMS$TARGET) updated."

# Default C compile rule.

.C.OBJ :
	$(CC) $(CFLAGS) /define = ($(CDEFS)) $(MMS$SOURCE)


# MTOOLS executable.

$(MTOOLS) : [.$(DEST)]mtools.obj $(LIB_MTOOLS)
	$(LINK) $(LINKFLAGS) $(MMS$SOURCE), -
	 $(LIB_MTOOLS) /include = (vms) /library


# Include generated source dependencies.

INCL_DESCRIP_DEPS = 1
.INCLUDE [.vms]descrip_deps.mms

