#                                               14 March 2006.  SMS.
#
#    MTOOLS 3.9.10 for VMS - MMS (or MMK) Source Description File.
#

# This description file is included by other description files.  It is
# not intended to be used alone.  Verify proper inclusion.

.IFDEF INCL_DESCRIP_SRC
.ELSE
$$$$ THIS DESCRIPTION FILE IS NOT INTENDED TO BE USED THIS WAY.
.ENDIF


# Define MMK architecture macros when using MMS.

.IFDEF __MMK__                  # __MMK__
.ELSE                           # __MMK__
ALPHA_X_ALPHA = 1
IA64_X_IA64 = 1
VAX_X_VAX = 1
.IFDEF $(MMS$ARCH_NAME)_X_ALPHA     # $(MMS$ARCH_NAME)_X_ALPHA
__ALPHA__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_ALPHA
.IFDEF $(MMS$ARCH_NAME)_X_IA64      # $(MMS$ARCH_NAME)_X_IA64
__IA64__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_IA64
.IFDEF $(MMS$ARCH_NAME)_X_VAX       # $(MMS$ARCH_NAME)_X_VAX
__VAX__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_VAX
.ENDIF                          # __MMK__

# Analyze architecture-related and option macros.

.IFDEF __ALPHA__                # __ALPHA__
DESTM = ALPHA
.ELSE                           # __ALPHA__
.IFDEF __IA64__                     # __IA64__
DESTM = IA64
.ELSE                               # __IA64__
.IFDEF __VAX__                          # __VAX__
DESTM = VAX
.ELSE                                   # __VAX__
DESTM = UNK
UNK_DEST = 1
.ENDIF                                  # __VAX__
.ENDIF                              # __IA64__
.ENDIF                          # __ALPHA__

.IFDEF LARGE                    # LARGE
.IFDEF __VAX__                      # __VAX__
DESTL =
.ELSE                               # __VAX__
DESTL = L
.ENDIF                              # __VAX__
.ELSE                           # LARGE
DESTL =
.ENDIF                          # LARGE

DEST = $(DESTM)$(DESTL)

# Check for option problems.

.IFDEF __VAX__                  # __VAX__
.IFDEF LARGE                        # LARGE
LARGE_VAX = 1
.ENDIF                              # LARGE
.ENDIF                          # __VAX__

# Complain if warranted.  Otherwise, show destination directory.
# Make the destination directory, if necessary.
				
.IFDEF UNK_DEST                 # UNK_DEST
.FIRST
	@ write sys$output -
 "   Unknown system architecture."
.IFDEF __MMK__                      # __MMK__
	@ write sys$output -
 "   MMK on IA64?  Try adding ""/MACRO = __IA64__""."
.ELSE                               # __MMK__
	@ write sys$output -
 "   MMS too old?  Try adding ""/MACRO = MMS$ARCH_NAME=ALPHA"","
	@ write sys$output -
 "   or ""/MACRO = MMS$ARCH_NAME=IA64"", or ""/MACRO = MMS$ARCH_NAME=VAX"","
	@ write sys$output -
 "   as appropriate.  (Or try a newer version of MMS.)"
.ENDIF                              # __MMK__
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                           # UNK_DEST
.IFDEF LARGE_VAX                    # LARGE_VAX
.FIRST
	@ write sys$output -
 "   Macro ""LARGE"" is invalid on VAX."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                               # LARGE_VAX
.FIRST
	@ write sys$output "   Destination: [.$(DEST)]"
	@ write sys$output ""
	if (f$search( "$(DEST).DIR;1") .eqs. "") then -
	 create /directory [.$(DEST)]
	$(MMS) /descrip = [.vms]descrip_config.mms -
	 /macro = (INCL_CONFIG_SRC=1, CONFIG_H=$(CONFIG_H))
.ENDIF                              # LARGE_VAX
.ENDIF                          # UNK_DEST

# DBG options.

.IFDEF DBG                      # DBG
CFLAGS_DBG = /debug /nooptimize
LINKFLAGS_DBG = /debug /traceback
.ELSE                           # DBG
CFLAGS_DBG =
### LINKFLAGS_DBG = /notraceback
LINKFLAGS_DBG =
.ENDIF                          # DBG

# Large-file options.

.IFDEF LARGE                    # LARGE
CDEFS_LARGE = , _LARGEFILE
.ELSE                           # LARGE
CDEFS_LARGE =
.ENDIF                          # LARGE

# C compiler defines.

.IFDEF LOCAL_MTOOLS
C_LOCAL_MTOOLS = , $(LOCAL_MTOOLS)
.ELSE
C_LOCAL_MTOOLS =
.ENDIF

CDEFS = VMS $(CDEFS_LARGE) $(C_LOCAL_MTOOLS)

# Other C compiler options.

CFLAGS_INCL = /include = ([], [.VMS])

CFLAGS_ARCH = /decc /prefix = (all) /names = as_is

# LIST options.

.IFDEF LIST                     # LIST
.IFDEF DECC                         # DECC
CFLAGS_LIST = /list = $*.LIS /show = (all, nomessages)
.ELSE                               # DECC
CFLAGS_LIST = /list = $*.LIS /show = (all)
.ENDIF                              # DECC
LINKFLAGS_LIST = /map = $*.MAP /cross_reference /full
.ELSE                           # LIST
CFLAGS_LIST =
LINKFLAGS_LIST =
.ENDIF                          # LIST

# Common CFLAGS and LINKFLAGS.

CFLAGS = \
 $(CFLAGS_ARCH) $(CFLAGS_DBG) $(CFLAGS_INCL) $(CFLAGS_LIST) $(CCOPTS) \
 /object = $(MMS$TARGET)

LINKFLAGS = \
 $(LINKFLAGS_DBG) $(LINKFLAGS_LIST) $(LINKOPTS) \
 /executable = $(MMS$TARGET)

# Object library module=object lists.

#    Primary object library, [].

MODS_OBJS_LIB_MTOOLS_N = \
 buffer=[.$(DEST)]buffer.obj \
 codepage=[.$(DEST)]codepage.obj \
 codepages=[.$(DEST)]codepages.obj \
 config=[.$(DEST)]config.obj \
 copyfile=[.$(DEST)]copyfile.obj \
 devices=[.$(DEST)]devices.obj \
 dircache=[.$(DEST)]dircache.obj \
 directory=[.$(DEST)]directory.obj \
 direntry=[.$(DEST)]direntry.obj \
 expand=[.$(DEST)]expand.obj \
 fat=[.$(DEST)]fat.obj \
 fat_free=[.$(DEST)]fat_free.obj \
 file=[.$(DEST)]file.obj \
 file_name=[.$(DEST)]file_name.obj \
 filter=[.$(DEST)]filter.obj \
 floppyd_io=[.$(DEST)]floppyd_io.obj \
 force_io=[.$(DEST)]force_io.obj \
 hash=[.$(DEST)]hash.obj \
 init=[.$(DEST)]init.obj \
 llong=[.$(DEST)]llong.obj \
 mainloop=[.$(DEST)]mainloop.obj \
 match=[.$(DEST)]match.obj \
 mattrib=[.$(DEST)]mattrib.obj \
 mbadblocks=[.$(DEST)]mbadblocks.obj \
 mcat=[.$(DEST)]mcat.obj \
 mcd=[.$(DEST)]mcd.obj \
 mclasserase=[.$(DEST)]mclasserase.obj \
 mcopy=[.$(DEST)]mcopy.obj \
 mdel=[.$(DEST)]mdel.obj \
 mdir=[.$(DEST)]mdir.obj \
 mdoctorfat=[.$(DEST)]mdoctorfat.obj \
 mdu=[.$(DEST)]mdu.obj \
 mformat=[.$(DEST)]mformat.obj \
 minfo=[.$(DEST)]minfo.obj \
 misc=[.$(DEST)]misc.obj \
 missfuncs=[.$(DEST)]missfuncs.obj \
 mk_direntry=[.$(DEST)]mk_direntry.obj \
 mlabel=[.$(DEST)]mlabel.obj \
 mmd=[.$(DEST)]mmd.obj \
 mmount=[.$(DEST)]mmount.obj \
 mmove=[.$(DEST)]mmove.obj \
 mpartition=[.$(DEST)]mpartition.obj \
 mshowfat=[.$(DEST)]mshowfat.obj \
 mtools=[.$(DEST)]mtools.obj \
 mzip=[.$(DEST)]mzip.obj \
 patchlevel=[.$(DEST)]patchlevel.obj \
 plain_io=[.$(DEST)]plain_io.obj \
 precmd=[.$(DEST)]precmd.obj \
 privileges=[.$(DEST)]privileges.obj \
 signal=[.$(DEST)]signal.obj \
 stream=[.$(DEST)]stream.obj \
 streamcache=[.$(DEST)]streamcache.obj \
 subdir=[.$(DEST)]subdir.obj \
 toupper=[.$(DEST)]toupper.obj \
 tty=[.$(DEST)]tty.obj \
 unixdir=[.$(DEST)]unixdir.obj \
 vfat=[.$(DEST)]vfat.obj

###  scsi=[.$(DEST)]scsi.obj \
###  tty=[.$(DEST)]tty.obj \


#    Primary object library, [.vms].

MODS_OBJS_LIB_MTOOLS_V = \
 vms=[.$(DEST)]vms.obj \
 vms_scsi=[.$(DEST)]vms_scsi.obj

MODS_OBJS_LIB_MTOOLS = $(MODS_OBJS_LIB_MTOOLS_N) $(MODS_OBJS_LIB_MTOOLS_V)

# Executables.

MTOOLS = [.$(DEST)]mtools.exe

# Configuration header file.

CONFIG_H = []config.h

