/* 2006-02-08 SMS.
   VMS-specific header associated with vms.c.
*/

#ifndef _VMS_H
#define _VMS_H

#include <types.h>

/* Flag bits and mask for use with VMS channel in file descriptor int.
 * Avoid the sign bit, as "-1" has a special meaning (open failure).
 */
#define VMS_FD_CMASK    0x0000ffff      /* Actual channel mask. */
#define VMS_FD_CHAN     0x40000000      /* Is VMS channel, not real fd. */
#define VMS_FD_MOUNTED  0x20000000      /* We mounted the device. */
#define VMS_FD_NOUNLOAD 0x10000000      /* DISMOUNT /NOUNLOAD. */

/* Macros for directory specification file types. */
#define DOT_DIR ".DIR"
#define DOT_DIRV ".DIR;1"

/* GETxxI item descriptor structure. */
typedef struct
    {
    short buf_len;
    short itm_cod;
    void *buf;
    short *ret_len;
    } xxi_item_t;

/* Desperation attempts to define unknown macros.  Probably doomed.
 * If these get used, expect sys$getjpiw() to return %x00000014 =
 * %SYSTEM-F-BADPARAM, bad parameter value.
 * They keep compilers with old header files quiet, though.
 */
#ifndef JPI$_RMS_EXTEND_SIZE
#  define JPI$_RMS_EXTEND_SIZE 542
#endif /* ndef JPI$_RMS_EXTEND_SIZE */

#ifndef JPI$_RMS_DFMBC
#  define JPI$_RMS_DFMBC 535
#endif /* ndef JPI$_RMS_DFMBC */

#ifndef JPI$_RMS_DFMBFSDK
#  define JPI$_RMS_DFMBFSDK 536
#endif /* ndef JPI$_RMS_DFMBFSDK */

/* File open callback ID values. */

#  define FOPR_ID 1
#  define FOPW_ID 2

/* File open callback ID storage. */

extern int fopr_id;
extern int fopw_id;

/*    Function prototypes. */

/* Basename extraction functions. */

extern const char *vms_basename( const char *file_spec);
extern const char *vms_basename2( const char *file_spec);
extern const char *vms_basenamex( const char *file_spec);
extern const char *vms_basenamev( const char *file_spec);

/* ODS2-ODS5 detection. */

extern int vms_ods2_names( char *file_spec);

/* VMS block I/O functions */

extern int vms_block_open( const char *name);

extern int vms_block_close( int chan_int);

extern int vms_block_read( int chan_int, char *buf, off_t where, size_t len);

extern int vms_block_write( int chan_int, char *buf, off_t where, size_t len);

/* Dummy replacement function. */

extern pid_t fork( void);

#endif /* ndef _VMS_H */

