/*
 * Copyright (c) 1990 by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * This software is furnished under a license and may be used and copied
 * only  in  accordance  with  the  terms  of such  license and with the
 * inclusion of the above copyright notice.  This software or any  other
 * copies thereof may not be provided or otherwise made available to any
 * other person.  No title to and ownership of the  software  is  hereby
 * transferred.
 *
 * The information in this software  is subject to change without notice
 * and  should  not be  construed  as a commitment by Digitial Equipment
 * Corporation.
 *
 * Digital assumes no responsibility for the use or  reliablity  of its
 * software on equipment which is not supplied by Digital.
 *
 */

#ifndef _DTSSPROVIDER_H
#define _DTSSPROVIDER_H


#ifdef unix
#include <utc.h>		/* utc library routines 		*/
#endif
#ifdef vms
#include "utc.h"
#endif

/*
 * 	DTSS TPI Typedef declarations
 */

/*
 * TPI version numbers
 */
#define K_TPI_VERSION_MAJOR  1
#define K_TPI_VERSION_MINOR  0

/*
 * Minimum and Maximum number of times to read time source each
 * synchronization
 */

#define K_MIN_TIMESTAMPS     1          /* Read the source at least 1   *
					 * time each synchronization    */
#define K_MAX_TIMESTAMPS     6          /* Read the source at most 6    *
					 * times each synchronization   */

/*
 * Message status field return values
 */
#define K_TPI_FAILURE        0          /* Failure */
#define K_TPI_SUCCESS        1          /* Success */

/*
 * Message type field values
 */
#define K_TPI_TIME_MESSAGE   0          /* Time response message */
#define K_TPI_CTL_MESSAGE    1          /* Control message */


/*
 * This structure contains one reading of the TP wrapped in the time
 * stamps of the local clock.  
 */
typedef struct TimeResponseType
{
   struct utc beforeTime;		/* local clk just before getting UTC */
   struct utc TPtime;			/* source UTC; inacc also supplies */
   struct utc afterTime;		/* local clk just after getting UTC */
} TimeResponseType;

/*
 * Time provider control message.  The first message 
 * broadcast in response to a time service request.
 */
typedef struct TPctlMsg
{
    unsigned long nextPoll;
    unsigned long timeout;
    unsigned long noClockSet;
} TPctlMsg;



/*
 * TP time stamp message.  The actual time provider
 * synchronization data.
 */
typedef struct TPtimeMsg
{
    unsigned long timeStampCount;       /* number of time stamps being *
					 * returned in this mesage.    */
    TimeResponseType  timeStampList[K_MAX_TIMESTAMPS];  
					/* set of time stamps being    *
					 * returned.		       */
} TPtimeMsg;    

/*
 * Time Provider message to the server contains a set
 * of time stamps or a time out response.
 */
typedef struct TPrspMsg
{
    unsigned short version_major;
    unsigned short version_minor;
    unsigned short status;        	/* TPI message status 		  */
    unsigned short TPmsgType;      	/* type of message (control,data) */
    unsigned long TPsyncID;             /* message/synchronization ID     */
    union 
    {
	TPctlMsg     TPctlMsg;    	/* Message contents		  */
	TPtimeMsg    TimeMsg;
    } TPdata;
}  TPrspMsg;

/*
 * This structure contains the current service synch serial number. 
 * The message is sent to the Time Provider to wake it into sending
 * a time response message (TPrspMsg).
 */
typedef struct TPreqMsg
{
   unsigned short version_major;
   unsigned short version_minor;
   unsigned long TPsyncID; 		/* service synch. Serial Number    */
} TPreqMsg;

#endif


