$!                                              5 February 1999.  SMS.
$!
$!    Convert a BACKUP save set which has been changed into a 512-byte
$!    fixed length record file back to a file with the original record
$!    length.  This procedure uses SET FILE /ATTRIBUTE, which is not
$!    available before VMS V6.x.
$!
$!    P1 = file spec.
$!
$ wso = "write  sys$output"
$!
$! Verify the file name parameter.
$!
$ p1 = f$edit( p1, "trim")
$ if (p1 .eqs. "")
$ then
$    cpr_name = f$environment( "procedure")
$    cpr_name = f$parse( cpr_name, , , "name", "syntax_only")
$    wso  ""
$    wso  "      usage:"
$    wso  ""
$    wso  "   @ ''cpr_name'  file_spec"
$    wso  ""
$    exit
$ endif
$!
$ on error then continue
$!
$! Open the file, read the first record, and close the file.
$!
$ open /read  ss_file  'p1'
$ sts = $status
$!
$ if (.not. sts) then exit
$!
$ read  ss_file  record
$ sts = $status
$ close  ss_file
$!
$ if (.not. sts) then exit
$!
$! Check the file record length.
$!
$ rec_len = f$length( record)
$ if (rec_len .ne. 512)
$ then
$    wso  ""
$    wso  "   Original file record length (''rec_len') is not 512."
$    wso  ""
$    exit
$ endif
$!
$! Extract the original record length from the data.
$!
$ rec_len = f$cvui( (40* 8), 32, record)
$!
$! Show the extracted value, and verify intent.
$!
$ wso  "   Original save set record length was ''rec_len'."
$!
$ read /prompt = "   Convert? (y/n) [n]: "  sys$command  ans
$!
$! If requested, change the file attributes.
$!
$ if (ans)
$ then
$    wso  "   Setting file attributes..."
$    set file /attribute = lrl: 'rec_len'  'p1'
$ endif
$!
