! DESCRIP.MMS - MMS file for PGP/VMS
! (c) Copyright 1991-93 by Hugh Kennedy. All rights reserved.
!
! The author assumes no liability for damages resulting from the use
! of this software, even if the damage results from defects in this
! software.  No warranty is expressed or implied.
!
! The above notwithstanding, a license to use this software is granted
! to anyone either in the original form or modified on condition that 
! this notice is not removed.
!
! Options Flags:
!
! PGP_DEBUG -  Define if you want the debug version
! PGP_GCC -    Define to use GNU C instead of VAX C
! PGP_RSADIR - Use RSAREF Routines from specified directory.
!
! Modified:	03	Date:	21-Nov-1991	Author: Hugh A.J. Kennedy.
!
! Adapted to use new modules from release 1.3
!
! Modified:	04	Date:	11-Mar-1991	Author:	Hugh A.J. Kennedy
!
! Add test harness program, RSATST as a target.
!
! Modified:	07	Date:	8-Apr-1992	Author:	Hugh A.J. Kennedy
!
! Adapted for new modules from release 1.7.
! Change method of support for GCC (use one options file)
!
! Modified:	08	Date:	25-Jun-1992	Author:	Hugh A.J. Kennedy.
!
! All change (again) for 1.8. Alphabetise module list for ease of comparison.
!
! Modified:	09	Date:	18-Sep-1992	Author: Hugh A.J. Kennedy
!
! Remove references to private string routine versions - no longer reqd.
!
! Modified:	10	Date:	7-Nov-1992	Author:	Hugh A.J. Kennedy
!
! Misc fixes for V2.01
!
! Modified:	11	Date:	28-Jan-1993	Author:	Hugh A.J. Kennedy
!
! Allow use of logicals for source and object directories (keeps things
! cleaner).
!
! Modified:	12	Date:	24-Feb-1993	Author: Hugh A.J. Kennedy
!
! Ammend dependencies to include new header files.
!
! Modified:	13	Date:	10-May-1993	Author:	Hugh A.J. Kennedy
!
! Update support for GNU C. Fix dependencies.
! Add support for RSAREF (untested, as I live outside the US).
!
.ifdef PGP_COMPAT

VFLAGS = ,COMPATIBLE
MD = MD4

.else

MD = MD5

.endif

warnflags = /warnings = (disable = (ALIGNEXT, IMPLICITFUNC))

.ifdef WFLAGS
XFLAGS = /define=($(WFLAGS)) $(warnflags)
ZFLAGS = /define=($(WFLAGS),EXPORT,NO_ASM,NOSTORE) $(warnflags)
.else
ZFLAGS = $(CFLAGS) /define=(EXPORT,NO_ASM,NOSTORE) $(warnflags)
.endif

.ifdef PGP_GCC		! Use GNU CC Compiler

CC = GCC
C_PATH_NAME = C_INCLUDE_PATH

.ifdef PGP_RSADIR

CCLIB = ,GNU_CC:[000000]GCCLIB/lib,

.else

CCLIB = GNU_CC:[000000]GCCLIB/lib,

.endif

.else

C_PATH_NAME = C$INCLUDE

.endif
!
! Debugging Support
!
.ifdef PGP_DEBUG

MFLAGS = $(MFLAGS) /debug
LINKFLAGS = $(LINKFLAGS) /debug/exe=$(mms$target)

.ifdef PGP_GCC		! Are we debugging AND using GCC?

DFLAGS = /DEBUG

.else			! No, Debugging with VAX C
                      
DFLAGS = /debug/noopt
     
.endif

YFLAGS = $(XFLAGS)

.else			! Not debugging

.ifdef PGP_GCC		! Use GCC w/o debug

YFLAGS = $(XFLAGS)

.else			! Use VAX C w/o debug

DFLAGS = /opt=noinline
YFLAGS = $(XFLAGS)

.endif

LINKFLAGS = /exe=$(mms$target)
.endif

incflags = /include = [-.rsaref.source]

CFLAGS = $(CFLAGS)$(DFLAGS)$(YFLAGS)$(warnflags)$(incflags)

default : pgp.exe
	@	! do nothing...

!
! RSAREF Stuff
!
.ifdef PGP_RSADIR
                                     
RSAOBJS = rsa.obj, nn.obj, r_random.obj, r_stdlib.obj
rsa.obj	: $(PGP_RSADIR)rsa.c global.h $(PGP_RSADIR)rsaref.h -
		$(PGP_RSADIR)r_random.h $(PGP_RSADIR)md5.h
	$(CC) $(CFLAGS) /INCLUDE=([],$(PGP_RSADIR))/define=("static=") $(MMS$SOURCE)
nn.obj	: $(PGP_RSADIR)nn.c global.h $(PGP_RSADIR)rsaref.h -
		$(PGP_RSADIR)digit.h
	$(CC) $(CFLAGS) /INCLUDE=([],$(PGP_RSADIR)) $(MMS$SOURCE)
digit.obj	: $(PGP_RSADIR)digit.c global.h $(PGP_RSADIR)rsaref.h -
		$(PGP_RSADIR)nn.h $(PGP_RSADIR)digit.h
	$(CC) $(CFLAGS) /INCLUDE=([],$(PGP_RSADIR)) $(MMS$SOURCE)
r_random.obj : $(PGP_RSADIR)r_random.c global.h -
		$(PGP_RSADIR)rsaref.h $(PGP_RSADIR)r_random.h $(PGP_RSADIR)md5.h
	$(CC) $(CFLAGS) /INCLUDE=([],$(PGP_RSADIR))/define=("static=") $(MMS$SOURCE)
r_stdlib.obj : $(PGP_RSADIR)r_stdlib.c global.h -
		$(PGP_RSADIR)rsaref.h 
	$(CC) $(CFLAGS) /INCLUDE=([],$(PGP_RSADIR))/define=("static=") $(MMS$SOURCE)

.endif

!
! ZIP Stuff
!
ZIPOBJS = zbits.obj zdeflate.obj zglobals.obj zinflate.obj -
	zip.obj zipup.obj zfile_io.obj ztrees.obj zunzip.obj
ZIPH=	zrevisio.h ztailor.h zunzip.h zip.h ziperr.h      
zbits.obj : zbits.c $(ZIPH)
	$(CC) $(DFLAGS) $(ZFLAGS) $(mms$source)
zdeflate.obj : zdeflate.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zfile_io.obj : zfile_io.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zglobals.obj : zglobals.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zinflate.obj : zinflate.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zip.obj : zip.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zipup.obj : zipup.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
ztrees.obj : ztrees.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
zunzip.obj : zunzip.c $(ZIPH)
	$(CC)  $(DFLAGS) $(ZFLAGS) $(mms$source)
!
! PGP Stuff
!
armor.obj : armor.c armor.h
charset.obj : charset.c usuals.h language.h charset.h -
	system.h
config.obj : config.c usuals.h pgp.h
CRYPTO.obj : mpilib.h mpiio.h random.h crypto.h -
	keymgmt.h mdfile.h md5.h fileio.h pgp.h -
	rsaglue.h platform.h usuals.h -
	CRYPTO.C
idea.obj : idea.h pgp.h idea.c
FILEIO.obj : FILEIO.C random.h mpilib.h mpiio.h -
	platform.h usuals.h -
	fileio.h pgp.h 

!!! getopt.obj : getopt.c

genprime.obj : genprime.c genprime.h mpilib.h random.h -
	platform.h usuals.h
keyadd.obj : mpilib.h random.h crypto.h fileio.h -
	keymgmt.h keyadd.h genprime.h rsagen.h mpiio.h -
	platform.h usuals.h -
	pgp.h language.h charset.h keyadd.c
keymaint.obj : mpilib.h random.h crypto.h fileio.h -
	keymgmt.h keyadd.h genprime.h mpiio.h pgp.h -
	platform.h usuals.h -
	language.h -
	charset.h keymaint.c
KEYMGMT.obj : mpilib.h usuals.h random.h crypto.h -
	fileio.h mpiio.h pgp.h charset.h -
	platform.h usuals.h -
	KEYMGMT.C

MD5.obj : md5.C md5.h
	$(CC) $(CFLAGS) /noopt $(MMS$SOURCE)

MDFILE.obj : mpilib.h mdfile.h md5.h pgp.h -
      	platform.h usuals.h -
	MDFILE.C
MORE.obj : MORE.C mpilib.h pgp.h 
MPIIO.obj : MPIIO.C mpiio.h mpilib.h -
	platform.h usuals.h
MPILIB.obj : MPILIB.C mpilib.h platform.h usuals.h
noise.obj : noise.c noise.h randpool.h usuals.h
passwd.obj : passwd.c random.h md5.h pgp.h 
PGP.obj : mpilib.h random.h crypto.h fileio.h -
	keymgmt.h keymaint.h charset.h pgp.h config.h -
	platform.h usuals.h -
	PGP.C
RANDOM.obj : random.h pgp.h RANDOM.C
randpool.obj : randpool.c md5.h randpool.h usuals.h
rsagen.obj : rsagen.c mpilib.h genprime.h rsagen.h -
	platform.h usuals.h -
	random.h rsaglue.h
rsaglue.obj : rsaglue.c mpilib.h mpiio.h pgp.h rsaglue.h
rsatst.obj : rsatst.c mpilib.h mpiio.h genprime.h -
	platform.h usuals.h -
	rsagen.h random.h
language.obj : language.c charset.h usuals.h fileio.h -
	pgp.h
SYSTEM.obj : exitpgp.h system.h pgp.h mpilib.h -
	mpiio.h fileio.h charset.h -
	platform.h usuals.h -
	SYSTEM.C
vax.obj : vax.mar
!
! RSATST Is the RSA/Multiple Precision Library Test Harness
!
rsatst.exe : rsatst.opt rsatst.obj mpilib.obj -
	genprime.obj rsagen.obj mpiio.obj random.obj -
	vax.obj system.obj language.obj fileio.obj
	$(LINK) $(LINKFLAGS) rsatst/opt
!
! Link PGP
!
OBJ1 =	pgp.obj config.obj crypto.obj keymgmt.obj -
	keyadd.obj keymaint.obj fileio.obj mdfile.obj -
	more.obj armor.obj mpilib.obj mpiio.obj -
        noise.obj  randpool.obj -
        genprime.obj rsagen.obj random.obj -
	idea.obj passwd.obj md5.obj system.obj -
	language.obj vax.obj charset.obj rsaglue.obj

!!!	getopt.obj

pgp.exe : pgp.opt $(OBJ1) $(ZIPOBJS)
	$(LINK) $(LINKFLAGS) pgp/opt
