# Makefile for PGP (VMS)
#
#
# This makefile is intended for PGP 2.6.3i. PGP 2.6.3i is based on MIT's
# PGP 2.6.2, but has been modified so that it:
#
#  (1) does not use RSAREF
#  (2) allows you to disable the "legal kludge"
#  (3) corrects a number of bugs present in PGP 2.6.2
#  (4) adds a number of new features without breaking compatibility
#      with older versions
#
# PGP 2.6.3i is probably illegal to use within the USA, so if you're
# physically inside the US, you should do the following:
#
#  (1) Obtain and build a copy of the RSAREF 1.0 library (included with
#      MIT PGP 2.6 and later)
#  (2) Add the -DUSA compiler switch to CFLAGS for your system below
#  (3) Comment out the lines for MPILIB (rsaglue1.o) and uncomment the
#      lines for RSAREF (rsaglue2.o) below
#
# This will give you a version of PGP called 2.6.3, which is identical
# to 2.6.3i, except that it uses RSAREF and the "legal kludge" cannot
# be disabled.
#
#
# CFLAGS options:
#
# -DUSA       to get a version that is legal to use within the US
#
# Define one of:
# -DMERRITT    Merritt's modmult (fast on risc machines)
# -DPEASANT    Russian peasant modulo multiply algorithm
# -DUPTON      use Upton's modmult algorithm
# -DSMITH      use Smith's modmult
# See also the file platform.h for system defaults
#
# If you don't have a working FIONREAD ioctl you must use one of these:
# -DUSE_SELECT to use select() system call
# -DUSE_NBIO   to use non-blocking read()

EXE = .exe
LIB = .olb
OBJ = .obj


PROJ    = pgp$(EXE)

all : $(PROJ)
	@ nl:

# For a pure MPILIB version, uncomment the following lines
### RSALIBS =
### RSAOBJS = rsaglue1$(OBJ)

# For an RSAREF version, uncomment the following lines
RSADI = [-.rsaref
RSADIR = $(RSADI)]
RSALIBDIR = $(RSADI).install.vax]
RSAINCDIR = $(RSADI).source]
RSALIBS = $(RSALIBDIR)rsaref$(LIB)
RSAOBJS = rsaglue2$(OBJ)
USADEF = /define = "USA"

.ifdef RSAINCDIR
INCCFL = /include_directory = $(RSAINCDIR)
.endif

# If you want to use MPILIB as a back end to RSAREF, uncomment this line:
#USEMPILIB = -DUSEMPILIB

ZIPOBJS= zbits$(OBJ) zdeflate$(OBJ) zfile_io$(OBJ) zglobals$(OBJ) \
	zinflate$(OBJ) zip$(OBJ) zipup$(OBJ) ztrees$(OBJ) zunzip$(OBJ) 

OBJ1 =  pgp$(OBJ) crypto$(OBJ) keymgmt$(OBJ) fileio$(OBJ) \
	mdfile$(OBJ) more$(OBJ) armor$(OBJ) mpilib$(OBJ) mpiio$(OBJ) \
	genprime$(OBJ) rsagen$(OBJ) random$(OBJ) idea$(OBJ) passwd$(OBJ) \
	md5$(OBJ) system$(OBJ) language$(OBJ) getopt$(OBJ) keyadd$(OBJ) \
	config$(OBJ) keymaint$(OBJ) charset$(OBJ) \
	randpool$(OBJ) noise$(OBJ)

OBJS_EXT = VAX$(OBJ)

OBJS =  $(OBJ1) $(ZIPOBJS) $(RSAOBJS) $(OBJS_EXT)

CFLAGS = $(CFLAGS) $(INCCFL) $(USADEF)  -
 /prefix_library_entries = except = (OPTARG, OPTERR, OPTIND, OPTOPT)


$(PROJ) : $(OBJS) $(RSALIBS)
	$(LINK) $(LINKFLAGS) /map $(MMS$SOURCE_LIST) /library

clean :
	- delete /nolog *$(OBJ);*, $(PROJ);*


## Dependencies ##

vax$(OBJ) : vax.mar

armor$(OBJ) : armor.c \
              mpilib.h usuals.h platform.h fileio.h mpiio.h \
              language.h pgp.h more.h armor.h crypto.h charset.h
charset$(OBJ) : charset.c \
                usuals.h language.h charset.h system.h
config$(OBJ) : config.c \
               usuals.h fileio.h pgp.h more.h armor.h config.h \
               charset.h
crypto$(OBJ) : crypto.c \
               mpilib.h usuals.h platform.h mpiio.h random.h \
               idea.h crypto.h keymgmt.h keymaint.h mdfile.h md5.h \
               fileio.h charset.h language.h pgp.h more.h armor.h \
               exitpgp.h zipup.h rsaglue.h
fileio$(OBJ) : fileio.c \
               random.h idea.h usuals.h mpilib.h platform.h mpiio.h \
               fileio.h language.h pgp.h more.h armor.h exitpgp.h \
               charset.h system.h
genprime$(OBJ) : genprime.c \
                 mpilib.h usuals.h platform.h genprime.h random.h \
                 idea.h
getopt$(OBJ) : getopt.c \
               getopt.h
idea$(OBJ) : idea.c \
             idea.h usuals.h
keyadd$(OBJ) : keyadd.c \
               mpilib.h usuals.h platform.h crypto.h fileio.h \
               keymgmt.h charset.h language.h pgp.h more.h armor.h \
               exitpgp.h keyadd.h keymaint.h
keymaint$(OBJ) : keymaint.c \
                 mpilib.h usuals.h platform.h random.h idea.h \
                 crypto.h fileio.h keymgmt.h keymaint.h mpiio.h \
                 charset.h language.h pgp.h more.h armor.h
keymgmt$(OBJ) : keymgmt.c \
                system.h mpilib.h usuals.h platform.h idea.h \
                random.h crypto.h fileio.h keymgmt.h rsagen.h \
                mpiio.h language.h pgp.h more.h armor.h md5.h \
                charset.h keymaint.h
language$(OBJ) : language.c \
                 usuals.h fileio.h language.h pgp.h more.h armor.h \
                 charset.h
md5$(OBJ) : md5.c \
            md5.h
	$(CC) $(CFLAGS) /nooptimize md5.c
mdfile$(OBJ) : mdfile.c \
               mpilib.h usuals.h platform.h mdfile.h md5.h \
               fileio.h language.h pgp.h more.h armor.h
more$(OBJ) : more.c \
             system.h mpilib.h usuals.h platform.h language.h \
             fileio.h pgp.h more.h armor.h charset.h
mpiio$(OBJ) : mpiio.c \
              mpilib.h usuals.h platform.h mpiio.h pgp.h more.h \
              armor.h
mpilib$(OBJ) : mpilib.c \
               mpilib.h usuals.h platform.h
	$(CC) $(CFLAGS) /warnings = (disable = (ALIGNEXT)) mpilib.c
passwd$(OBJ) : passwd.c \
               random.h idea.h usuals.h md5.h language.h pgp.h \
               more.h armor.h
pgp$(OBJ) : pgp.c \
            system.h mpilib.h usuals.h platform.h random.h \
            idea.h crypto.h fileio.h keymgmt.h language.h pgp.h \
            more.h armor.h exitpgp.h charset.h getopt.h config.h \
            keymaint.h keyadd.h rsaglue.h
random$(OBJ) : random.c \
               system.h random.h idea.h usuals.h language.h
rsagen$(OBJ) : rsagen.c \
               mpilib.h usuals.h platform.h genprime.h rsagen.h \
               random.h idea.h rsaglue.h
rsaglue$(OBJ) : rsaglue.c \
                mpilib.h mpiio.h pgp.h rsaglue.h
system$(OBJ) : system.c \
               exitpgp.h system.h charset.h mpilib.h
zbits$(OBJ) : zbits.c \
              zip.h ztailor.h ziperr.h
zdeflate$(OBJ) : zdeflate.c \
                 zunzip.h usuals.h system.h zip.h ztailor.h \
                 ziperr.h
zfile_io$(OBJ) : zfile_io.c \
                 zunzip.h usuals.h system.h
zglobals$(OBJ) : zglobals.c \
                 zip.h ztailor.h ziperr.h
zinflate$(OBJ) : zinflate.c \
                 zunzip.h usuals.h system.h exitpgp.h
zip$(OBJ) : zip.c \
            zip.h usuals.h fileio.h language.h pgp.h more.h \
            armor.h exitpgp.h
zipup$(OBJ) : zipup.c \
              zip.h ztailor.h ziperr.h zrevisio.h
ztrees$(OBJ) : ztrees.c \
               zip.h ztailor.h ziperr.h
zunzip$(OBJ) : zunzip.c \
               zunzip.h usuals.h system.h language.h
