#                                               29 November 2004.  SMS.
#
#    MMS or MMK description file for Wget 1.9.1c.
#
#    Targets:
#       CLEAN : Delete generated files.
#       EXE : [.<arch>]WGET.EXE executable.  (Default target.)
#       HELP : [.DOC]WGET.HLB help library.
#

# Object and executable files directory.  UTIME prefix quirk.

.ifdef VAX
ODIR = [.VAX]
ODIR_NAME = VAX.DIR
.endif

.ifdef ALPHA
ODIR = [.ALPHA]
ODIR_NAME = ALPHA.DIR
UTNP = , __UTC_UTIME
.endif

.ifdef IA64
ODIR = [.IA64]
ODIR_NAME = IA64.DIR
UTNP = , __UTC_UTIME
.endif

# Object files.

OBJS_NOSSL = -
 $(ODIR)CMPT.OBJ -
 $(ODIR)CONNECT.OBJ -
 $(ODIR)CONVERT.OBJ -
 $(ODIR)COOKIES.OBJ -
 $(ODIR)FTP.OBJ -
 $(ODIR)FTP-BASIC.OBJ -
 $(ODIR)FTP-LS.OBJ -
 $(ODIR)FTP-OPIE.OBJ -
 $(ODIR)GEN-MD5.OBJ -
 $(ODIR)GETOPT.OBJ -
 $(ODIR)GNU-MD5.OBJ -
 $(ODIR)HASH.OBJ -
 $(ODIR)HEADERS.OBJ -
 $(ODIR)HOST.OBJ -
 $(ODIR)HTML-PARSE.OBJ -
 $(ODIR)HTML-URL.OBJ -
 $(ODIR)HTTP.OBJ -
 $(ODIR)INIT.OBJ -
 $(ODIR)LOG.OBJ -
 $(ODIR)MAIN.OBJ -
 $(ODIR)NETRC.OBJ -
 $(ODIR)PROGRESS.OBJ -
 $(ODIR)RBUF.OBJ -
 $(ODIR)RECUR.OBJ -
 $(ODIR)RES.OBJ -
 $(ODIR)RETR.OBJ -
 $(ODIR)SAFE-CTYPE.OBJ -
 $(ODIR)SNPRINTF.OBJ -
 $(ODIR)URL.OBJ -
 $(ODIR)UTILS.OBJ -
 $(ODIR)VERSION.OBJ -
 $(ODIR)VMS.OBJ

.ifdef HPSSL                            # HPSSL
OBJS_SSL = $(ODIR)GEN_SSLFUNC.OBJ
.else                                   # HPSSL
.ifdef SSL                                 # SSL
OBJS_SSL = $(ODIR)GEN_SSLFUNC.OBJ
.else                                      # SSL
OBJS_SSL =
.endif                                     # SSL
.endif                                  # HPSSL

OBJS = $(OBJS_NOSSL) $(OBJS_SSL)

# Executable.

EXE = $(ODIR)WGET.EXE

# HELP library and source file.

HLB = [-.DOC]WGET.HLB
HLP = [-.DOC]WGET.HLP

# DEC C and LINK options.

### To enable the "-d" command-line debug option, add "ENABLE_DEBUG", as
### shown (or in CONFIG.H[_VMS]).

.ifdef DASHD
CDEFINES = "HAVE_CONFIG_H", "ENABLE_DEBUG"
.else
CDEFINES = "HAVE_CONFIG_H"
.endif

.ifdef MULTINET
IP_CDEFINES = , "MULTINET"
IP_OPT = wget_multinet.opt
IP_LINK_OPT = , $(IP_OPT) /OPTIONS
.endif

.ifdef DBG
CFLAGS_DBG = /debug /nooptimize
LINKFLAGS_DBG = /debug
.endif

.ifdef LIST
CFLAGS_LIST = /list = $(ODIR) /show = (all, nomessages)
LINKFLAGS_LIST = /map = $(ODIR) /cross_reference /full
.endif

.ifdef HPSSL                                    # HPSSL
SSL_CDEFINES = , "HAVE_SSL"
SSL_LINK_OPT = , WGET_SSL_HP.OPT /OPTIONS
.else                                           # HPSSL
.ifdef SSL                                         # SSL
SSL_CDEFINES = , "HAVE_SSL"
SSL_LINK_OPT = , WGET_SSL.OPT /OPTIONS
.else                                              # SSL
SSL_CDEFINES =
SSL_LINK_OPT = 
.endif                                             # SSL
.endif                                          # HPSSL

CFLAGS = -
 $(CFLAGS_DBG) $(CFLAGS_LIST) -
 /define = ($(CDEFINES) $(IP_CDEFINES) $(SSL_CDEFINES), -
 "OS_TYPE=""VMS $(VMS_VERS)""") -
 /include = [] -
 /object = $(ODIR) -
 /prefix = (all, except = -
 (getopt, optarg, opterr, optind, optopt, utime $(UTNP)))

LINKFLAGS = $(LINKFLAGS_DBG) $(LINKFLAGS_LIST) -
 /executable = $(ODIR)

# Create the object and executable directory, if needed.
.first
	@ if ("$(ODIR)" .eqs. "none") then -
	 write sys$output "   Use VMS-WGET.COM to define the"+ -
	 " required MMK or MMS macros."
	@ if ("$(ODIR)" .eqs. "none") then -
	 write sys$output "   It will then run MMS (or MMK)."
	@ if ("$(ODIR)" .eqs. "none") then exit
	if (f$search( "$(ODIR_NAME)") .eqs. "") then -
	 create /directory /log $(ODIR)

# Link the executable (default target).

EXE : $(EXE)
	@ write sys$output ""
	@ write sys$output "   ""$<"" is ready."
	@ write sys$output ""

$(EXE) : $(OBJS) wget.opt $(IP_OPT)
	define /user_mode odir $(ODIR)
	$(LINK) $(LINKFLAGS) wget.opt /options $(IP_LINK_OPT) -
	 $(SSL_LINK_OPT)

# Create the HELP library (HELP target).

HELP : $(HLB)
	@ write sys$output ""
	@ write sys$output "   ""$<"" is ready."
	@ write sys$output ""

$(HLB) : $(HLP)
	LIBRARY /CREATE /HELP $@ $<

# Delete the object and executable files (optional target).

CLEAN :
	if (f$search( "$(ODIR)*.lis") .nes. "") then -
	 delete /log /noconfirm $(ODIR)*.lis;*
	if (f$search( "$(ODIR)*.map") .nes. "") then -
	 delete /log /noconfirm $(ODIR)*.map;*
	if (f$search( "$(ODIR)*.obj") .nes. "") then -
	 delete /log /noconfirm $(ODIR)*.obj;*
	if (f$search( "$(ODIR)*.exe") .nes. "") then -
	 delete /log /noconfirm $(ODIR)*.exe;*

# Use the VMS "config.h".

config.h : config.h_vms
	backup /log /new_version config.h_vms;0 config.h

# Object code.  (Default rule is fine.)

$(ODIR)cmpt.obj : cmpt.c -
                  config.h options.h safe-ctype.h sysdep.h wget.h

$(ODIR)connect.obj : connect.c -
                     config.h connect.h host.h options.h safe-ctype.h -
                     sysdep.h wget.h utils.h

$(ODIR)convert.obj : convert.c -
                     config.h convert.h hash.h options.h recur.h -
                     url.h utils.h wget.h

$(ODIR)cookies.obj : cookies.c -
                     config.h cookies.h hash.h options.h safe-ctype.h -
                     sysdep.h wget.h url.h utils.h

$(ODIR)ftp-basic.obj : ftp-basic.c -
                       config.h connect.h ftp.h host.h options.h -
                       rbuf.h safe-ctype.h sysdep.h utils.h wget.h

$(ODIR)ftp-ls.obj : ftp-ls.c -
                    config.h ftp.h host.h options.h rbuf.h -
                    safe-ctype.h sysdep.h url.h utils.h vms.h wget.h

$(ODIR)ftp-opie.obj : ftp-opie.c -
                      config.h gen-md5.h options.h safe-ctype.h -
                      sysdep.h wget.h

$(ODIR)ftp.obj : ftp.c -
                 config.h connect.h ftp.h host.h netrc.h -
                 options.h rbuf.h retr.h safe-ctype.h sysdep.h -
                 url.h utils.h vms.h vms_ip.h wget.h

$(ODIR)gen-md5.obj : gen-md5.c -
                     config.h gen-md5.h options.h safe-ctype.h -
                     sysdep.h wget.h

$(ODIR)gen_sslfunc.obj : gen_sslfunc.c -
                     config.h connect.h url.h utils.h wget.h

$(ODIR)getopt.obj : getopt.c -
                    config.h getopt.h options.h safe-ctype.h sysdep.h -
                    wget.h

$(ODIR)gnu-md5.obj : gnu-md5.c -
                     config.h gnu-md5.h options.h safe-ctype.h -
                     sysdep.h wget.h

$(ODIR)hash.obj : hash.c -
                  config.h hash.h options.h safe-ctype.h sysdep.h -
                  utils.h wget.h

$(ODIR)headers.obj : headers.c -
                     config.h connect.h headers.h host.h options.h -
                     rbuf.h safe-ctype.h sysdep.h wget.h

$(ODIR)host.obj : host.c -
                  config.h hash.h host.h options.h safe-ctype.h -
                  sysdep.h url.h utils.h vms_ip.h wget.h

$(ODIR)html-parse.obj : html-parse.c -
                        config.h html-parse.h options.h safe-ctype.h -
                        sysdep.h wget.h

$(ODIR)html-url.obj : html-url.c -
                      config.h html-parse.h options.h safe-ctype.h -
                      sysdep.h url.h utils.h wget.h

$(ODIR)http.obj : http.c -
                  config.h connect.h cookies.h ftp.h gen-md5.h -
                  gen_sslfunc.h headers.h host.h netrc.h options.h -
                  rbuf.h retr.h safe-ctype.h sysdep.h url.h utils.h -
                  vms_ip.h wget.h

$(ODIR)init.obj : init.c -
                  config.h cookies.h host.h init.h netrc.h options.h -
                  progress.h recur.h safe-ctype.h sysdep.h utils.h -
                  wget.h

$(ODIR)log.obj : log.c -
                 config.h options.h safe-ctype.h sysdep.h utils.h -
                 wget.h

$(ODIR)main.obj : main.c -
                  config.h cookies.h gen_sslfunc.h getopt.h host.h -
                  init.h options.h progress.h rbuf.h recur.h retr.h -
                  safe-ctype.h sysdep.h url.h utils.h vms.h wget.h

$(ODIR)netrc.obj : netrc.c -
                   config.h init.h netrc.h options.h safe-ctype.h -
                   sysdep.h utils.h wget.h

$(ODIR)progress.obj : progress.c -
                      config.h options.h progress.h rbuf.h retr.h -
                      safe-ctype.h sysdep.h utils.h wget.h

$(ODIR)rbuf.obj : rbuf.c -
                  config.h connect.h gen_sslfunc.h host.h options.h -
                  rbuf.h safe-ctype.h sysdep.h wget.h

$(ODIR)recur.obj : recur.c -
                   config.h ftp.h hash.h host.h rbuf.h options.h -
                   recur.h retr.h safe-ctype.h sysdep.h url.h utils.h -
                   wget.h

$(ODIR)res.obj : res.c -
                 config.h hash.h options.h rbuf.h res.h retr.h -
                 safe-ctype.h sysdep.h url.h utils.h wget.h 

$(ODIR)retr.obj : retr.c -
                  config.h connect.h ftp.h gen_sslfunc.h hash.h host.h -
                  options.h rbuf.h recur.h retr.h safe-ctype.h -
                  sysdep.h url.h utils.h wget.h

$(ODIR)snprintf.obj : snprintf.c -
                      config.h safe-ctype.h

$(ODIR)safe-ctype.obj : safe-ctype.c -
                        config.h safe-ctype.h

$(ODIR)url.obj : url.c -
                 config.h hash.h host.h options.h safe-ctype.h -
                 sysdep.h url.h utils.h wget.h

$(ODIR)utils.obj : utils.c -
                   config.h hash.h options.h safe-ctype.h sysdep.h -
                   utils.h vms.h wget.h

$(ODIR)version.obj : version.c

$(ODIR)vms.obj : vms.c -
                 config.h options.h vms.h wget.h

