#                                               8 March 2007.  SMS.
#
#    GnuPG for VMS - MMS (or MMK) Description File.
#
# Usage:
#
#    SET DEFAULT [.directory]
#    MMS /DESCRIPTION = [-.VMS] [/MACRO = (<see_below>)] target
#
# Optional macros:
#
#    CCOPTS=xxx     Compile with CC options xxx.  For example:
#                   CCOPTS=/ARCH=HOST
#
#    CDEFS_USER=xxx  Compile with C macro definition(s) xxx.
#
#    DBG=1          Compile with /DEBUG /NOOPTIMIZE.
#                   Link with /DEBUG /TRACEBACK.
#                   (Default is /NOTRACEBACK.)
#
#    GPG_BZIP2=dev:[dir]  BZIP2 files location, to enable bzip2
#                         compression support.  ("dev:[dir]" should
#                   specify the top-level bzip2 directory, which
#                   contains the bzlib.h header file.  A logical name
#                   may be specified instead of an explicit
#                   "dev:[dir]".)
#
#    GPG_CURL=dev:[dir]  CURL files location, to enable use of the cURL
#                        library for the keyserver programs. 
#                   ("dev:[dir]" should specify the top-level cURL
#                   directory, which contains the [.INCLUDE] and
#                   [.PACKAGES] directories.  A logical name may be
#                   specified instead of an explicit "dev:[dir]".)
#
#    GPG_HPSSL=1    Required if GPG_CURL points to a cURL library which
#                   was built for HP SSL.  (This enables the use, where
#                   needed, of a link options file which specifies the
#                   HP SSL shareable images.)
#
#    GPG_LDAP=1     Enable LDAP support.
#
#    LARGE=1        Enable large-file (>2GB) support.  Non-VAX only.
#
#    LINKOPTS=xxx   Link with LINK options xxx.  For example:
#                   LINKOPTS=/NOINFO   
#
#    LIST=1         Compile with /LIST /SHOW = (ALL, NOMESSAGES).
#                   Link with /MAP /CROSS_REFERENCE /FULL.
#
#
# The default target, ALL, builds the selected product executables and
# help files.
#
# Other targets:
#
#    CLEAN      deletes architecture-specific files, but leaves any
#               individual source dependency files and the help files.
#
#    CLEAN_ALL  deletes all generated files, except the main (collected)
#               source dependency files.
#
#    CLEAN_EXE  deletes only the architecture-specific executables. 
#               Handy if all you wish to do is re-link the executables.
#
#    CLEAN_OLB  deletes only the architecture-specific object libraries. 
#
# Example commands:
#
# To build the conventional small-file product using the DEC/Compaq/HP C
# compiler (Note: DESCRIP.MMS is the default description file name.):
#
#    MMS
#
# To get the large-file executables (on a non-VAX system):
#
#    MMS /MACRO = (LARGE=1)
#
# To get the large-file executables (on a non-VAX system) with bzip2 and
# cURL support (assuming that the logical names GPG_BZIP2 and GPG_CURL
# have been defined appropriately):
#
#    MMS /MACRO = (LARGE=1, GPG_BZIP2=GPG_BZIP2, GPG_CURL=GPG_CURL)
#
# To delete the architecture-specific generated files for this system
# type:
#
#    MMS /MACRO = (LARGE=1) CLEAN       ! Large-file.
# or
#    MMS CLEAN                          ! Small-file.
#
# To build a complete small-file product for debug with compiler
# listings and link maps:
#
#    MMS CLEAN
#    MMS /MACRO = (DBG=1, LIST=1)
#
########################################################################

# Include primary product description file.

INCL_DESCRIP_SRC = 1
.INCLUDE DESCRIP_SRC.MMS


# TARGETS.

# Default subsidiary targets.


# Build CHECKS.

.IFDEF AM_IN_CHECKS             # AM_IN_CHECKS

SUBSIDIARY = 1

INCL_DESCRIP_CHECKS = 1
.INCLUDE DESCRIP_CHECKS.MMS

.ENDIF                          # AM_IN_CHECKS


# Build CIPHER object library.

.IFDEF AM_IN_CIPHER             # AM_IN_CIPHER

SUBSIDIARY = 1

LIBCIPHER : $(LIB_CIPHER)
	@ write sys$output ""
	@ write sys$output "   LIBCIPHER done."
	@ write sys$output ""

.ENDIF                          # AM_IN_CIPHER


# Build G10 object library or GPG[V] executable.

.IFDEF AM_IN_G10                # AM_IN_G10

SUBSIDIARY = 1

# Object library.

LIBG10 : $(LIB_G10)
	@ write sys$output ""
	@ write sys$output "   LIBG10 done."
	@ write sys$output ""

# GPG executable.

$(GPG_EXE) : $(GPG_OBJ) \
             $(LIB_CIPHER) $(LIB_G10) $(LIB_INTL) $(LIB_MPI) \
             $(LIB_UTIL) $(LIB_VMS) $(LIB_ZLIB) \
             $(LIB_BZIP2) $(LIB_CURL) \
             $(OPT_LDAP) $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPG_OBJ) -
	 , sys$disk:$(LIB_G10) /library -
	 , sys$disk:$(LIB_CIPHER) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_MPI) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = vms -
	 , sys$disk:$(LIB_ZLIB) /library -
	 $(LIB_BZIP2_QUAL) -
	 $(LIB_CURL_QUAL) -
	 $(OPT_LDAP_QUAL) -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

# GPGV executable.

$(GPGV_EXE) : $(GPGV_OBJ) \
              $(LIB_CIPHER) $(LIB_G10) $(LIB_INTL) $(LIB_MPI) \
              $(LIB_UTIL) $(LIB_VMS) $(LIB_ZLIB) \
              $(LIB_BZIP2) $(LIB_CURL) \
              $(OPT_LDAP) $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGV_OBJ) -
	 , sys$disk:$(LIB_G10) /library -
	 , sys$disk:$(LIB_CIPHER) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_MPI) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = vms -
	 , sys$disk:$(LIB_ZLIB) /library -
	 $(LIB_BZIP2_QUAL) -
	 $(LIB_CURL_QUAL) -
	 $(OPT_LDAP_QUAL) -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

.ENDIF                          # AM_IN_G10


# Build INTL object library.

.IFDEF AM_IN_INTL               # AM_IN_INTL

SUBSIDIARY = 1

LIBINTL : $(LIB_INTL)
	@ write sys$output ""
	@ write sys$output "   LIBINTL done."
	@ write sys$output ""

.ENDIF                          # AM_IN_INTL


# Build KEYSERVER object library or GPGKEYS_* executable.

.IFDEF AM_IN_KEYSERVER          # AM_IN_KEYSERVER

SUBSIDIARY = 1

# Object libraries.

LIBKEYSERVER : $(LIB_KEYSERVER_FC) $(LIB_KEYSERVER_RC)
	@ write sys$output ""
	@ write sys$output "   LIBKEYSERVER_{F|R}C done."
	@ write sys$output ""

# GPGKEYS executables.

.IFDEF GPG_CURL                     # GPG_CURL

$(GPGKEYS_CURL_RC_EXE) : $(GPGKEYS_CURL_RC_OBJ) \
                         $(LIB_INTL) $(LIB_KEYSERVER_RC) \
                         $(LIB_UTIL) $(LIB_VMS) \
                         $(OPT_SSL) $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_CURL_RC_OBJ) -
	 $(LIB_CURL_QUAL) -
	 , sys$disk:$(LIB_KEYSERVER_RC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(OPT_SSL_QUAL) -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

$(GPGKEYS_HKP_RC_EXE) : $(GPGKEYS_HKP_RC_OBJ) \
                        $(LIB_INTL) $(LIB_KEYSERVER_RC) \
                        $(LIB_UTIL) $(LIB_VMS) \
                        $(OPT_SSL) $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_HKP_RC_OBJ) -
	 $(LIB_CURL_QUAL) -
	 , sys$disk:$(LIB_KEYSERVER_RC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(OPT_SSL_QUAL) -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

.ENDIF                              # GPG_CURL [else]

.IFDEF GPG_LDAP                     # GPG_LDAP

$(GPGKEYS_LDAP_EXE) : $(GPGKEYS_LDAP_OBJ) \
                      $(LIB_INTL) $(LIB_KEYSERVER_FC) \
                      $(LIB_UTIL) $(LIB_VMS) \
                      $(OPT_LDAP) $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_LDAP_OBJ) -
	 , $(LIB_KEYSERVER_FC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(OPT_LDAP_QUAL) -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

.ENDIF                              # GPG_LDAP

$(GPGKEYS_CURL_EXE) : $(GPGKEYS_CURL_OBJ) \
                      $(LIB_INTL) $(LIB_KEYSERVER_FC) \
                      $(LIB_UTIL) $(LIB_VMS) \
                      $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_CURL_OBJ) -
	 , $(LIB_KEYSERVER_FC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = vms -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

$(GPGKEYS_FINGER_EXE) : $(GPGKEYS_FINGER_OBJ) \
                        $(LIB_INTL) $(LIB_KEYSERVER_FC) \
                        $(LIB_UTIL) $(LIB_VMS) \
                        $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_FINGER_OBJ) -
	 , sys$disk:$(LIB_KEYSERVER_FC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = vms -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

$(GPGKEYS_HKP_EXE) : $(GPGKEYS_HKP_OBJ) \
                     $(LIB_INTL) $(LIB_KEYSERVER_FC) \
                     $(LIB_UTIL) $(LIB_VMS) \
                     $(OPT_TCPIP)
	$(LINK) $(LINKFLAGS) -
	 $(GPGKEYS_HKP_OBJ) -
	 , sys$disk:$(LIB_KEYSERVER_FC) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = vms -
	 $(OPT_TCPIP_QUAL) -
	 $(LFLAGS_ARCH)

.ENDIF                          # AM_IN_KEYSERVER


# Build MPI object library.

.IFDEF AM_IN_MPI                # AM_IN_MPI

SUBSIDIARY = 1

LIBMPI : $(LIB_MPI)
	@ write sys$output ""
	@ write sys$output "   LIBMPI done."
	@ write sys$output ""

.ENDIF                          # AM_IN_MPI


# Build TOOLS executables.

.IFDEF AM_IN_TOOLS              # AM_IN_TOOLS

SUBSIDIARY = 1

# BFTEST executable.

$(BFTEST_EXE) : $(BFTEST_OBJ) \
                $(LIB_CIPHER) $(LIB_INTL) \
                $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(BFTEST_OBJ) -
	 , sys$disk:$(LIB_CIPHER) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 $(LFLAGS_ARCH)

# CLEAN-SAT executable.

$(CLEAN_SAT_EXE) : $(CLEAN_SAT_OBJ) \
                   $(LIB_INTL) $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(CLEAN_SAT_OBJ) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(LFLAGS_ARCH)

# GPGSPLIT executable.

$(GPGSPLIT_EXE) : $(GPGSPLIT_OBJ) \
                  $(LIB_INTL) $(LIB_UTIL) $(LIB_VMS) $(LIB_ZLIB) \
                  $(LIB_BZIP2)
	$(LINK) $(LINKFLAGS) -
	 $(GPGSPLIT_OBJ) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_ZLIB) /library -
	 $(LIB_BZIP2_QUAL) -
	 $(LFLAGS_ARCH)

# MAKE-DNS-CERT executable.

$(MAKE_DNS_CERT_EXE) : $(MAKE_DNS_CERT_OBJ) \
                       $(LIB_INTL) $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(MAKE_DNS_CERT_OBJ) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(LFLAGS_ARCH)

# MK-TDATA executable.

$(MK_TDATA_EXE) : $(MK_TDATA_OBJ) \
                  $(LIB_INTL) $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(MK_TDATA_OBJ) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 $(LFLAGS_ARCH)

# MPICALC executable.

$(MPICALC_EXE) : $(MPICALC_OBJ) \
                 $(LIB_CIPHER) $(LIB_INTL) $(LIB_MPI) \
                 $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(MPICALC_OBJ) -
	 , sys$disk:$(LIB_CIPHER) /library -
	 , sys$disk:$(LIB_MPI) /library -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 $(LFLAGS_ARCH)

# SHMTEST executable.

$(SHMTEST_EXE) : $(SHMTEST_OBJ) \
                 $(LIB_INTL) $(LIB_UTIL) $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(SHMTEST_OBJ) -
	 , sys$disk:$(LIB_UTIL) /library -
	 , sys$disk:$(LIB_INTL) /library -
	 , sys$disk:$(LIB_VMS) /library /include = (mlock_vms, vms) -
	 , sys$disk:$(LIB_UTIL) /library -
	 $(LFLAGS_ARCH)

.ENDIF                          # AM_IN_TOOLS


# Build UTIL object library.

.IFDEF AM_IN_UTIL               # AM_IN_UTIL

SUBSIDIARY = 1

LIBUTIL : $(LIB_UTIL)
	@ write sys$output ""
	@ write sys$output "   LIBUTIL done."
	@ write sys$output ""

.ENDIF                          # AM_IN_UTIL


# Build VMS object library or DECC_VER executable.

.IFDEF AM_IN_VMSLIB             # AM_IN_VMSLIB

SUBSIDIARY = 1

LIBUTIL : $(LIB_VMS)
	@ write sys$output ""
	@ write sys$output "   LIBVMS done."
	@ write sys$output ""

# DECC_VER executable.

$(DECC_VER_EXE) : $(LIB_VMS)
	$(LINK) $(LINKFLAGS) -
	 $(LIB_VMS) /library /include = decc_ver -
	 $(LFLAGS_ARCH)

.ENDIF                          # AM_IN_VMSLIB


# Build ZLIB object library.

.IFDEF AM_IN_ZLIB               # AM_IN_ZLIB

SUBSIDIARY = 1

LIBZLIB : $(LIB_ZLIB)
	@ write sys$output ""
	@ write sys$output "   ZLIB done."
	@ write sys$output ""

.ENDIF                          # AM_IN_ZLIB



# Build some system-dependent header files.

.IFDEF AM_IN_INC                # AM_IN_INC

SUBSIDIARY = 1

INC : $(ALIGN_H) $(AVOFFSET_H)
	@ write sys$output ""
	@ write sys$output "   INC done."
	@ write sys$output ""

.ENDIF                          # AM_IN_INC


# Executables.

EXES = $(DECC_VER_EXE) $(EXES_G10) $(EXES_KEYSERVER) $(EXES_TOOLS)


# Default global target.

ALL : $(EXES) $(PREP_TIMESTAMP)
	@ write sys$output ""
	@ show time
	@ write sys$output ""
	@ write sys$output "   ALL done."
	@ write sys$output ""



# CLEAN target.  Delete the [.$(DEST)] directory and everything in it.

.IFDEF SUBSIDIARY               # SUBSIDIARY

CLEAN :
	if (f$search( "[.$(DEST)]*.*") .nes. "") then -
	 delete [.$(DEST)]*.*;*
	if (f$search( "$(DEST).dir", 1) .nes. "") then -
	 set protection = w:d $(DEST).dir;*
	if (f$search( "$(DEST).dir", 2) .nes. "") then -
	 delete $(DEST).dir;*

# CLEAN_ALL target.  Delete:
#    The [...$(DEST)] directories and everything in them.
#    All individual C dependency files.
#    Generated/VMS-specific header files.
# Also mention:
#    Comprehensive dependency file.

CLEAN_ALL :
	@ write sys$output "   SUBSIDIARY - CLEAN_ALL"
	show default
	if (f$search( "[...ALPHA*]*.*") .nes. "") then -
	 delete /log [...ALPHA*]*.*;*
	if (f$search( "[...]ALPHA*.dir", 1) .nes. "") then -
	 set protection = w:d [...]ALPHA*.dir;*
	if (f$search( "[...]ALPHA*.dir", 2) .nes. "") then -
	 delete /log [...]ALPHA*.dir;*
	if (f$search( "[...IA64*]*.*") .nes. "") then -
	 delete /log [...IA64*]*.*;*
	if (f$search( "[...]IA64*.dir", 1) .nes. "") then -
	 set protection = w:d [...]IA64*.dir;*
	if (f$search( "[...]IA64*.dir", 2) .nes. "") then -
	 delete /log [...]IA64*.dir;*
	if (f$search( "[...VAX*]*.*") .nes. "") then -
	 delete /log [...VAX*]*.*;*
	if (f$search( "[...]VAX*.dir", 1) .nes. "") then -
	 set protection = w:d [...]VAX*.dir;*
	if (f$search( "[...]VAX*.dir", 2) .nes. "") then -
	 delete /log [...]VAX*.dir;*
	if (f$search( "[...]*.MMSD") .nes. "") then -
	 delete /log [...]*.MMSD;*
	if (f$search( "$(CONFIG_H)") .nes. "") then -
	 delete /log /noconfirm $(CONFIG_H);*
	if (f$search( "$(LIBGNUINTL_H)") .nes. "") then -
	 delete /log /noconfirm $(LIBGNUINTL_H);*
	if (f$search( "$(LIBINTL_H)") .nes. "") then -
	 delete /log /noconfirm $(LIBINTL_H);*
	@ write sys$output ""
	@ write sys$output "Note:  This procedure will not"
	@ write sys$output "   DELETE DESCRIP_DEPS.MMS;*"
	@ write sys$output -
 "You may choose to, but a recent version of MMS (V3.5 or newer?) is"
	@ write sys$output -
 "needed to regenerate it.  (It may also be recovered from the original"
	@ write sys$output -
 "distribution kit.)  See DESCRIP_MKDEPS.MMS for instructions on"
	@ write sys$output -
 "generating DESCRIP_DEPS.MMS."
	@ write sys$output ""

# CLEAN_EXE target.  Delete the executables in [.$(DEST)].

CLEAN_EXE :
	if (f$search( "[.$(DEST)]*.EXE") .nes. "") then -
	 delete [.$(DEST)]*.EXE;*

# CLEAN_OLB target.  Delete the object libraries in [.$(DEST)].

CLEAN_OLB :
	if (f$search( "[.$(DEST)]*.OLB") .nes. "") then -
	 delete [.$(DEST)]*.OLB;*

.ELSE                           # SUBSIDIARY

.IFDEF MMSTARGETS                   # MMSTARGETS

#
# MMS (or MMK) with the MMSTARGETS macro needs only one real CLEAN rule.
#

CLEAN, CLEAN_ALL, CLEAN_EXE, CLEAN_OLB :
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)

.ELSE                               # MMSTARGETS

#
# MMK without the MMSTARGETS macro needs more rules.
#

CLEAN :
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

CLEAN_ALL :
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

CLEAN_EXE :
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

CLEAN_OLB :
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                              # MMSTARGETS [else]

.ENDIF                          # SUBSIDIARY


DEFAULT :
	@ write sys$output "No target, specified or default."


# Generated header files.

.IFDEF AM_IN_CHECKS             # AM_IN_CHECKS
.ELSE                           # AM_IN_CHECKS
INCL_CONFIG_SRC = 1
.INCLUDE [-.VMS]DESCRIP_CONFIG.MMS
.ENDIF                          # AM_IN_CHECKS [else]


# Global rules, and object library module dependencies.

# CHECKS (incomplete).

.IFDEF AM_IN_CHECKS             # AM_IN_CHECKS

checks_prep : $(PREP_TIMESTAMP)
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_CHECKS

$(PREP_TIMESTAMP) :
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CHECKS)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_CHECKS [else]


# LIBCIPHER object library.

.IFDEF AM_IN_CIPHER             # AM_IN_CIPHER

$(LIB_CIPHER) : $(GENERATED_HEADERS) $(LIB_CIPHER)($(MODS_OBJS_LIB_CIPHER))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_CIPHER

$(LIB_CIPHER) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_CIPHER)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_CIPHER [else]


# GPG[V] executables and LIBG10 object library.

.IFDEF AM_IN_G10                # AM_IN_G10

$(LIB_G10) : $(GENERATED_HEADERS) $(LIB_G10)($(MODS_OBJS_LIB_G10))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_G10

$(LIB_G10) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

$(GPG_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(GPGV_EXE) : $(GENERATED_HEADERS) 
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                          # AM_IN_G10 [else]


# LIBINTL object library.

.IFDEF AM_IN_INTL               # AM_IN_INTL

$(LIB_INTL) : $(GENERATED_HEADERS) $(LIB_INTL)($(MODS_OBJS_LIB_INTL))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_INTL

$(LIB_INTL) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_INTL [else]


# GPGKEYS_* executables and LIBKEYSERVER object library.

.IFDEF AM_IN_KEYSERVER          # AM_IN_KEYSERVER

$(LIB_KEYSERVER_FC) : $(GENERATED_HEADERS) \
                   $(LIB_KEYSERVER_FC)($(MODS_OBJS_LIB_KEYSERVER_FC))
	@ write sys$output "$(MMS$TARGET) updated."

$(LIB_KEYSERVER_RC) : $(GENERATED_HEADERS) \
                   $(LIB_KEYSERVER_RC)($(MODS_OBJS_LIB_KEYSERVER_RC))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_KEYSERVER

$(LIB_KEYSERVER_FC) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

$(LIB_KEYSERVER_RC) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.IFDEF GPG_CURL                     # GPG_CURL

$(GPGKEYS_CURL_RC_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(GPGKEYS_HKP_RC_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                              # GPG_CURL

.IFDEF GPG_LDAP                     # GPG_LDAP

$(GPGKEYS_LDAP_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                              # GPG_LDAP

$(GPGKEYS_CURL_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(GPGKEYS_FINGER_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(GPGKEYS_HKP_EXE) : $(GENERATED_HEADERS) 
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                          # AM_IN_KEYSERVER [else]


# LIBMPI object library.

.IFDEF AM_IN_MPI                # AM_IN_MPI

$(LIB_MPI) : $(GENERATED_HEADERS) \
             $(LIB_MPI)($(MODS_OBJS_LIB_MPI) $(MODS_OBJS_LIB_MPI_GENERIC))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_MPI

$(LIB_MPI) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_MPI [else]


# TOOLS executables.

.IFDEF AM_IN_TOOLS              # AM_IN_TOOLS
.ELSE                           # AM_IN_TOOLS

$(BFTEST_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(CLEAN_SAT_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(GPGSPLIT_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(MAKE_DNS_CERT_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(MK_TDATA_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(MPICALC_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

$(SHMTEST_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)

.ENDIF                          # AM_IN_TOOLS [else]


# LIBUTIL object library.

.IFDEF AM_IN_UTIL               # AM_IN_UTIL

$(LIB_UTIL) : $(GENERATED_HEADERS) $(LIB_UTIL)($(MODS_OBJS_LIB_UTIL))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_UTIL

$(LIB_UTIL) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_UTIL [else]


# DECC_VER executable and LIBVMS object library.

.IFDEF AM_IN_VMSLIB             # AM_IN_VMSLIB

$(LIB_VMS) : $(GENERATED_HEADERS) $(LIB_VMS)($(MODS_OBJS_LIB_VMS))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_VMSLIB

$(LIB_VMS) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

$(DECC_VER_EXE) : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(DECC_VER_EXE)

.ENDIF                          # AM_IN_VMSLIB [else]


# ZLIB object library.

.IFDEF AM_IN_ZLIB               # AM_IN_ZLIB

$(LIB_ZLIB) : $(LIB_ZLIB)($(MODS_OBJS_LIB_ZLIB))
	@ write sys$output "$(MMS$TARGET) updated."

.ELSE                           # AM_IN_ZLIB

$(LIB_ZLIB) : $(GENERATED_HEADERS)
	dev_dir = f$environment( "DEFAULT")
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMS$TARGET)
	set default 'dev_dir'
	show default

.ENDIF                          # AM_IN_ZLIB [else]


# Default C compile rule.

.C.OBJ :
	$(CC) $(CFLAGS) /define = ($(CDEFS)) $(MMS$SOURCE)

.IFDEF __VAX__                  # __VAX__


# Special rules for modules on VAX where Compaq C V6.4-005 (like,
# probably, other versions) loops with /optimize = disjoint.

[.$(DEST)]CAST5.OBJ : [-.CIPHER]CAST5.C
	@ write sys$output "***************************************"
	@ write sys$output "* Note: Exceptional rule in use here: *"
	@ write sys$output "***************************************"
	$(CC) $(CFLAGS) /optimize = nodisjoint /define = ($(CDEFS)) -
	 $(MMS$SOURCE)

[.$(DEST)]DES.OBJ : [-.CIPHER]DES.C
	@ write sys$output "***************************************"
	@ write sys$output "* Note: Exceptional rule in use here: *"
	@ write sys$output "***************************************"
	$(CC) $(CFLAGS) /optimize = nodisjoint /define = ($(CDEFS)) -
	 $(MMS$SOURCE)

[.$(DEST)]RMD160.OBJ : [-.CIPHER]RMD160.C
	@ write sys$output "***************************************"
	@ write sys$output "* Note: Exceptional rule in use here: *"
	@ write sys$output "***************************************"
	$(CC) $(CFLAGS) /optimize = nodisjoint /define = ($(CDEFS)) -
	 $(MMS$SOURCE)

.ENDIF                          # __VAX__


# Include generated source dependencies.

.IFDEF SUBSIDIARY               # SUBSIDIARY
INCL_DESCRIP_DEPS = 1
.INCLUDE DESCRIP_DEPS.MMS
.ENDIF                          # SUBSIDIARY


# Special rules file.

.IFDEF INCLUDE_DESCRIP_RULES    # INCLUDE_DESCRIP_RULES
INCL_DESCRIP_RULES = 1
.INCLUDE DESCRIP_RULES.MMS
.ENDIF                          # INCLUDE_DESCRIP_RULES

