#                                               21 December 2007.  SMS.
#
#    GnuPG for VMS - MMS Dependency Description File.
#
#    MMS /EXTENDED_SYNTAX description file to generate C source
#    dependency files.  Unsightly errors result when /EXTENDED_SYNTAX
#    is not specified.  Typical usage (but see below for details):
#
#    $ MMS /EXTEND /DESCRIP = [-.VMS]DESCRIP_MKDEPS.MMS /SKIP -
#       /MACRO = (GPG_BZIP2=dev:[dir], GPG_CURL=dev:[dir], GPG_LDAP=1)
#
#    which discards individual source dependency files, or:
#
#    $ MMS /EXTEND /DESCRIP = [-.VMS]DESCRIP_MKDEPS.MMS -
#       /MACRO = (GPG_BZIP2=dev:[dir], GPG_CURL=dev:[dir], GPG_LDAP=1, -
#       NOSKIP=1)
#
#    which retains them.  Retaining them can save time when doing code
#    development.
#
#
# The default target is the comprehensive source dependency file,
# $(DEPS_FILE) = "DESCRIP_DEPS.MMS".
#
# Other targets:
#
#    CLEAN      deletes the individual source dependency files,
#               *.MMSD;*, but leaves the comprehensive source dependency
#               file.
#
#    CLEAN_ALL  deletes all source dependency files, including the
#               individual *.MMSD;* files and the comprehensive file,
#               DESCRIP_DEPS.MMS.*.
#
#
# Note that [.G10]COMPRESS-BZ2.C is included in the build only if the
# optional bzip2 support is enabled.  Thus to create the most general
# dependency files (which will allow the build to work when bzip2
# support is enabled), the GPG_BZIP2 MMS macro must be included in the
# MMS command line.  If new dependncies must be generated but no bzip2
# kit is available, the GPG_BZIP2 MMS macro may be omitted, but the
# resulting dependency files will not work if, later, bzip2 support is
# specified.
#
# See [.VMS]DESCRIP.MMS for more details on the GPG_BZIP2 MMS macro.
#
#
# MMK users without MMS will be unable to generate the dependencies file
# using this description file, however there should be one supplied in
# the kit.  If this file has been deleted, users in this predicament
# will need to recover it from the original distribution kit.
#
# Note:  This dependency generation scheme assumes that the dependencies
# do not depend on host architecture type or other such variables. 
# Therefore, no "#include" directive in the C source itself should be
# conditional on such variables.
#
# This description file uses this command procedures:
#
#    [-.VMS]COLLECT_DEPS.COM
#    [-.VMS]MOD_DEP.COM
#

# Required command procedures.

COLLECT_DEPS = [-.VMS]COLLECT_DEPS.COM
MOD_DEP = [-.VMS]MOD_DEP.COM

COMS = $(COLLECT_DEPS) $(MOD_DEP)

# Include the source file lists (among other data).

ENABLE_DEP_RULES = 1
INCL_DESCRIP_SRC = 1
.INCLUDE DESCRIP_SRC.MMS

# The ultimate individual product, a comprehensive dependency list.

DEPS_FILE = DESCRIP_DEPS.MMS

# Detect valid qualifier and/or macro options.

.IF $(FINDSTRING Skip, $(MMSQUALIFIERS)) .eq Skip
DELETE_MMSD = 1
.ELSIF NOSKIP
PURGE_MMSD = 1
.ELSE # [complex]
UNK_MMSD = 1
.ENDIF # [else, complex]

# Dependency suffixes and rules.
#
# .FIRST is assumed to be used already, so the MMS qualifier/macro check
# is included in each rule (one way or another).

.IFDEF MMSD_SUFFIX                  # MMSD_SUFFIX
.ELSE                               # MMSD_SUFFIX
MMSD_SUFFIX = 1
.SUFFIXES_BEFORE .C .MMSD
.ENDIF                              # MMSD_SUFFIX [else]

.C.MMSD :
.IF UNK_MMSD                        # UNK_MMSD
	@ write sys$output -
 "   /SKIP_INTERMEDIATES is expected on the MMS command line."
	@ write sys$output -
 "   For normal behavior (delete .MMSD files), specify ""/SKIP""."
	@ write sys$output -
 "   To retain the .MMSD files, specify ""/MACRO = NOSKIP=1""."
	@ exit %x00000004
.ENDIF                              # UNK_MMSD
	$(CC) $(CFLAGS_ARCH) $(CFLAGS_INCL) $(CFLAGS_SPEC) -
	 /define = ($(CDEFS)) $(MMS$SOURCE) -
	 /NOLIST /NOOBJECT  /MMS_DEPENDENCIES = (FILE = $(MMS$TARGET))

# List of MMS dependency files.

# In case it's not obvious...
# To extract module name lists from object library module=object lists:
# 1.  Transform "module=[.dest]name.OBJ" into "module=[.dest] name".
# 2.  For a subdirectory, add "[.subdir]".
# 3.  Delete "*]" words.

# Complete list of C object dependency file names.


#    CHECKS (dummy).
				
.IFDEF AM_IN_CHECKS                 # AM_IN_CHECKS

SUBSIDIARY = 1

DEPS =

.ENDIF                              # AM_IN_CHECKS


#    LIBCIPHER.
				
.IFDEF AM_IN_CIPHER                 # AM_IN_CIPHER

SUBSIDIARY = 1

MODS_LIB_CIPHER = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_CIPHER)))

DEPS = $(FOREACH NAME, $(MODS_LIB_CIPHER), $(NAME).MMSD)

.ENDIF                              # AM_IN_CIPHER


#    LIBG10.
				
.IFDEF MODS_OBJS_LIB_G10            # MODS_OBJS_LIB_G10

SUBSIDIARY = 1

MODS_EXE_G10 = $(FILTER-OUT *], \
 $(PATSUBST *]*.EXE, *] *, $(EXES_G10)))

MODS_LIB_G10 = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_G10)))

DEPS = $(FOREACH NAME, $(MODS_EXE_G10) $(MODS_LIB_G10), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_G10


#    LIBINTL.
				
.IFDEF MODS_OBJS_LIB_INTL           # MODS_OBJS_LIB_INTL

SUBSIDIARY = 1

MODS_LIB_INTL = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_INTL)))

DEPS = $(FOREACH NAME, $(MODS_LIB_INTL), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_INTL


#    LIBKEYSERVER.

.IFDEF MODS_OBJS_LIB_KEYSERVER_FC   # MODS_OBJS_LIB_KEYSERVER_FC

SUBSIDIARY = 1

MODS_EXE_KEYSERVER_FC = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_EXE_KEYSERVER_FC)))

MODS_LIB_KEYSERVER_FC = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_KEYSERVER_FC)))

.IFDEF GPG_CURL                         # GPG_CURL

MODS_EXE_KEYSERVER_RC = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_EXE_KEYSERVER_RC)))

MODS_LIB_KEYSERVER_RC = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_KEYSERVER_RC)))

.ENDIF                                  # GPG_CURL

DEPS = $(FOREACH NAME, \
 $(MODS_EXE_KEYSERVER_FC) $(MODS_EXE_KEYSERVER_RC) \
 $(MODS_LIB_KEYSERVER_FC) $(MODS_LIB_KEYSERVER_RC), \
 $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_KEYSERVER_FC


#    LIBMPI.
				
.IFDEF MODS_OBJS_LIB_MPI            # MODS_OBJS_LIB_MPI

SUBSIDIARY = 1

MODS_LIB_MPI = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_MPI)))

MODS_LIB_MPI_GENERIC = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] [.generic]*, $(MODS_OBJS_LIB_MPI_GENERIC)))

DEPS = $(FOREACH NAME, $(MODS_LIB_MPI) $(MODS_LIB_MPI_GENERIC), \
 $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_MPI


#    LIBUTIL.
				
.IFDEF MODS_OBJS_LIB_UTIL           # MODS_OBJS_LIB_UTIL

SUBSIDIARY = 1

MODS_LIB_UTIL = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_UTIL)))

DEPS = $(FOREACH NAME, $(MODS_LIB_UTIL), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_UTIL


#    LIBVMS.
				
.IFDEF MODS_OBJS_LIB_VMS            # MODS_OBJS_LIB_VMS

SUBSIDIARY = 1

MODS_LIB_VMS = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_VMS)))

DEPS = $(FOREACH NAME, $(MODS_LIB_VMS), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_VMS


#    TOOLS.
				
.IFDEF MODS_OBJS_LIB_TOOLS          # MODS_OBJS_LIB_TOOLS

SUBSIDIARY = 1

MODS_EXE_TOOLS = $(FILTER-OUT *], \
 $(PATSUBST *]*.EXE, *] *, $(EXES_TOOLS)))

DEPS = $(FOREACH NAME, $(MODS_EXE_TOOLS), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_TOOLS


#    ZLIB.
				
.IFDEF MODS_OBJS_LIB_ZLIB           # MODS_OBJS_LIB_ZLIB

SUBSIDIARY = 1

MODS_LIB_ZLIB = $(FILTER-OUT *], \
 $(PATSUBST *]*.OBJ, *] *, $(MODS_OBJS_LIB_ZLIB)))

DEPS = $(FOREACH NAME, $(MODS_LIB_ZLIB), $(NAME).MMSD)

.ENDIF                              # MODS_OBJS_LIB_ZLIB



# Rules and actions depend on circumstances, main or subsidiary.

.IFDEF SUBSIDIARY                   # SUBSIDIARY

# Default target is the comprehensive dependency list.

ALL : $(GENERATED_HEADERS) $(DEPS_FILE)
	@ write sys$output ""
	@ show time
	@ write sys$output ""
	@ write sys$output "   Dependencies done."
	@ write sys$output ""

$(DEPS_FILE) : $(DEPS) $(COMS)
.IF UNK_MMSD                            # UNK_MMSD
	@ write sys$output -
 "   /SKIP_INTERMEDIATES is expected on the MMS command line."
	@ write sys$output -
 "   For normal behavior (delete individual .MMSD files), specify ""/SKIP""."
	@ write sys$output -
 "   To retain the individual .MMSD files, specify ""/MACRO = NOSKIP=1""."
	@ exit %x00000004
.ENDIF                                  # UNK_MMSD
#
#       Note that the space in P3, which prevents immediate macro
#       expansion, is removed by COLLECT_DEPS.COM.
#
	@$(COLLECT_DEPS) "GnuPG for VMS" "$(MMS$TARGET)" -
	 "[...]*.MMSD" "[.$ (DEST)]" $(MMSDESCRIPTION_FILE) -
	 "[-." $(DEST)
	@ write sys$output -
	 "Created a new dependency file: $(MMS$TARGET)"
.IF DELETE_MMSD                         # DELETE_MMSD
	@ write sys$output -
	 "Deleting intermediate .MMSD files..."
	if (f$search( "*.MMSD") .nes. "") then -
	 delete /log *.MMSD;*
.ELSE                                   # DELETE_MMSD
	@ write sys$output -
	 "Purging intermediate .MMSD files..."
	if (f$search( "*.MMSD") .nes. "") then -
	 purge /keep = 2 /log *.MMSD
.ENDIF                                  # DELETE_MMSD [else]

# CLEAN target.  Delete the individual C dependency files.

CLEAN :
	if (f$search( "[...]*.MMSD") .nes. "") then -
	 delete [...]*.MMSD;*

# CLEAN_ALL target.  Delete:
#    The individual C dependency files.
#    The collected source dependency file.

CLEAN_ALL :
	if (f$search( "[...]*.MMSD") .nes. "") then -
	 delete [...]*.MMSD;*
	if (f$search( "DESCRIP_DEPS.MMS") .nes. "") then -
	 delete DESCRIP_DEPS.MMS;*

.ELSE                               # SUBSIDIARY

#
# Main target is the specified target, everywhere.
#
# Note that the first actions use the normal description file to create
# some generated header files, before they are referenced.
#

ALL, CLEAN, CLEAN_ALL, CLEAN_EXE, CLEAN_OLB : $(GENERATED_HEADERS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	show default
	set default [-.$(DIR_CHECKS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	show default
	set default [-.$(DIR_CIPHER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_G10)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_INTL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_KEYSERVER)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_MPI)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_TOOLS)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_UTIL)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_VMSLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)
	set default 'f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")'
	set default [-.$(DIR_ZLIB)]
	show default
	@ write sys$output ""
	$(MMS) /description = $(MMSDESCRIPTION_FILE) $(MMSQUALIFIERS) -
	 $(MMSTARGETS)

.ENDIF                              # SUBSIDIARY [else]

# Generated header files.

.IFDEF AM_IN_CHECKS                 # AM_IN_CHECKS
.ELSE                               # AM_IN_CHECKS
INCL_CONFIG_SRC = 1
.INCLUDE [-.VMS]DESCRIP_CONFIG.MMS
.ENDIF                              # AM_IN_CHECKS [else]


# Special rules file.

.IFDEF INCLUDE_DESCRIP_RULES        # INCLUDE_DESCRIP_RULES
INCL_DESCRIP_RULES = 1
.INCLUDE DESCRIP_RULES.MMS
.ENDIF                              # INCLUDE_DESCRIP_RULES

