#                                               6 December 2006.  SMS.
#
#    GnuPG for VMS - MMS (or MMK) Source Description File.
#

# This description file is included by other description files.  It is
# not intended to be used alone.  Verify proper inclusion.

.IFDEF INCL_DESCRIP_SRC_CMN_1
.ELSE
$$$$ THIS DESCRIPTION FILE IS NOT INTENDED TO BE USED THIS WAY.
.ENDIF


# Define MMK architecture macros when using MMS.

.IFDEF __MMK__                  # __MMK__
.ELSE                           # __MMK__
ALPHA_X_ALPHA = 1
IA64_X_IA64 = 1
VAX_X_VAX = 1
.IFDEF $(MMS$ARCH_NAME)_X_ALPHA     # $(MMS$ARCH_NAME)_X_ALPHA
__ALPHA__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_ALPHA
.IFDEF $(MMS$ARCH_NAME)_X_IA64      # $(MMS$ARCH_NAME)_X_IA64
__IA64__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_IA64
.IFDEF $(MMS$ARCH_NAME)_X_VAX       # $(MMS$ARCH_NAME)_X_VAX
__VAX__ = 1
.ENDIF                              # $(MMS$ARCH_NAME)_X_VAX
.ENDIF                          # __MMK__ [else]

# Analyze architecture-related and option macros.

.IFDEF __ALPHA__                # __ALPHA__
DESTM = ALPHA
ARCH_CURL = axp
.ELSE                           # __ALPHA__
.IFDEF __IA64__                     # __IA64__
DESTM = IA64
ARCH_CURL = ia64
.ELSE                               # __IA64__
.IFDEF __VAX__                          # __VAX__
DESTM = VAX
ARCH_CURL = vax
.ELSE                                   # __VAX__
DESTM = UNK
UNK_DEST = 1
.ENDIF                                  # __VAX__ [else]
.ENDIF                              # __IA64__ [else]
.ENDIF                          # __ALPHA__ [else]

.IFDEF LARGE                    # LARGE
.IFDEF __VAX__                      # __VAX__
DESTL =
.ELSE                               # __VAX__
DESTL = L
.ENDIF                              # __VAX__ [else]
.ELSE                           # LARGE
DESTL =
.ENDIF                          # LARGE [else]

DEST = $(DESTM)$(DESTL)


# Check for option problems.

.IFDEF __VAX__                  # __VAX__
.IFDEF LARGE                        # LARGE
LARGE_VAX = 1
.ENDIF                              # LARGE
.ENDIF                          # __VAX__


# Absence of MMSDESCRIPTION_FILE.

.IFDEF MMSDESCRIPTION_FILE      # MMSDESCRIPTION_FILE
.ELSE                           # MMSDESCRIPTION_FILE
NO_MMSDESCRIPTION_FILE = 1
.ENDIF                          # MMSDESCRIPTION_FILE [else]


# Subsidiary directory names.  (Note: DEST must be defined first.)

DIR_CHECKS     = checks
DIR_CIPHER     = cipher
DIR_DOC        = doc
DIR_G10        = g10
DIR_INTL       = intl
DIR_KEYSERVER  = keyserver
DIR_MPI        = mpi
DIR_TOOLS      = tools
DIR_UTIL       = util
DIR_VMSLIB     = vmslib
DIR_ZLIB       = zlib


# Executable (and main program object) names.

GPG_EXE = [-.$(DIR_G10).$(DEST)]GPG.EXE
GPG_OBJ = [.$(DEST)]GPG.OBJ

GPGV_EXE = [-.$(DIR_G10).$(DEST)]GPGV.EXE
GPGV_OBJ = [.$(DEST)]GPGV.OBJ

EXES_G10 = $(GPG_EXE) $(GPGV_EXE)

GPGKEYS_CURL_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_CURL.EXE
GPGKEYS_CURL_OBJ = [.$(DEST)]GPGKEYS_CURL.OBJ

GPGKEYS_CURL_RC_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_CURL_RC.EXE
GPGKEYS_CURL_RC_OBJ = [.$(DEST)]GPGKEYS_CURL_RC.OBJ

GPGKEYS_FINGER_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_FINGER.EXE
GPGKEYS_FINGER_OBJ = [.$(DEST)]GPGKEYS_FINGER.OBJ

GPGKEYS_HKP_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_HKP.EXE
GPGKEYS_HKP_OBJ = [.$(DEST)]GPGKEYS_HKP.OBJ

GPGKEYS_HKP_RC_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_HKP_RC.EXE
GPGKEYS_HKP_RC_OBJ = [.$(DEST)]GPGKEYS_HKP_RC.OBJ

GPGKEYS_LDAP_EXE = [-.$(DIR_KEYSERVER).$(DEST)]GPGKEYS_LDAP.EXE
GPGKEYS_LDAP_OBJ = [.$(DEST)]GPGKEYS_LDAP.OBJ

EXES_KEYSERVER_BASE = \
 $(GPGKEYS_CURL_EXE) \
 $(GPGKEYS_FINGER_EXE) \
 $(GPGKEYS_HKP_EXE)


.IFDEF GPG_CURL                 # GPG_CURL

EXES_KEYSERVER_RC = \
 $(GPGKEYS_CURL_RC_EXE) \
 $(GPGKEYS_HKP_RC_EXE)

.ENDIF                          # GPG_CURL


.IFDEF GPG_LDAP                 # GPG_LDAP

EXES_KEYSERVER_LDAP = \
 $(GPGKEYS_LDAP_EXE)

.ENDIF                          # GPG_LDAP

EXES_KEYSERVER = \
 $(EXES_KEYSERVER_BASE) $(EXES_KEYSERVER_RC) $(EXES_KEYSERVER_LDAP)


BFTEST_EXE = [-.$(DIR_TOOLS).$(DEST)]BFTEST.EXE
BFTEST_OBJ = [.$(DEST)]BFTEST.OBJ

CLEAN_SAT_EXE = [-.$(DIR_TOOLS).$(DEST)]CLEAN-SAT.EXE
CLEAN_SAT_OBJ = [.$(DEST)]CLEAN-SAT.OBJ

GPGSPLIT_EXE = [-.$(DIR_TOOLS).$(DEST)]GPGSPLIT.EXE
GPGSPLIT_OBJ = [.$(DEST)]GPGSPLIT.OBJ

MAKE_DNS_CERT_EXE = [-.$(DIR_TOOLS).$(DEST)]MAKE-DNS-CERT.EXE
MAKE_DNS_CERT_OBJ = [.$(DEST)]MAKE-DNS-CERT.OBJ

MK_TDATA_EXE = [-.$(DIR_TOOLS).$(DEST)]MK-TDATA.EXE
MK_TDATA_OBJ = [.$(DEST)]MK-TDATA.OBJ

MPICALC_EXE = [-.$(DIR_TOOLS).$(DEST)]MPICALC.EXE
MPICALC_OBJ = [.$(DEST)]MPICALC.OBJ

SHMTEST_EXE = [-.$(DIR_TOOLS).$(DEST)]SHMTEST.EXE
SHMTEST_OBJ = [.$(DEST)]SHMTEST.OBJ

EXES_TOOLS = \
 $(BFTEST_EXE) \
 $(CLEAN_SAT_EXE) \
 $(GPGSPLIT_EXE) \
 $(MAKE_DNS_CERT_EXE) \
 $(MK_TDATA_EXE) \
 $(MPICALC_EXE) \
 $(SHMTEST_EXE)


DECC_VER_EXE = [-.$(DIR_VMSLIB).$(DEST)]DECC_VER.EXE


# CHECKS preparation time-stamp file.

PREP_TIMESTAMP = [-.$(DIR_CHECKS).$(DEST)]PREPARED.STAMP

