#                                               11 August 2006.  SMS.
#
#    GnuPG for VMS - MMS (or MMK) Source Description File.
#

# This description file is included by other description files.  It is
# not intended to be used alone.  Verify proper inclusion.

.IFDEF INCL_DESCRIP_SRC_CMN_2
.ELSE
$$$$ THIS DESCRIPTION FILE IS NOT INTENDED TO BE USED THIS WAY.
.ENDIF # INCL_DESCRIP_SRC_CMN_2


# Complain if warranted.  Otherwise, show destination directory.
# Make the destination directories, if necessary.
				
.IFDEF UNK_DEST                 # UNK_DEST
.FIRST
	@ write sys$output -
 "   Unknown system architecture."
.IFDEF __MMK__                      # __MMK__
	@ write sys$output -
 "   MMK on IA64?  Try adding ""/MACRO = __IA64__""."
.ELSE                               # __MMK__
	@ write sys$output -
 "   MMS too old?  Try adding ""/MACRO = MMS$ARCH_NAME=ALPHA"","
	@ write sys$output -
 "   or ""/MACRO = MMS$ARCH_NAME=IA64"", or ""/MACRO = MMS$ARCH_NAME=VAX"","
	@ write sys$output -
 "   as appropriate.  (Or try a newer version of MMS.)"
.ENDIF                              # __MMK__ [else]
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                           # UNK_DEST
.IFDEF LARGE_VAX                    # LARGE_VAX
.FIRST
	@ write sys$output -
 "   Macro ""LARGE"" is invalid on VAX."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                               # LARGE_VAX
.IFDEF NO_MMSDESCRIPTION_FILE           # NO_MMSDESCRIPTION_FILE
.FIRST
	@ write sys$output -
 "   Macro ""MMSDESCRIPTION_FILE"" is not defined as required."
	@ write sys$output -
 "   MMK, or MMS too old?  Try adding:"
	@ write sys$output -
 "   ""/MACRO = MMSDESCRIPTION_FILE=dev:[dir]description_file"","
	@ write sys$output -
 "   as appropriate, where ""dev:[dir]description_file"" is the full path"
	@ write sys$output -
 "   to the MMS/MMK description file being used (typically ""DESCRIP.MMS"")."
	@ write sys$output ""
	I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                                   # NO_MMSDESCRIPTION_FILE
.FIRST
	@ write sys$output ""
	@ show time
	@ write sys$output ""
	@ write sys$output "   Destination: [.$(DEST)]"
	@ write sys$output ""
.IFDEF GPG_BZIP2                        # GPG_BZIP2
	@ if (f$trnlnm( "incl_bzip2") .eqs. "") then -
	   define incl_bzip2 $(GPG_BZIP2)
	@ if (f$trnlnm( "lib_bzip2") .eqs. "") then -
	   @[-.vms]find_bzip2_lib.com $(GPG_BZIP2) $(DEST) lib_bzip2
	@ if (f$trnlnm( "lib_bzip2") .nes. "") then -
	   write sys$output "   BZIP2 dir: ''f$trnlnm( "lib_bzip2")'"
	@ if (f$trnlnm( "lib_bzip2") .eqs. "") then -
	   write sys$output "   Can not find BZIP2 object library."
	@ write sys$output ""
	@ if (f$trnlnm( "lib_bzip2") .eqs. "") then -
	   I_WILL_DIE_NOW.  /$$$$INVALID$$$$
.ELSE                                   # GPG_BZIP2
	@ write sys$output "   No bzip2 support."
	@ write sys$output ""
.ENDIF                                  # GPG_BZIP2 [else]
.IFDEF GPG_CURL                         # GPG_CURL
	@ g_c = "$(GPG_CURL)"
	@ ! Remove a trailing colon before the logical name test.
	@ if (f$extract( (f$length( g_c)- 1), 1, g_c) .eqs. ":") then -
	   g_c = f$extract( 0, (f$length( g_c)- 1), g_c)
	@ ! If GPG_CURL is a logical name, use the equivalence name.
	@ g_c_eqv = f$trnlnm( g_c)
	@ if (g_c_eqv .nes. "") then -
	   g_c = g_c_eqv
	@ ! Save this name for the message.
	@ g_c_mess = g_c
	@ ! We make a rooted logical name from GPG_CURL, so if it
	@ ! already contains one, we need to substitute the equivalence
	@ ! name for the (apparent) device name.
	@ g_c_dev = f$parse( g_c, , , "device")- ":"
	@ g_c_dir = f$parse( g_c, , , "directory")
	@ g_c_dev_eqv = f$trnlnm( g_c_dev)
	@ if (g_c_dev_eqv .nes. "") then -
	   g_c_dev = g_c_dev_eqv
	@ if (f$locate( ":", g_c_dev) .ge. f$length( g_c_dev)) then -
	   g_c_dev = g_c_dev+ ":"
	@ ! Recombine the "device" and directory, removing any resulting
	@ ! "][" at the junction.
	@ g_c = g_c_dev+ g_c_dir- "]["
	@ x = (f$search( g_c+ "include.dir") .eqs. "")
	@ if (x) then -
	   write sys$output -
 "   Can not find cURL include directory where expected."
	@ if (x) then -
	   write sys$output ""
	@ if (x) then -
	   I_WILL_DIE_NOW.  /$$$$INVALID$$$$
	@ write sys$output "   CURL dir:  ''g_c_mess'"
	@ write sys$output ""
	@ curl_root = g_c- "]"+ ".]"
	@ if (f$trnlnm( "curl_root") .eqs. "") then -
	   define /translation_attributes = concealed curl_root -
	   'curl_root'
	@ if (f$trnlnm( "curl") .eqs. "") then -
	   define curl curl_root:[include.curl]
.ELSE                                   # GPG_CURL
	@ write sys$output "   Using GnuPG cURL emulation."
	@ write sys$output ""
.ENDIF                                  # GPG_CURL [else]
.IFDEF GPG_LDAP                         # GPG_LDAP
	@ x = (f$search( "SYS$SHARE:LDAP$SHR.EXE") .eqs. "")
	@ if (x) then -
	   write sys$output -
 "   Can not find LDAP shareable image, SYS$SHARE:LDAP$SHR.EXE."
	@ if (x) then -
	   write sys$output ""
	@ if (x) then -
	   I_WILL_DIE_NOW.  /$$$$INVALID$$$$
	@ write sys$output "   LDAP support enabled."
	@ write sys$output ""
.ELSE                                   # GPG_LDAP
	@ write sys$output "   No LDAP support."
	@ write sys$output ""
.ENDIF                                  # GPG_LDAP [else]
.IFDEF ALL_DEST_DIRS_NEEDED             # ALL_DEST_DIRS_NEEDED
	@ ! Create all destination directories first.
	if (f$search( "[-.$(DIR_CHECKS)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_CHECKS).$(DEST)]
	if (f$search( "[-.$(DIR_CIPHER)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_CIPHER).$(DEST)]
	if (f$search( "[-.$(DIR_G10)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_G10).$(DEST)]
	if (f$search( "[-.$(DIR_INTL)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_INTL).$(DEST)]
	if (f$search( "[-.$(DIR_KEYSERVER)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_KEYSERVER).$(DEST)]
	if (f$search( "[-.$(DIR_MPI)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_MPI).$(DEST)]
	if (f$search( "[-.$(DIR_TOOLS)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_TOOLS).$(DEST)]
	if (f$search( "[-.$(DIR_UTIL)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_UTIL).$(DEST)]
	if (f$search( "[-.$(DIR_VMSLIB)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_VMSLIB).$(DEST)]
	if (f$search( "[-.$(DIR_ZLIB)]$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [-.$(DIR_ZLIB).$(DEST)]
.ELSE                                       # ALL_DEST_DIRS_NEEDED
.IFDEF LOCAL                                    # LOCAL
	@ ! Create this specific destination directory first.
	if (f$search( "$(DEST).DIR;1") .eqs. "") then -
	 create /directory /log [.$(DEST)]
.ENDIF                                          # LOCAL
.ENDIF                                      # ALL_DEST_DIRS_NEEDED [else]
	sys = f$parse( "$(MMSDESCRIPTION_FILE)", , , "DEVICE")+ -
	 f$parse( "$(MMSDESCRIPTION_FILE)", , , "DIRECTORY")
	@ if (f$trnlnm( "sys") .eqs. "") then -
	   define sys 'sys'
	@ ! Define "backport" C RTL logical names as needed, that is,
	@ ! VMS version < 7.0, and logical name not already defined.
	v_v = f$getsyi( "VERSION")
	v_v = f$extract( 1, (f$locate( ".", v_v)- 1), v_v)
	if ((v_v .lt. 7) .and. (f$trnlnm( "DECC$CRTLMAP") .eqs. "")) then -
	 define DECC$CRTLMAP SYS$LIBRARY:DECC$CRTL.EXE
	if ((v_v .lt. 7) .and. (f$trnlnm( "LNK$LIBRARY") .eqs. "")) then -
	 define LNK$LIBRARY SYS$LIBRARY:DECC$CRTL.OLB
.ENDIF                                  # NO_MMSDESCRIPTION_FILE [else]
.ENDIF                              # LARGE_VAX [else]
.ENDIF                          # UNK_DEST [else]

